/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction.strategies;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.1.0", forRemoval=true)
public class BasicCompactionStrategy
extends DefaultCompactionStrategy {
    private static final Logger log = LoggerFactory.getLogger(BasicCompactionStrategy.class);
    public static final String SIZE_LIMIT_OPT = "filter.size";
    public static final String LARGE_FILE_COMPRESSION_THRESHOLD = "large.compress.threshold";
    public static final String LARGE_FILE_COMPRESSION_TYPE = "large.compress.type";
    private Long filterSize;
    private Long largeThresh;
    private String largeCompress;

    @Override
    public void init(Map<String, String> options) {
        String limitVal = options.get(SIZE_LIMIT_OPT);
        if (limitVal != null) {
            this.filterSize = ConfigurationTypeHelper.getFixedMemoryAsBytes((String)limitVal);
        }
        String largeThresh = options.get(LARGE_FILE_COMPRESSION_THRESHOLD);
        String largeCompress = options.get(LARGE_FILE_COMPRESSION_TYPE);
        if (largeThresh != null && largeCompress != null) {
            this.largeThresh = ConfigurationTypeHelper.getFixedMemoryAsBytes((String)largeThresh);
            this.largeCompress = largeCompress;
        } else if (largeThresh != null ^ largeCompress != null) {
            throw new IllegalArgumentException("Must set both of " + String.valueOf(Property.TABLE_COMPACTION_STRATEGY_PREFIX) + " (large.compress.type and large.compress.threshold) or neither for " + this.getClass().getName());
        }
    }

    @Override
    public boolean shouldCompact(MajorCompactionRequest request) {
        return super.shouldCompact(this.filterFiles(request));
    }

    @Override
    public void gatherInformation(MajorCompactionRequest request) throws IOException {
        super.gatherInformation(this.filterFiles(request));
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        Long totalSize;
        request = this.filterFiles(request);
        CompactionPlan plan = super.getCompactionPlan(request);
        if (this.largeThresh != null && (totalSize = this.calculateTotalSize(request, plan)) > this.largeThresh) {
            plan.writeParameters = new WriteParameters();
            if (log.isDebugEnabled()) {
                log.debug("Changed compressType to {}: totalSize({}) was greater than threshold {}", new Object[]{this.largeCompress, totalSize, this.largeThresh});
            }
            plan.writeParameters.setCompressType(this.largeCompress);
        }
        return plan;
    }

    private MajorCompactionRequest filterFiles(MajorCompactionRequest mcr) {
        if (this.filterSize != null) {
            HashMap<StoredTabletFile, DataFileValue> filteredFiles = new HashMap<StoredTabletFile, DataFileValue>();
            mcr.getFiles().forEach((fr, dfv) -> {
                if (dfv.getSize() <= this.filterSize) {
                    filteredFiles.put((StoredTabletFile)fr, (DataFileValue)dfv);
                }
            });
            mcr = new MajorCompactionRequest(mcr);
            mcr.setFiles(filteredFiles);
        }
        return mcr;
    }

    private Long calculateTotalSize(MajorCompactionRequest request, CompactionPlan plan) {
        long totalSize = 0L;
        Map<StoredTabletFile, DataFileValue> allFiles = request.getFiles();
        for (StoredTabletFile fileRef : plan.inputFiles) {
            totalSize += allFiles.get(fileRef).getSize();
        }
        return totalSize;
    }
}

