/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.apache.zookeeper.common.CertificatesToPlayWith;
import org.apache.zookeeper.common.ZKHostnameVerifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZKHostnameVerifierTest {
    private ZKHostnameVerifier impl;

    @BeforeEach
    public void setup() {
        this.impl = new ZKHostnameVerifier();
    }

    @Test
    public void testVerify() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_THREE_CNS_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.impl.verify("www.foo.com", x509);
        this.impl.verify("\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_CO_JP);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.co.jp", x509);
        this.impl.verify("foo.co.jp", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "www.foo.com", x509);
        this.exceptionPlease(this.impl, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.impl.verify("www.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.bar.com", x509);
        this.exceptionPlease(this.impl, "a.b.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_VALUE_AVA);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("repository.infonotary.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.S_GOOGLE_COM);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.google.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.S_GOOGLE_COM);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.Google.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.IP_1_1_1_1);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("1.1.1.1", x509);
        this.exceptionPlease(this.impl, "1.1.1.2", x509);
        this.exceptionPlease(this.impl, "dummy-value.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.EMAIL_ALT_SUBJECT_NAME);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("www.company.com", x509);
    }

    private void exceptionPlease(ZKHostnameVerifier hv, String host, X509Certificate x509) {
        try {
            hv.verify(host, x509);
            Assertions.fail((String)("HostnameVerifier shouldn't allow [" + host + "]"));
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }
}

