/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.exceptions.OverCapacityException;

class WriteLimiter {
    String streamName;
    final PermitLimiter streamLimiter;
    final PermitLimiter globalLimiter;

    public WriteLimiter(String streamName, PermitLimiter streamLimiter, PermitLimiter globalLimiter) {
        this.streamName = streamName;
        this.streamLimiter = streamLimiter;
        this.globalLimiter = globalLimiter;
    }

    public void acquire() throws OverCapacityException {
        if (!this.streamLimiter.acquire()) {
            throw new OverCapacityException(String.format("Stream write capacity exceeded for stream %s", this.streamName));
        }
        try {
            if (!this.globalLimiter.acquire()) {
                throw new OverCapacityException("Global write capacity exceeded");
            }
        }
        catch (OverCapacityException ex) {
            this.streamLimiter.release(1);
            throw ex;
        }
    }

    public void release() {
        this.release(1);
    }

    public void release(int permits) {
        this.streamLimiter.release(permits);
        this.globalLimiter.release(permits);
    }

    public void close() {
        this.streamLimiter.close();
        this.globalLimiter.close();
    }
}

