/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmptySnapshotTest {
    @Test
    public void testNoEmptySnapshot() throws Exception {
        File tmpFile = File.createTempFile("empty-snapshot-test", ".junit", new File(System.getProperty("build.test.dir", "build")));
        File tmpDataDir = new File(tmpFile + ".dir");
        Assertions.assertFalse((boolean)tmpDataDir.exists());
        Assertions.assertTrue((boolean)tmpDataDir.mkdirs());
        FileTxnSnapLog snapLog = new FileTxnSnapLog(tmpDataDir, tmpDataDir);
        snapLog.snapLog = new MockFileSnap(snapLog.dataDir);
        Assertions.assertEquals((int)0, (int)((FileSnap)snapLog.snapLog).findNRecentSnapshots(10).size());
        DataTree tree = new DataTree();
        tree.createNode("/empty-snapshot-test-1", "data".getBytes(), null, -1L, -1, 1L, 1L);
        try {
            snapLog.save(tree, new ConcurrentHashMap(), false);
            Assertions.fail((String)"Should have thrown an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)((FileSnap)snapLog.snapLog).findNRecentSnapshots(10).size());
        snapLog.snapLog = new FileSnap(snapLog.dataDir);
        snapLog.save(tree, new ConcurrentHashMap(), false);
        Assertions.assertEquals((int)1, (int)((FileSnap)snapLog.snapLog).findNRecentSnapshots(10).size());
    }

    static class MockFileSnap
    extends FileSnap {
        MockFileSnap(File snapDir) {
            super(snapDir);
        }

        public synchronized void serialize(DataTree dt, Map<Long, Integer> sessions, File snapShot, boolean fsync) throws IOException {
            Assertions.assertTrue((boolean)snapShot.createNewFile());
            throw new IOException("Created empty snapshot file from MockFileSnap::serialize()");
        }
    }
}

