/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteBufferInputStreamTest
extends ZKTestCase {
    private static final byte[] DATA_BYTES_0 = "Apache ZooKeeper".getBytes(StandardCharsets.UTF_8);
    private static byte[] DATA_BYTES;
    private ByteBuffer bb;
    private ByteBufferInputStream in;
    private byte[] bs;

    @BeforeAll
    public static void setUpClass() {
        int len = DATA_BYTES_0.length + 2;
        DATA_BYTES = new byte[len];
        System.arraycopy(DATA_BYTES_0, 0, DATA_BYTES, 0, DATA_BYTES_0.length);
        ByteBufferInputStreamTest.DATA_BYTES[len - 2] = 0;
        ByteBufferInputStreamTest.DATA_BYTES[len - 1] = -1;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.bb = ByteBuffer.wrap(DATA_BYTES);
        this.in = new ByteBufferInputStream(this.bb);
        this.bs = new byte[]{1, 2, 3, 4};
    }

    @Test
    public void testRead() throws Exception {
        for (int i = 0; i < DATA_BYTES.length; ++i) {
            int b = this.in.read();
            Assertions.assertEquals((byte)DATA_BYTES[i], (byte)((byte)b));
        }
        Assertions.assertEquals((int)-1, (int)this.in.read());
    }

    @Test
    public void testReadArrayOffsetLength() throws Exception {
        Assertions.assertEquals((int)1, (int)this.in.read(this.bs, 2, 1));
        byte[] expected = new byte[]{1, 2, DATA_BYTES[0], 4};
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArrayOffsetLength_LengthTooLarge() throws Exception {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.in.read(this.bs, 2, 3));
    }

    @Test
    public void testReadArrayOffsetLength_HitEndOfStream() throws Exception {
        for (int i = 0; i < DATA_BYTES.length - 1; ++i) {
            this.in.read();
        }
        Assertions.assertEquals((int)1, (int)this.in.read(this.bs, 2, 2));
        byte[] expected = new byte[]{1, 2, DATA_BYTES[DATA_BYTES.length - 1], 4};
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArrayOffsetLength_AtEndOfStream() throws Exception {
        for (int i = 0; i < DATA_BYTES.length; ++i) {
            this.in.read();
        }
        byte[] expected = Arrays.copyOf(this.bs, this.bs.length);
        Assertions.assertEquals((int)-1, (int)this.in.read(this.bs, 2, 2));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArrayOffsetLength_0Length() throws Exception {
        byte[] expected = Arrays.copyOf(this.bs, this.bs.length);
        Assertions.assertEquals((int)0, (int)this.in.read(this.bs, 2, 0));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArray() throws Exception {
        byte[] expected = Arrays.copyOf(DATA_BYTES, 4);
        Assertions.assertEquals((int)4, (int)this.in.read(this.bs));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testSkip() throws Exception {
        this.in.read();
        Assertions.assertEquals((long)2L, (long)this.in.skip(2L));
        Assertions.assertEquals((int)DATA_BYTES[3], (int)this.in.read());
        Assertions.assertEquals((int)DATA_BYTES[4], (int)this.in.read());
    }

    @Test
    public void testSkip2() throws Exception {
        for (int i = 0; i < DATA_BYTES.length / 2; ++i) {
            this.in.read();
        }
        long skipAmount = DATA_BYTES.length / 4;
        Assertions.assertEquals((long)skipAmount, (long)this.in.skip(skipAmount));
        int idx = DATA_BYTES.length / 2 + (int)skipAmount;
        Assertions.assertEquals((int)DATA_BYTES[idx++], (int)this.in.read());
        Assertions.assertEquals((int)DATA_BYTES[idx++], (int)this.in.read());
    }

    @Test
    public void testNegativeSkip() throws Exception {
        this.in.read();
        Assertions.assertEquals((long)0L, (long)this.in.skip(-2L));
        Assertions.assertEquals((int)DATA_BYTES[1], (int)this.in.read());
        Assertions.assertEquals((int)DATA_BYTES[2], (int)this.in.read());
    }

    @Test
    public void testSkip_HitEnd() throws Exception {
        for (int i = 0; i < DATA_BYTES.length - 1; ++i) {
            this.in.read();
        }
        Assertions.assertEquals((long)1L, (long)this.in.skip(2L));
        Assertions.assertEquals((int)-1, (int)this.in.read());
    }

    @Test
    public void testSkip_AtEnd() throws Exception {
        for (int i = 0; i < DATA_BYTES.length; ++i) {
            this.in.read();
        }
        Assertions.assertEquals((long)0L, (long)this.in.skip(2L));
        Assertions.assertEquals((int)-1, (int)this.in.read());
    }

    @Test
    public void testAvailable() throws Exception {
        for (int i = DATA_BYTES.length; i > 0; --i) {
            Assertions.assertEquals((int)i, (int)this.in.available());
            this.in.read();
        }
        Assertions.assertEquals((int)0, (int)this.in.available());
    }
}

