/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AuthTest
extends ClientBase {
    private final CountDownLatch authFailed = new CountDownLatch(1);

    @BeforeAll
    public static void setup() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.test.InvalidAuthProvider");
    }

    @AfterAll
    public static void teardown() {
        System.clearProperty("zookeeper.DigestAuthenticationProvider.superDigest");
        System.clearProperty("zookeeper.DigestAuthenticationProvider.digestAlg");
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    @Test
    public void testBadAuthNotifiesWatch() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.addAuthInfo("FOO", "BAR".getBytes());
            zk.getData("/path1", false, null);
            Assertions.fail((String)"Should get auth state error");
        }
    }

    @Test
    public void testBadAuthThenSendOtherCommands() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.addAuthInfo("INVALID", "BAR".getBytes());
            zk.exists("/foobar", false);
            zk.getData("/path1", false, null);
            Assertions.fail((String)"Should get auth state error");
        }
    }

    @Test
    public void testSuper() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.addAuthInfo("digest", "pat:pass".getBytes());
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            try {
                zk.getData("/path1", false, null);
                Assertions.fail((String)"auth verification");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "pat:pass2".getBytes());
            try {
                zk.getData("/path1", false, null);
                Assertions.fail((String)"auth verification");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test2".getBytes());
            try {
                zk.getData("/path1", false, null);
                Assertions.fail((String)"auth verification");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test".getBytes());
            zk.getData("/path1", false, null);
        }
    }

    @Test
    public void testSuperACL() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.addAuthInfo("digest", "pat:pass".getBytes());
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test".getBytes());
            zk.getData("/path1", false, null);
            zk.setACL("/path1", ZooDefs.Ids.READ_ACL_UNSAFE, -1);
            zk.create("/path1/foo", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.setACL("/path1", ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrdinaryACL() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            String path = "/path1";
            zk.create(path, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.addAuthInfo("digest", "username1:password1".getBytes());
            ArrayList<ACL> list = new ArrayList<ACL>();
            int perm = 31;
            String userPassword = "username1:password1";
            Id id = new Id("auth", userPassword);
            list.add(new ACL(perm, id));
            zk.setACL(path, list, -1);
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test".getBytes());
            zk.getData(path, false, null);
            zk.close();
            zk = this.createClient();
            try {
                zk.getData(path, false, null);
                Assertions.fail((String)"should have NoAuthException");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.addAuthInfo("digest", "username1:password1".getBytes());
            zk.getData(path, false, null);
        }
    }

    @Test
    public void testGenerateDigest() throws NoSuchAlgorithmException {
        Assertions.assertEquals((Object)"super:D/InIHSb7yEEbrWz8b9l71RjZJU=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:test"));
        Assertions.assertEquals((Object)"super:yyuhPKumRtNj4r8GnSbbwuq1vhE=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:zookeeper"));
        Assertions.assertEquals((Object)"super:t6lQTvqID/Gl5Or0n4FYE6kKP8w=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:foo"));
        Assertions.assertEquals((Object)"super:hTdNN4QH4isoRvCrQ1Jf7REREQ4=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:bar"));
    }

    @Test
    public void testDigest() throws NoSuchAlgorithmException {
        Assertions.assertEquals((Object)"a94a8fe5ccb19ba61c4c0873d391e987982fbbd3", (Object)AuthTest.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"test")));
        Assertions.assertEquals((Object)"8a0444ded963cf1118dd34aa1acaafec268c654d", (Object)AuthTest.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"zookeeper")));
        Assertions.assertEquals((Object)"0beec7b5ea3f0fdbc95d0dd47f3c5bc275da8a33", (Object)AuthTest.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"foo")));
        Assertions.assertEquals((Object)"62cdb7020ff920e5aa642c3d4066950dd1f01f4d", (Object)AuthTest.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"bar")));
    }

    protected static String getGeneratedDigestStr(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static enum DigestAlgEnum {
        SHA_1("SHA1"),
        SHA_256("SHA-256"),
        SHA3_256("SHA3-256");

        private String name;

        private DigestAlgEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static List<String> getValues() {
            ArrayList<String> digestList = new ArrayList<String>();
            for (DigestAlgEnum digest : DigestAlgEnum.values()) {
                digestList.add(digest.getName());
            }
            return digestList;
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                AuthTest.this.authFailed.countDown();
            } else {
                super.process(event);
            }
        }
    }
}

