/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameterized;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServerConnection;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.Output;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.cli.CommandLauncher;

@Command(name="sjk", description="Run commands of 'Swiss Java Knife'. Run 'nodetool sjk --help' for more information.")
public class Sjk
extends NodeTool.NodeToolCmd {
    @Arguments(description="Arguments passed as is to 'Swiss Java Knife'.")
    private List<String> args;
    private final Wrapper wrapper = new Wrapper();

    @Override
    public void runInternal() {
        String[] stringArray;
        if (this.args != null) {
            stringArray = this.args.toArray(new String[0]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "help";
        }
        this.wrapper.prepare(stringArray, this.output.out, this.output.err);
        if (!this.wrapper.requiresMbeanServerConn()) {
            this.wrapper.run(null, this.output);
        } else {
            super.runInternal();
        }
    }

    public void sequenceRun(NodeProbe probe) {
        String[] stringArray;
        if (this.args != null) {
            stringArray = this.args.toArray(new String[0]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "help";
        }
        this.wrapper.prepare(stringArray, probe.output().out, probe.output().err);
        if (!this.wrapper.run(probe, probe.output())) {
            probe.failed();
        }
    }

    @Override
    protected void execute(NodeProbe probe) {
        if (!this.wrapper.run(probe, probe.output())) {
            probe.failed();
        }
    }

    public static class Wrapper
    extends CommandLauncher {
        boolean suppressSystemExit;
        private final Map<String, Runnable> commands = new HashMap<String, Runnable>();
        private JCommander parser;
        private Runnable cmd;

        public void suppressSystemExit() {
            this.suppressSystemExit = true;
            super.suppressSystemExit();
        }

        public boolean start(String[] args) {
            throw new UnsupportedOperationException();
        }

        public void prepare(String[] args, PrintStream out, PrintStream err) {
            try {
                this.parser = new JCommander((Object)this);
                this.addCommands();
                this.fixCommands();
                try {
                    this.parser.parse(args);
                }
                catch (Exception e) {
                    this.failAndPrintUsage(new String[]{e.toString()});
                }
                if (this.isHelp()) {
                    String cmd = this.parser.getParsedCommand();
                    if (cmd == null) {
                        this.parser.usage();
                    } else {
                        this.parser.usage(cmd);
                    }
                } else if (this.isListCommands()) {
                    for (String cmd : this.commands.keySet()) {
                        out.println(String.format("%8s - %s", cmd, this.parser.getCommandDescription(cmd)));
                    }
                } else {
                    this.cmd = this.commands.get(this.parser.getParsedCommand());
                    if (this.cmd == null) {
                        this.failAndPrintUsage(new String[0]);
                    }
                }
            }
            catch (CommandLauncher.CommandAbortedError error) {
                for (String m : error.messages) {
                    err.println(m);
                }
                if (this.isVerbose() && error.getCause() != null) {
                    error.getCause().printStackTrace(err);
                }
                if (error.printUsage && this.parser != null) {
                    this.printUsage(this.parser, out, this.parser.getParsedCommand());
                }
            }
            catch (Throwable e) {
                e.printStackTrace(err);
            }
        }

        void printUsage(JCommander parser, PrintStream out, String optionalCommand) {
            StringBuilder sb = new StringBuilder();
            if (optionalCommand != null) {
                parser.usage(sb, optionalCommand);
            } else {
                parser.usage(sb);
            }
            out.println(sb.toString());
        }

        public boolean run(NodeProbe probe, Output output) {
            PrintStream out = output.out;
            PrintStream err = output.err;
            try {
                this.setJmxConnInfo(probe);
                if (this.cmd != null) {
                    this.cmd.run();
                }
                return true;
            }
            catch (CommandLauncher.CommandAbortedError error) {
                for (String m : error.messages) {
                    err.println(m);
                }
                if (this.isVerbose() && error.getCause() != null) {
                    error.getCause().printStackTrace(err);
                }
                if (error.printUsage && this.parser != null) {
                    this.printUsage(this.parser, out, this.parser.getParsedCommand());
                }
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace(err);
                return false;
            }
        }

        private void setJmxConnInfo(final NodeProbe probe) throws IllegalAccessException {
            Field f = Wrapper.jmxConnectionInfoField(this.cmd);
            if (f != null) {
                f.setAccessible(true);
                f.set(this.cmd, new JmxConnectionInfo(this){

                    public MBeanServerConnection getMServer() {
                        return probe.getMbeanServerConn();
                    }
                });
            }
            if ((f = Wrapper.pidField(this.cmd)) != null) {
                long pid = probe.getPid();
                f.setAccessible(true);
                if (f.getType() == Integer.TYPE) {
                    f.setInt(this.cmd, (int)pid);
                }
                if (f.getType() == Long.TYPE) {
                    f.setLong(this.cmd, pid);
                }
                if (f.getType() == String.class) {
                    f.set(this.cmd, Long.toString(pid));
                }
            }
        }

        private boolean isHelp() {
            try {
                Field f = CommandLauncher.class.getDeclaredField("help");
                f.setAccessible(true);
                return f.getBoolean((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isListCommands() {
            try {
                Field f = CommandLauncher.class.getDeclaredField("listCommands");
                f.setAccessible(true);
                return f.getBoolean((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected List<String> getCommandPackages() {
            return Collections.singletonList("org.gridkit.jvmtool.cmd");
        }

        private void addCommands() throws InstantiationException, IllegalAccessException {
            for (String pack : this.getCommandPackages()) {
                for (Class<?> c : Wrapper.findClasses(pack)) {
                    if (!CommandLauncher.CmdRef.class.isAssignableFrom(c)) continue;
                    CommandLauncher.CmdRef cmd = (CommandLauncher.CmdRef)c.newInstance();
                    String cmdName = cmd.getCommandName();
                    Runnable cmdTask = cmd.newCommand((CommandLauncher)this);
                    if (this.commands.containsKey(cmdName)) {
                        this.fail(new String[]{"Ambiguous implementation for '" + cmdName + "'"});
                    }
                    this.commands.put(cmdName, cmdTask);
                    this.parser.addCommand(cmdName, (Object)cmdTask);
                }
            }
        }

        private void fixCommands() throws Exception {
            List<Field> fields = Arrays.asList(JCommander.class.getDeclaredField("m_fields"), JCommander.class.getDeclaredField("m_requiredFields"));
            for (Field f : fields) {
                f.setAccessible(true);
            }
            for (JCommander cmdr : this.parser.getCommands().values()) {
                for (Field field : fields) {
                    Map fieldsMap = (Map)field.get(cmdr);
                    Iterator iPar = fieldsMap.entrySet().iterator();
                    while (iPar.hasNext()) {
                        Map.Entry par = iPar.next();
                        switch (((Parameterized)par.getKey()).getName()) {
                            case "pid": 
                            case "sockAddr": 
                            case "user": 
                            case "password": 
                            case "verbose": 
                            case "help": 
                            case "listCommands": {
                                iPar.remove();
                            }
                        }
                    }
                }
            }
        }

        boolean requiresMbeanServerConn() {
            return Wrapper.jmxConnectionInfoField(this.cmd) != null || Wrapper.pidField(this.cmd) != null;
        }

        private static Field jmxConnectionInfoField(Runnable cmd) {
            if (cmd == null) {
                return null;
            }
            for (Field f : cmd.getClass().getDeclaredFields()) {
                if (f.getType() != JmxConnectionInfo.class) continue;
                return f;
            }
            return null;
        }

        private static Field pidField(Runnable cmd) {
            if (cmd == null) {
                return null;
            }
            for (Field f : cmd.getClass().getDeclaredFields()) {
                if (!"pid".equals(f.getName()) || f.getType() != Integer.TYPE && f.getType() != Long.TYPE && f.getType() != String.class) continue;
                return f;
            }
            return null;
        }

        private static List<Class<?>> findClasses(String packageName) {
            ArrayList result = new ArrayList();
            try {
                String path = packageName.replace('.', '/');
                for (String f : Wrapper.findFiles(path)) {
                    if (!f.endsWith(".class") || f.indexOf(36) >= 0) continue;
                    f = f.substring(0, f.length() - ".class".length());
                    f = f.replace('/', '.');
                    result.add(Class.forName(f));
                }
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static List<String> findFiles(String path) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> en = cl.getResources(path);
            while (en.hasMoreElements()) {
                URL u = en.nextElement();
                Wrapper.listFiles(result, u, path);
            }
            return result;
        }

        static void listFiles(List<String> results, URL packageURL, String path) throws IOException {
            if (packageURL.getProtocol().equals("jar")) {
                String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
                jarFileName = jarFileName.substring(5, jarFileName.indexOf(33));
                try (JarFile jf = new JarFile(jarFileName);){
                    Enumeration<JarEntry> jarEntries = jf.entries();
                    while (jarEntries.hasMoreElements()) {
                        String entryName = jarEntries.nextElement().getName();
                        if (!entryName.startsWith(path)) continue;
                        results.add(entryName);
                    }
                }
            } else {
                File dir = new File(packageURL.getFile());
                String cp = dir.canonicalPath();
                File root = dir;
                while (!cp.equals(new File(root, path).canonicalPath())) {
                    root = root.parent();
                }
                Wrapper.listFiles(results, root, dir);
            }
        }

        static void listFiles(List<String> names, File root, File dir) {
            String rootPath = root.absolutePath();
            if (dir.exists() && dir.isDirectory()) {
                for (File file : dir.tryList()) {
                    if (file.isDirectory()) {
                        Wrapper.listFiles(names, root, file);
                        continue;
                    }
                    String name = file.absolutePath().substring(rootPath.length() + 1);
                    name = name.replace('\\', '/');
                    names.add(name);
                }
            }
        }
    }
}

