/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authentication;

import java.nio.charset.StandardCharsets;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.DataObject;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.json.annotations.JsonGen;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpMethod;
import o.a.c.sidecar.client.shaded.io.vertx.core.json.JsonObject;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authentication.CredentialValidationException;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authentication.Credentials;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authentication.UsernamePasswordCredentialsConverter;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.impl.Codec;

@DataObject
@JsonGen(publicConverter=false)
public class UsernamePasswordCredentials
implements Credentials {
    private String password;
    private String username;

    protected UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public UsernamePasswordCredentials(JsonObject jsonObject) {
        UsernamePasswordCredentialsConverter.fromJson(jsonObject, this);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public UsernamePasswordCredentials setPassword(String password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordCredentials setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.username == null) {
            throw new CredentialValidationException("username cannot be null");
        }
        if (this.password == null) {
            throw new CredentialValidationException("password cannot be null");
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        UsernamePasswordCredentialsConverter.toJson(this, result);
        return result;
    }

    public String toString() {
        return this.toJson().encode();
    }

    @Override
    public UsernamePasswordCredentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        int spc;
        if (challenge != null && !"Basic".equalsIgnoreCase(challenge.substring(0, spc = challenge.indexOf(32)))) {
            throw new IllegalArgumentException("Only 'Basic' auth-scheme is supported");
        }
        this.checkValid(null);
        return this;
    }

    @Override
    public String toHttpAuthorization() {
        StringBuilder sb = new StringBuilder();
        if (this.username != null) {
            if (this.username.indexOf(58) != -1) {
                throw new IllegalArgumentException("Username cannot contain ':'");
            }
            sb.append(this.username);
        }
        sb.append(':');
        if (this.password != null) {
            sb.append(this.password);
        }
        return "Basic " + Codec.base64Encode(sb.toString().getBytes(StandardCharsets.UTF_8));
    }
}

