/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.request;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.cassandra.sidecar.client.HttpClientConfig;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.exception.RetriesExhaustedException;
import org.apache.cassandra.sidecar.client.request.BaseRequestTest;
import org.apache.cassandra.sidecar.client.request.FullSchemaRequestTestParameters;
import org.apache.cassandra.sidecar.client.request.GossipInfoRequestTestParameters;
import org.apache.cassandra.sidecar.client.request.ListSnapshotFilesRequestTestParameters;
import org.apache.cassandra.sidecar.client.request.NodeSettingsRequestTestParameters;
import org.apache.cassandra.sidecar.client.request.RequestTestParameters;
import org.apache.cassandra.sidecar.client.request.RingRequestForKeyspaceTestParameters;
import org.apache.cassandra.sidecar.client.request.RingRequestTestParameters;
import org.apache.cassandra.sidecar.client.request.SchemaRequestTestParameters;
import org.apache.cassandra.sidecar.client.request.TimeSkewRequestTestParameters;
import org.apache.cassandra.sidecar.client.selection.InstanceSelectionPolicy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public abstract class RequestExecutorTest<T>
extends BaseRequestTest {
    @AfterEach
    void cleanup() throws Exception {
        this.sidecarClient().close();
    }

    @ParameterizedTest(name="testHappyPath {index} => request={0}, async={1}")
    @ArgumentsSource(value=TestParameters.class)
    public void testHappyPath(RequestTestParameters<T> parameters, boolean async) throws Exception {
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(parameters.okResponseBody()));
            server.start();
            this.runTestScenario(parameters, RequestExecutorTest.buildRandomFromServerList(server), async);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((String)request.getHeader("User-Agent")).isEqualTo("sidecar-client-test/1.0.0");
        }
    }

    @ParameterizedTest(name="testRetriesOnTimeoutWithSlowServer {index} => request={0}, async={1}")
    @ArgumentsSource(value=TestParameters.class)
    public void testRetriesOnTimeoutWithSlowServer(RequestTestParameters<T> parameters, boolean async) throws Exception {
        String happyPathResponse = parameters.okResponseBody();
        MockWebServer slowServer = new MockWebServer();
        try (MockWebServer fastServer = new MockWebServer();){
            slowServer.enqueue(new MockResponse().setBodyDelay(5L, TimeUnit.MINUTES).setResponseCode(HttpResponseStatus.OK.code()).setBody(happyPathResponse));
            fastServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(happyPathResponse));
            slowServer.start();
            fastServer.start();
            this.runTestScenario(parameters, RequestExecutorTest.buildFromServerList(slowServer, fastServer), async);
            Assertions.assertThat((int)slowServer.getRequestCount()).isEqualTo(1);
            RecordedRequest requestToSlowServer = slowServer.takeRequest();
            Assertions.assertThat((String)requestToSlowServer.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((int)fastServer.getRequestCount()).isEqualTo(1);
            RecordedRequest requestToFastServer = fastServer.takeRequest();
            Assertions.assertThat((String)requestToFastServer.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((String)requestToFastServer.getHeader("User-Agent")).isEqualTo("sidecar-client-test/1.0.0");
        }
    }

    @ParameterizedTest(name="testRetriesWithServerReturningServerError {index} => request={0}, async={1}")
    @ArgumentsSource(value=TestParameters.class)
    public void testRetriesWithServerReturningServerError(RequestTestParameters<T> parameters, boolean async) throws Exception {
        try (MockWebServer serverErrorServer = new MockWebServer();
             MockWebServer normalOperatingServer = new MockWebServer();){
            serverErrorServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(parameters.serverErrorResponseBody()));
            normalOperatingServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(parameters.okResponseBody()));
            serverErrorServer.start();
            normalOperatingServer.start();
            this.runTestScenario(parameters, RequestExecutorTest.buildFromServerList(serverErrorServer, normalOperatingServer), async);
            Assertions.assertThat((int)serverErrorServer.getRequestCount()).isEqualTo(1);
            RecordedRequest requestToErrorServer = serverErrorServer.takeRequest();
            Assertions.assertThat((String)requestToErrorServer.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((int)normalOperatingServer.getRequestCount()).isEqualTo(1);
            RecordedRequest requestToNormalServer = normalOperatingServer.takeRequest();
            Assertions.assertThat((String)requestToNormalServer.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((String)requestToNormalServer.getHeader("User-Agent")).isEqualTo("sidecar-client-test/1.0.0");
        }
    }

    @ParameterizedTest(name="testWithSingleServerAndRetries {index} => request={0}, async={1}")
    @ArgumentsSource(value=TestParameters.class)
    public void testWithSingleServerAndRetries(RequestTestParameters<T> parameters, boolean async) throws Exception {
        try (MockWebServer server = new MockWebServer();){
            String serverErrorResponseBody = parameters.serverErrorResponseBody();
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(serverErrorResponseBody));
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(serverErrorResponseBody));
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(parameters.okResponseBody()));
            server.start();
            this.runTestScenario(parameters, RequestExecutorTest.buildFromServerList(server), async);
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(3);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((String)request.getHeader("User-Agent")).isEqualTo("sidecar-client-test/1.0.0");
        }
    }

    @ParameterizedTest(name="testWithSingleServerExhaustsRetries {index} => request={0}, async={1}")
    @ArgumentsSource(value=TestParameters.class)
    public void testWithSingleServerExhaustsRetries(RequestTestParameters<T> parameters, boolean async) throws Exception {
        String serverErrorResponseBody = parameters.serverErrorResponseBody();
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(serverErrorResponseBody));
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(serverErrorResponseBody));
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(serverErrorResponseBody));
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(parameters.okResponseBody()));
            server.start();
            Assertions.assertThatException().isThrownBy(() -> this.runTestScenario(parameters, RequestExecutorTest.buildFromServerList(server), async)).withCauseInstanceOf(RetriesExhaustedException.class).withMessageContaining("Unable to complete request '").withMessageContaining("' after 3 attempts");
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(3);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo(parameters.expectedEndpointPath());
            Assertions.assertThat((String)request.getHeader("User-Agent")).isEqualTo("sidecar-client-test/1.0.0");
        }
    }

    protected HttpClientConfig.Builder<?> httpClientConfigBuilder() {
        return new HttpClientConfig.Builder().userAgent("sidecar-client-test/1.0.0").ssl(false).timeoutMillis(100L).idleTimeoutMillis(100);
    }

    private void runTestScenario(RequestTestParameters<T> parameters, InstanceSelectionPolicy policy, boolean async) throws Exception {
        Object responseObject;
        RequestContext requestContext = parameters.specificRequest(this.builder(policy)).build();
        if (async) {
            CompletableFuture future = this.sidecarClient().executeRequestAsync(requestContext);
            responseObject = future.join();
            Assertions.assertThat((CompletableFuture)future).isDone();
        } else {
            responseObject = this.sidecarClient().executeRequest(requestContext, 20L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Object)responseObject).isNotNull();
        parameters.validateResponse(responseObject);
    }

    static class TestParameters
    implements ArgumentsProvider {
        private final List<RequestTestParameters<?>> requestTestParameters = Arrays.asList(new GossipInfoRequestTestParameters(), new NodeSettingsRequestTestParameters(), new RingRequestForKeyspaceTestParameters(), new RingRequestTestParameters(), new TimeSkewRequestTestParameters(), new FullSchemaRequestTestParameters(), new SchemaRequestTestParameters(), new ListSnapshotFilesRequestTestParameters());

        TestParameters() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(true, false).flatMap(async -> this.requestTestParameters.stream().map(p -> Arguments.arguments((Object[])new Object[]{p, async})));
        }
    }
}

