/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContextFactory;
import org.apache.cassandra.spark.bulkwriter.CassandraBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraCoordinatedBulkWriterContext;
import org.apache.cassandra.spark.common.stats.JobStatsPublisher;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BulkWriterContextFactoryTest {
    SparkContext sparkContext;
    Map<String, String> options = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    TestBulkWriterContextFactory testFactory = new TestBulkWriterContextFactory();
    StructType schema = (StructType)Mockito.mock(StructType.class);

    BulkWriterContextFactoryTest() {
    }

    @BeforeEach
    void setup() {
        this.sparkContext = (SparkContext)Mockito.mock(SparkContext.class);
        Mockito.when((Object)this.sparkContext.defaultParallelism()).thenReturn((Object)1);
        SparkConf conf = new SparkConf();
        Mockito.when((Object)this.sparkContext.getConf()).thenReturn((Object)conf);
        this.options.put(WriterOptions.SIDECAR_CONTACT_POINTS.name(), "127.0.0.1");
        this.options.put(WriterOptions.KEYSPACE.name(), "ks");
        this.options.put(WriterOptions.TABLE.name(), "table");
        this.options.put(WriterOptions.KEYSTORE_PASSWORD.name(), "dummy_password");
        this.options.put(WriterOptions.KEYSTORE_PATH.name(), "dummy_path");
    }

    @Test
    void testCreateBulkWriterContext() {
        Assertions.assertThat((Object)this.testFactory.createBulkWriterContext(this.sparkContext, this.options, this.schema)).isInstanceOf(CassandraBulkWriterContext.class);
    }

    @Test
    void testCreateCoordinatedBulkWriterContext() {
        this.options.put(WriterOptions.DATA_TRANSPORT.name(), DataTransport.S3_COMPAT.name());
        this.options.put(WriterOptions.COORDINATED_WRITE_CONFIG.name(), "{\"cluster1\":{\"sidecarContactPoints\":[\"instance-1:9999\"]}}");
        Assertions.assertThat((Object)this.testFactory.createBulkWriterContext(this.sparkContext, this.options, this.schema)).isInstanceOf(CassandraCoordinatedBulkWriterContext.class);
    }

    static class TestBulkWriterContextFactory
    extends BulkWriterContextFactory {
        TestBulkWriterContextFactory() {
        }

        @NotNull
        protected BulkWriterContext createCoordinatedBulkWriterContext(@NotNull BulkSparkConf conf, StructType schema, int sparkDefaultParallelism) {
            return this.setupMock((BulkWriterContext)Mockito.mock(CassandraCoordinatedBulkWriterContext.class));
        }

        @NotNull
        protected BulkWriterContext createBulkWriterContext(@NotNull BulkSparkConf conf, StructType schema, int sparkDefaultParallelism) {
            return this.setupMock((BulkWriterContext)Mockito.mock(CassandraBulkWriterContext.class));
        }

        private BulkWriterContext setupMock(BulkWriterContext mock) {
            JobInfo job = (JobInfo)Mockito.mock(JobInfo.class);
            Mockito.when((Object)job.getId()).thenReturn((Object)"id");
            Mockito.when((Object)job.qualifiedTableName()).thenReturn((Object)new QualifiedTableName("keyspace", "table"));
            Mockito.when((Object)mock.job()).thenReturn((Object)job);
            Mockito.when((Object)mock.jobStats()).thenReturn((Object)((JobStatsPublisher)Mockito.mock(JobStatsPublisher.class)));
            return mock;
        }
    }
}

