/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import o.a.c.sidecar.client.shaded.common.response.TimeSkewResponse;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfo;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.NotThrownAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CassandraClusterInfoTest {
    @Test
    void testTimeSkewAcceptable() {
        Instant localNow = Instant.now();
        int allowanceMinutes = 10;
        Instant remoteNow = localNow.plus(Duration.ofMinutes(1L));
        CassandraClusterInfo ci = CassandraClusterInfoTest.mockClusterInfoForTimeSkewTest(allowanceMinutes, remoteNow);
        ((NotThrownAssert)Assertions.assertThatNoException().describedAs("Acceptable time skew should validate without exception", new Object[0])).isThrownBy(() -> ci.validateTimeSkewWithLocalNow(TestUtils.range(10L, 20L), localNow));
    }

    @Test
    void testTimeSkewTooLarge() {
        Instant localNow = Instant.ofEpochMilli(1726604289530L);
        int allowanceMinutes = 10;
        Instant remoteNow = localNow.plus(Duration.ofMinutes(11L));
        CassandraClusterInfo ci = CassandraClusterInfoTest.mockClusterInfoForTimeSkewTest(allowanceMinutes, remoteNow);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ci.validateTimeSkewWithLocalNow(TestUtils.range(10L, 20L), localNow)).describedAs("Time skew with too large a value should throw TimeSkewTooLargeException", new Object[0])).isExactlyInstanceOf(TimeSkewTooLargeException.class)).hasMessage("Time skew between Spark and Cassandra is too large. allowableSkewInMinutes=10, localTime=2024-09-17T20:18:09.530Z, remoteCassandraTime=2024-09-17T20:29:09.530Z, clusterId=null");
    }

    public static CassandraClusterInfo mockClusterInfoForTimeSkewTest(int allowanceMinutes, Instant remoteNow) {
        return new MockClusterInfoForTimeSkew(allowanceMinutes, remoteNow);
    }

    private static class MockClusterInfoForTimeSkew
    extends CassandraClusterInfo {
        private CassandraContext cassandraContext;

        MockClusterInfoForTimeSkew(int allowanceMinutes, Instant remoteNow) {
            super((BulkSparkConf)null);
            this.mockCassandraContext(allowanceMinutes, remoteNow);
        }

        protected CassandraContext buildCassandraContext() {
            this.cassandraContext = (CassandraContext)Mockito.mock(CassandraContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            return this.cassandraContext;
        }

        public TokenRangeMapping<RingInstance> getTokenRangeMapping(boolean cached) {
            return TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"dc1", (Object)3), 5);
        }

        private void mockCassandraContext(int allowanceMinutes, Instant remoteNow) {
            Mockito.when((Object)this.cassandraContext.getCluster()).thenReturn(Collections.emptySet());
            TimeSkewResponse tsr = new TimeSkewResponse(remoteNow.toEpochMilli(), allowanceMinutes);
            Mockito.when((Object)this.cassandraContext.getSidecarClient().timeSkew((List)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(tsr));
            Mockito.when((Object)this.cassandraContext.sidecarPort()).thenReturn((Object)9043);
        }
    }
}

