/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import o.a.c.sidecar.client.shaded.common.data.ConsistencyVerificationResult;
import o.a.c.sidecar.client.shaded.common.request.data.RestoreJobProgressRequestParams;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobProgressResponsePayload;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraCoordinatedBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedImportCoordinator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.apache.cassandra.spark.exception.ImportFailedException;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class CoordinatedImportCoordinatorTest {
    CoordinatedImportCoordinator coordinator;
    UUID restoreJobId1 = UUID.randomUUID();
    UUID restoreJobId2 = UUID.randomUUID();
    String jobId = this.restoreJobId1.toString();
    JobInfo mockJobInfo;
    CassandraCoordinatedBulkWriterContext mockWriterContext;
    StorageTransportExtension mockExtension;
    CoordinatedCloudStorageDataTransferApi dataTransferApi;
    Map<String, CloudStorageDataTransferApiImpl> apiPerCluster;
    String clusterId1 = "cluster1";
    String clusterId2 = "cluster2";
    ArgumentCaptor<String> stagedClusters;
    ArgumentCaptor<String> appliedClusters;

    CoordinatedImportCoordinatorTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.mockJobInfo = (JobInfo)Mockito.mock(JobInfo.class);
        Mockito.when((Object)this.mockJobInfo.getId()).thenReturn((Object)this.jobId);
        Mockito.when((Object)this.mockJobInfo.getRestoreJobId((String)ArgumentMatchers.eq((Object)this.clusterId1))).thenReturn((Object)this.restoreJobId1);
        Mockito.when((Object)this.mockJobInfo.getRestoreJobId((String)ArgumentMatchers.eq((Object)this.clusterId2))).thenReturn((Object)this.restoreJobId2);
        Mockito.when((Object)this.mockJobInfo.qualifiedTableName()).thenReturn((Object)new QualifiedTableName("testkeyspace", "testtable"));
        Mockito.when((Object)this.mockJobInfo.getConsistencyLevel()).thenReturn((Object)ConsistencyLevel.CL.LOCAL_QUORUM);
        Mockito.when((Object)this.mockJobInfo.jobKeepAliveMinutes()).thenReturn((Object)-1);
        HashMap<String, CoordinatedWriteConf.SimpleClusterConf> clusters = new HashMap<String, CoordinatedWriteConf.SimpleClusterConf>();
        clusters.put(this.clusterId1, new CoordinatedWriteConf.SimpleClusterConf(Arrays.asList("instance-1:9043", "instance-2:9043", "instance-3:9043"), "dc1"));
        clusters.put(this.clusterId2, new CoordinatedWriteConf.SimpleClusterConf(Arrays.asList("instance-4:9043", "instance-5:9043", "instance-6:9043"), "dc1"));
        CoordinatedWriteConf coordinatedWriteConf = new CoordinatedWriteConf(clusters);
        Mockito.when((Object)this.mockJobInfo.coordinatedWriteConf()).thenReturn((Object)coordinatedWriteConf);
        this.mockWriterContext = (CassandraCoordinatedBulkWriterContext)Mockito.mock(CassandraCoordinatedBulkWriterContext.class);
        CassandraClusterInfoGroup clusterInfoGroup = CassandraClusterInfoGroup.createFrom(Arrays.asList(this.mockCluster(this.clusterId1), this.mockCluster(this.clusterId2)));
        Mockito.when((Object)this.mockWriterContext.cluster()).thenReturn((Object)clusterInfoGroup);
        Mockito.when((Object)this.mockWriterContext.job()).thenReturn((Object)this.mockJobInfo);
        this.dataTransferApi = this.mockDataTransferApi(Arrays.asList(this.clusterId1, this.clusterId2));
        this.mockExtension = (StorageTransportExtension)Mockito.mock(StorageTransportExtension.class);
        this.stagedClusters = ArgumentCaptor.forClass(String.class);
        this.appliedClusters = ArgumentCaptor.forClass(String.class);
        ((StorageTransportExtension)Mockito.doNothing().when((Object)this.mockExtension)).onStageSucceeded((String)this.stagedClusters.capture(), ArgumentMatchers.anyLong());
        ((StorageTransportExtension)Mockito.doNothing().when((Object)this.mockExtension)).onImportSucceeded((String)this.appliedClusters.capture(), ArgumentMatchers.anyLong());
        this.coordinator = CoordinatedImportCoordinator.of((long)0L, (JobInfo)this.mockJobInfo, (CoordinatedCloudStorageDataTransferApi)this.dataTransferApi, (StorageTransportExtension)this.mockExtension);
    }

    @Test
    void testHappyPath() throws Exception {
        for (CloudStorageDataTransferApiImpl api : this.apiPerCluster.values()) {
            ((CloudStorageDataTransferApiImpl)Mockito.doNothing().when((Object)api)).updateRestoreJob((UpdateRestoreJobRequestPayload)ArgumentMatchers.any());
            ((CoordinatedCloudStorageDataTransferApi)Mockito.doReturn((Object)this.completeJobProgress()).when((Object)this.dataTransferApi)).restoreJobProgress((CloudStorageDataTransferApiImpl)ArgumentMatchers.same((Object)api), (RestoreJobProgressRequestParams)ArgumentMatchers.any());
        }
        CompletableFuture<Void> fut = CompletableFuture.runAsync(() -> ((CoordinatedImportCoordinator)this.coordinator).await());
        Assertions.assertThat((boolean)this.coordinator.isStageReady()).isFalse();
        Assertions.assertThat((boolean)this.coordinator.isImportReady()).isFalse();
        this.coordinator.onStageReady(this.jobId);
        Assertions.assertThat((boolean)this.coordinator.isStageReady()).isTrue();
        this.loopAssert(() -> this.stagedClusters.getAllValues().size() == 2, "waiting for all cluster to stage successfully. actual: " + String.valueOf(this.stagedClusters.getAllValues()));
        Assertions.assertThat((List)this.stagedClusters.getAllValues()).containsExactlyInAnyOrder((Object[])new String[]{this.clusterId1, this.clusterId2});
        this.coordinator.onImportReady(this.jobId);
        this.loopAssert(() -> this.appliedClusters.getAllValues().size() == 2, "waiting for all cluster to import successfully. actual: " + String.valueOf(this.appliedClusters.getAllValues()));
        Assertions.assertThat((List)this.appliedClusters.getAllValues()).containsExactlyInAnyOrder((Object[])new String[]{this.clusterId1, this.clusterId2});
        fut.get();
        Assertions.assertThat((boolean)this.coordinator.succeeded()).isTrue();
    }

    @Test
    void testFailToSendCoordinationSignal() {
        for (CloudStorageDataTransferApiImpl api : this.apiPerCluster.values()) {
            ((CloudStorageDataTransferApiImpl)Mockito.doThrow((Throwable[])new Throwable[]{new SidecarApiCallException("failed to send signal")}).when((Object)api)).updateRestoreJob((UpdateRestoreJobRequestPayload)ArgumentMatchers.any());
        }
        CompletableFuture<Void> fut = CompletableFuture.runAsync(() -> ((CoordinatedImportCoordinator)this.coordinator).await());
        this.coordinator.onStageReady(this.jobId);
        this.loopAssert(() -> this.coordinator.failure() != null, "waiting for coordinator to fail");
        Assertions.assertThat((boolean)this.coordinator.succeeded()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)this.coordinator.failure()).isExactlyInstanceOf(ImportFailedException.class)).hasRootCauseExactlyInstanceOf(SidecarApiCallException.class).hasRootCauseMessage("failed to send signal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(fut::get).isExactlyInstanceOf(ExecutionException.class)).hasCauseExactlyInstanceOf(ImportFailedException.class).hasRootCauseExactlyInstanceOf(SidecarApiCallException.class).hasRootCauseMessage("failed to send signal");
    }

    @Test
    void testFailToStage() {
        for (CloudStorageDataTransferApiImpl api : this.apiPerCluster.values()) {
            ((CloudStorageDataTransferApiImpl)Mockito.doNothing().when((Object)api)).updateRestoreJob((UpdateRestoreJobRequestPayload)ArgumentMatchers.any());
            ((CoordinatedCloudStorageDataTransferApi)Mockito.doReturn((Object)this.failedJobProgress()).when((Object)this.dataTransferApi)).restoreJobProgress((CloudStorageDataTransferApiImpl)ArgumentMatchers.same((Object)api), (RestoreJobProgressRequestParams)ArgumentMatchers.any());
        }
        CompletableFuture.runAsync(() -> ((CoordinatedImportCoordinator)this.coordinator).await());
        this.coordinator.onStageReady(this.jobId);
        this.loopAssert(() -> this.coordinator.failure() != null, "waiting for coordinator to fail");
        Assertions.assertThat((boolean)this.coordinator.succeeded()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)this.coordinator.failure()).isExactlyInstanceOf(ImportFailedException.class)).hasRootCauseExactlyInstanceOf(ConsistencyNotSatisfiedException.class).hasRootCauseMessage("Some of the token ranges cannot satisfy with consistency level. job=" + String.valueOf(this.restoreJobId1) + " phase=STAGE_READY consistencyLevel=LOCAL_QUORUM clusterId=cluster1 ranges=null");
    }

    @Test
    void testFailToImport() {
        for (CloudStorageDataTransferApiImpl api : this.apiPerCluster.values()) {
            ((CloudStorageDataTransferApiImpl)Mockito.doNothing().when((Object)api)).updateRestoreJob((UpdateRestoreJobRequestPayload)ArgumentMatchers.any());
            ((CoordinatedCloudStorageDataTransferApi)Mockito.doReturn((Object)this.completeJobProgress(), (Object[])new Object[]{this.failedJobProgress()}).when((Object)this.dataTransferApi)).restoreJobProgress((CloudStorageDataTransferApiImpl)ArgumentMatchers.same((Object)api), (RestoreJobProgressRequestParams)ArgumentMatchers.any());
        }
        CompletableFuture.runAsync(() -> ((CoordinatedImportCoordinator)this.coordinator).await());
        this.coordinator.onStageReady(this.jobId);
        this.loopAssert(() -> this.stagedClusters.getAllValues().size() == 2, "waiting for all cluster to stage successfully");
        Assertions.assertThat((List)this.stagedClusters.getAllValues()).containsExactlyInAnyOrder((Object[])new String[]{this.clusterId1, this.clusterId2});
        this.coordinator.onImportReady(this.jobId);
        this.loopAssert(() -> this.coordinator.failure() != null, "waiting for coordinator to fail");
        Assertions.assertThat((boolean)this.coordinator.succeeded()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)this.coordinator.failure()).isExactlyInstanceOf(ImportFailedException.class)).hasRootCauseExactlyInstanceOf(ConsistencyNotSatisfiedException.class).hasRootCauseMessage("Some of the token ranges cannot satisfy with consistency level. job=" + String.valueOf(this.restoreJobId1) + " phase=IMPORT_READY consistencyLevel=LOCAL_QUORUM clusterId=cluster1 ranges=null");
    }

    private ClusterInfo mockCluster(String clusterId) {
        ClusterInfo cluster = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)cluster.clusterId()).thenReturn((Object)clusterId);
        ImmutableMap rfOptions = ImmutableMap.of((Object)"dc1", (Object)3);
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)rfOptions);
        Mockito.when((Object)cluster.replicationFactor()).thenReturn((Object)rf);
        CassandraContext mockCassandraContext = (CassandraContext)Mockito.mock(CassandraContext.class);
        Mockito.when((Object)cluster.getCassandraContext()).thenReturn((Object)mockCassandraContext);
        TokenRangeMapping<RingInstance> topology = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)rfOptions, 10);
        Mockito.when((Object)cluster.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn(topology);
        return cluster;
    }

    private CoordinatedCloudStorageDataTransferApi mockDataTransferApi(List<String> clusters) {
        this.apiPerCluster = new HashMap<String, CloudStorageDataTransferApiImpl>(clusters.size());
        for (String clusterId : clusters) {
            CloudStorageDataTransferApiImpl api = (CloudStorageDataTransferApiImpl)Mockito.mock(CloudStorageDataTransferApiImpl.class);
            Mockito.when((Object)api.jobInfo()).thenReturn((Object)this.mockJobInfo);
            this.apiPerCluster.put(clusterId, api);
        }
        CoordinatedCloudStorageDataTransferApi coordinatedApi = new CoordinatedCloudStorageDataTransferApi(RateLimiter.create((double)1000.0), this.apiPerCluster);
        return (CoordinatedCloudStorageDataTransferApi)Mockito.spy((Object)coordinatedApi);
    }

    private RestoreJobProgressResponsePayload completeJobProgress() {
        return RestoreJobProgressResponsePayload.builder().withStatus(ConsistencyVerificationResult.SATISFIED).withMessage("All ranges have succeeded.").build();
    }

    private RestoreJobProgressResponsePayload failedJobProgress() {
        return RestoreJobProgressResponsePayload.builder().withStatus(ConsistencyVerificationResult.FAILED).withMessage("One or more ranges have failed.").build();
    }

    private void loopAssert(Supplier<Boolean> condition, String desc) {
        int attempts = 50;
        while (!condition.get().booleanValue() && attempts-- > 1) {
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (attempts == 0) {
            Assertions.fail((String)("loop assert times out for " + desc));
        }
    }
}

