/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BulkWriterConsistencyLevelTest {
    private static final ReplicationFactor replicationFactor = new ReplicationFactor((Map)ImmutableMap.of((Object)"class", (Object)"NetworkTopologyStrategy", (Object)"dc1", (Object)"3", (Object)"dc2", (Object)"3"));
    private static List<CassandraInstance> succeededNone = Collections.emptyList();
    private static List<CassandraInstance> succeededOne;
    private static List<CassandraInstance> succeededOnePerDc;
    private static List<CassandraInstance> succeededTwo;
    private static List<CassandraInstance> succeededTwoPerDc;
    private static List<CassandraInstance> succeededThree;
    private static List<CassandraInstance> succeededThreePerDc;
    private static List<CassandraInstance> succeededQuorum;
    private static List<CassandraInstance> succeededHalf;
    private static List<CassandraInstance> succeededAll;
    private static Set<CassandraInstance> zero;
    private static Set<CassandraInstance> onePerDc;
    private static Set<CassandraInstance> one;
    private static Set<CassandraInstance> twoPerDc;
    private static Set<CassandraInstance> two;
    private static Set<CassandraInstance> threePerDc;
    private static Set<CassandraInstance> three;

    BulkWriterConsistencyLevelTest() {
    }

    @BeforeAll
    static void setup() {
        CassandraInstance dc1i1 = BulkWriterConsistencyLevelTest.mockInstance("dc1");
        CassandraInstance dc1i2 = BulkWriterConsistencyLevelTest.mockInstance("dc1");
        CassandraInstance dc1i3 = BulkWriterConsistencyLevelTest.mockInstance("dc1");
        CassandraInstance dc2i1 = BulkWriterConsistencyLevelTest.mockInstance("dc2");
        CassandraInstance dc2i2 = BulkWriterConsistencyLevelTest.mockInstance("dc2");
        CassandraInstance dc2i3 = BulkWriterConsistencyLevelTest.mockInstance("dc2");
        succeededOne = Arrays.asList(dc1i1);
        succeededTwo = Arrays.asList(dc1i1, dc1i2);
        succeededThree = Arrays.asList(dc1i1, dc1i2, dc1i3);
        succeededOnePerDc = Arrays.asList(dc1i1, dc2i1);
        succeededTwoPerDc = Arrays.asList(dc1i1, dc1i2, dc2i1, dc2i2);
        succeededThreePerDc = Arrays.asList(dc1i1, dc1i2, dc1i3, dc2i1, dc2i2, dc2i3);
        succeededQuorum = Arrays.asList(dc1i1, dc1i2, dc1i3, dc2i1);
        succeededHalf = Arrays.asList(dc1i1, dc1i2, dc2i1);
        succeededAll = succeededThreePerDc;
    }

    @Test
    void testCanBeSatisfiedReturnsTrue() {
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ONE, succeededOne, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ONE, succeededTwo, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ONE, succeededThree, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.TWO, succeededTwo, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.TWO, succeededThree, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, succeededOne, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, succeededTwo, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, succeededThree, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, succeededTwo, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, succeededThree, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, succeededTwoPerDc, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, succeededThreePerDc, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededTwoPerDc, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededThreePerDc, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededQuorum, true);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededAll, true);
    }

    @Test
    void testCanBeSatisfiedReturnsFalse() {
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ONE, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.TWO, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.TWO, succeededOne, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, succeededOne, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, succeededOne, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, succeededOnePerDc, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededOne, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededOnePerDc, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededTwo, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, succeededHalf, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededNone, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededOne, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededOnePerDc, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededTwo, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededTwoPerDc, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededQuorum, false);
        this.testCanBeSatisfied((ConsistencyLevel)ConsistencyLevel.CL.ALL, succeededHalf, false);
    }

    @Test
    void testCanBeSatisfiedWithPendingReturnsTrue() {
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, three, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, three, two, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, three, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, two, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, two, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, one, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.TWO, three, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.TWO, three, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.TWO, two, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, three, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, three, two, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, three, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, two, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, two, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, one, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, three, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, three, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, three, onePerDc, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, two, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, threePerDc, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, threePerDc, one, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, threePerDc, onePerDc, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, twoPerDc, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, threePerDc, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, threePerDc, onePerDc, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, twoPerDc, zero, true);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, threePerDc, zero, true);
    }

    @Test
    void testCanBeSatisfiedWithPendingReturnsFalse() {
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ONE, onePerDc, onePerDc, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.TWO, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.TWO, one, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.TWO, two, one, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, one, one, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_ONE, two, two, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, one, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM, two, one, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, onePerDc, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM, twoPerDc, onePerDc, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, onePerDc, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.QUORUM, twoPerDc, onePerDc, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, two, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, twoPerDc, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, one, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, onePerDc, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, zero, zero, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, threePerDc, one, false);
        this.testCanBeSatisfiedWithPending((ConsistencyLevel)ConsistencyLevel.CL.ALL, threePerDc, onePerDc, false);
    }

    private void testCanBeSatisfied(ConsistencyLevel cl, List<CassandraInstance> succeeded, boolean expectedResult) {
        Assertions.assertThat((boolean)cl.canBeSatisfied(succeeded, zero, replicationFactor, "dc1")).isEqualTo(expectedResult);
    }

    private void testCanBeSatisfiedWithPending(ConsistencyLevel cl, Set<CassandraInstance> succeeded, Set<CassandraInstance> pending, boolean expectedResult) {
        Assertions.assertThat((boolean)cl.canBeSatisfied(succeeded, pending, replicationFactor, "dc1")).isEqualTo(expectedResult);
    }

    private static CassandraInstance mockInstance(String dc) {
        CassandraInstance i = (CassandraInstance)Mockito.mock(CassandraInstance.class);
        Mockito.when((Object)i.datacenter()).thenReturn((Object)dc);
        return i;
    }

    private static Set<CassandraInstance> intToSet(int i) {
        return BulkWriterConsistencyLevelTest.intToSet(i, false);
    }

    private static Set<CassandraInstance> intToSet(int i, boolean singleDc) {
        HashSet<CassandraInstance> res = new HashSet<CassandraInstance>();
        for (int j = 0; j < i; ++j) {
            CassandraInstance dc1Instance = (CassandraInstance)Mockito.mock(CassandraInstance.class);
            Mockito.when((Object)dc1Instance.datacenter()).thenReturn((Object)"dc1");
            res.add(dc1Instance);
            if (singleDc) continue;
            CassandraInstance dc2Instance = (CassandraInstance)Mockito.mock(CassandraInstance.class);
            Mockito.when((Object)dc2Instance.datacenter()).thenReturn((Object)"dc2");
            res.add(dc2Instance);
        }
        return res;
    }

    static {
        zero = Collections.emptySet();
        onePerDc = BulkWriterConsistencyLevelTest.intToSet(1);
        one = BulkWriterConsistencyLevelTest.intToSet(1, true);
        twoPerDc = BulkWriterConsistencyLevelTest.intToSet(2);
        two = BulkWriterConsistencyLevelTest.intToSet(2, true);
        threePerDc = BulkWriterConsistencyLevelTest.intToSet(3);
        three = BulkWriterConsistencyLevelTest.intToSet(3, true);
    }
}

