/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;

@Tag(value="Sequential")
public class SchemaTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSinglePartitionKey(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.bigint()).withColumn("c2", (CqlField.CqlType)bridge.text())).withExpectedRowCountPerSSTable(200).withSumField("c1").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testOnlyPartitionKeys(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withPartitionKey("b", (CqlField.CqlType)bridge.bigint())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testOnlyPartitionClusteringKeys(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.bigint()).withClusteringKey("c", (CqlField.CqlType)bridge.text())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultiplePartitionKeys(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withPartitionKey("b", (CqlField.CqlType)bridge.bigint()).withColumn("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.bigint())).withExpectedRowCountPerSSTable(200).withSumField("d").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testBasicSingleClusteringKey(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withClusteringKey("b", (CqlField.CqlType)bridge.bigint()).withColumn("c", (CqlField.CqlType)bridge.bigint())).withExpectedRowCountPerSSTable(200).withSumField("c").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSingleClusteringKeyOrderBy(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.sortOrder()).assuming((clusteringKeyType, sortOrder) -> clusteringKeyType.supportedAsPrimaryKeyColumn()).checkAssert((clusteringKeyType, sortOrder) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withClusteringKey("b", (CqlField.CqlType)clusteringKeyType).withColumn("c", (CqlField.CqlType)bridge.bigint()).withSortOrder(sortOrder)).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultipleClusteringKeys(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withClusteringKey("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.text()).withColumn("e", (CqlField.CqlType)bridge.bigint())).withExpectedRowCountPerSSTable(200).withSumField("e").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testManyClusteringKeys(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.timestamp()).withClusteringKey("c", (CqlField.CqlType)bridge.text()).withClusteringKey("d", (CqlField.CqlType)bridge.uuid()).withClusteringKey("e", (CqlField.CqlType)bridge.aFloat()).withColumn("f", (CqlField.CqlType)bridge.text()).withColumn("g", (CqlField.CqlType)bridge.bigint())).withExpectedRowCountPerSSTable(200).withSumField("g").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testOnlyStaticColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.bigint()).withStaticColumn("c", (CqlField.CqlType)bridge.aInt())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testStaticColumn(CassandraBridge bridge) {
        int numRows = 100;
        int numColumns = 20;
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withStaticColumn("c", (CqlField.CqlType)bridge.aInt()).withColumn("d", (CqlField.CqlType)bridge.text())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                for (int column = 0; column < numColumns; ++column) {
                    if (column == numColumns - 1) {
                        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    writer.write(new Object[]{row, column, row * column, UUID.randomUUID().toString()});
                }
            }
        }).withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                for (int column = numColumns; column < numColumns * 2; ++column) {
                    if (column == numColumns * 2 - 1) {
                        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    writer.write(new Object[]{row, column, row * column, UUID.randomUUID().toString()});
                }
            }
        }).withReadListener(row -> {
            assert (row.getInteger("c") == row.getInteger("a") * (numColumns * 2 - 1));
        }).withCheck(dataset -> Assertions.assertThat((long)dataset.count()).isEqualTo((long)(numRows * numColumns * 2))).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNulledStaticColumns(CassandraBridge bridge) {
        int numClusteringKeys = 10;
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withStaticColumn("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.aInt())).withNumRandomRows(0).dontCheckNumSSTables().withSSTableWriter(writer -> IntStream.range(0, 200).forEach(row -> {
            UUID pk = UUID.randomUUID();
            IntStream.range(0, numClusteringKeys).forEach(clusteringKey -> writer.write(new Object[]{pk, clusteringKey, row % 2 == 0 ? null : "Non-null", row}));
        })).withReadListener(row -> {
            String staticCol;
            String string = staticCol = row.isNull("c") ? null : row.getString("c");
            if (row.getInteger("d") % 2 == 0) {
                Assertions.assertThat((String)staticCol).isNull();
            } else {
                Assertions.assertThat((String)staticCol).isEqualTo("Non-null");
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#versions"})
    public void testMultipleSSTableCompacted(CassandraVersion version) {
        CassandraBridge bridge = CassandraBridgeFactory.get((CassandraVersion)version);
        TestSchema.Builder schemaBuilder = TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withClusteringKey("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.text()).withColumn("e", (CqlField.CqlType)bridge.bigint());
        AtomicLong total = new AtomicLong(0L);
        HashMap rows = new HashMap(200);
        Tester.builder(schemaBuilder).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < 200; ++row) {
                TestSchema schema = schemaBuilder.build();
                schema.setCassandraVersion(version);
                TestSchema.TestRow testRow = schema.randomRow();
                rows.put(testRow.getUUID("a"), testRow);
                writer.write(testRow.allValues());
            }
        }).withSSTableWriter(writer -> {
            for (TestSchema.TestRow testRow : ImmutableSet.copyOf(rows.values())) {
                TestSchema.TestRow newTestRow = testRow.copy("e", (Object)RandomUtils.RANDOM.nextLong()).copy("d", (Object)UUID.randomUUID().toString().substring(0, 10));
                rows.put(testRow.getUUID("a"), newTestRow);
                writer.write(newTestRow.allValues());
            }
        }).withSSTableWriter(writer -> {
            for (TestSchema.TestRow testRow : ImmutableSet.copyOf(rows.values())) {
                TestSchema.TestRow newTestRow = testRow.copy("e", (Object)RandomUtils.RANDOM.nextLong()).copy("d", (Object)UUID.randomUUID().toString().substring(0, 10));
                rows.put(testRow.getUUID("a"), newTestRow);
                total.addAndGet(newTestRow.getLong("e"));
                writer.write(newTestRow.allValues());
            }
        }).withReadListener(actualRow -> Assertions.assertThat((boolean)rows.containsKey(actualRow.getUUID("a"))).isTrue()).withReadListener(actualRow -> Assertions.assertThat((Object)actualRow).isEqualTo(rows.get(actualRow.getUUID("a")))).withReadListener(actualRow -> Assertions.assertThat((Long)actualRow.getLong("e")).isEqualTo((Object)((TestSchema.TestRow)rows.get(actualRow.getUUID("a"))).getLong("e"))).withCheck(dataset -> Assertions.assertThat((long)((Row)dataset.groupBy(new Column[0]).sum(new String[]{"e"}).first()).getLong(0)).isEqualTo(total.get())).withCheck(dataset -> Assertions.assertThat((long)((Row)dataset.groupBy(new Column[0]).count().first()).getLong(0)).isEqualTo((long)rows.size())).withReset(() -> {
            total.set(0L);
            rows.clear();
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtsWithNulls(CassandraBridge bridge) {
        CqlField.CqlUdt type = bridge.udt("udt_with_nulls", "udt1").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.text()).withField("c", (CqlField.CqlType)bridge.text()).build();
        HashMap values = new HashMap(200);
        Tester.builder(keyspace -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace).withPartitionKey("pk", (CqlField.CqlType)bridge.bigint()).withClusteringKey("ck", (CqlField.CqlType)type.frozen()).withColumn("col1", (CqlField.CqlType)bridge.text()).withColumn("col2", (CqlField.CqlType)bridge.timestamp()).withColumn("col3", (CqlField.CqlType)bridge.aInt())).dontWriteRandomData().withSSTableWriter(writer -> {
            int midPoint = 100;
            for (long pk = 0L; pk < 200L; ++pk) {
                ImmutableMap value = ImmutableMap.of((Object)(pk < (long)midPoint ? "a" : "b"), (Object)bridge.text().randomValue().toString(), (Object)"c", (Object)bridge.text().randomValue().toString());
                values.put(pk, value);
                writer.write(new Object[]{pk, bridge.toUserTypeValue(type, (Map)value), bridge.text().randomValue(), bridge.timestamp().randomValue(), bridge.aInt().randomValue()});
            }
        }).withCheck(dataset -> {
            Map<Long, Row> rows = dataset.collectAsList().stream().collect(Collectors.toMap(row -> row.getLong(0), row -> row.getStruct(1)));
            Assertions.assertThat((int)rows.size()).isEqualTo(values.size());
            for (Map.Entry<Long, Row> pk : rows.entrySet()) {
                Assertions.assertThat((String)pk.getValue().getString(0)).isEqualTo(((Map)values.get(pk.getKey())).get("a"));
                Assertions.assertThat((String)pk.getValue().getString(1)).isEqualTo(((Map)values.get(pk.getKey())).get("b"));
                Assertions.assertThat((String)pk.getValue().getString(2)).isEqualTo(((Map)values.get(pk.getKey())).get("c"));
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMapClusteringKey(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.bigint(), (CqlField.CqlType)bridge.text()).frozen()).withColumn("c1", (CqlField.CqlType)bridge.text()).withColumn("c2", (CqlField.CqlType)bridge.text()).withColumn("c3", (CqlField.CqlType)bridge.text())).withNumRandomRows(5).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testListClusteringKey(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.bigint()).frozen()).withColumn("c1", (CqlField.CqlType)bridge.text()).withColumn("c2", (CqlField.CqlType)bridge.text()).withColumn("c3", (CqlField.CqlType)bridge.text())).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSetClusteringKey(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.aFloat()).frozen()).withColumn("c1", (CqlField.CqlType)bridge.text()).withColumn("c2", (CqlField.CqlType)bridge.text()).withColumn("c3", (CqlField.CqlType)bridge.text())).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdTClusteringKey(CassandraBridge bridge) {
        Tester.builder(keyspace -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.udt("udt_clustering_key", "udt1").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.aFloat()).withField("c", (CqlField.CqlType)bridge.bigint()).build().frozen()).withColumn("c1", (CqlField.CqlType)bridge.text()).withColumn("c2", (CqlField.CqlType)bridge.text()).withColumn("c3", (CqlField.CqlType)bridge.text())).run(bridge.getVersion());
    }
}

