/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.BloomFilter;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.test.TestSSTable;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.quicktheories.QuickTheory;

public class CassandraBridgeUtilTests {
    @TempDir
    private static Path tempPath;

    @Test
    public void testLastRepairTime() {
        CassandraBridgeUtilTests.runTest((partitioner, bridge, schema, testDir) -> {
            this.writeSSTable(partitioner, bridge, schema, testDir, writer -> IntStream.range(0, 200).forEach(i -> writer.write(new Object[]{RandomUtils.randomAlphanumeric(), RandomUtils.randomAlphanumeric(), RandomUtils.randomAlphanumeric()})));
            try {
                Assertions.assertThat((long)bridge.lastRepairTime("ks", "tb", TestSSTable.firstIn((Path)testDir))).isEqualTo(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testBuildPartitionKey() {
        CassandraBridgeUtilTests.runTest((partitioner, bridge, schema, testDir) -> {
            ByteBuffer pk1 = bridge.encodePartitionKey(partitioner, "ks", schema.createStatement, Collections.singletonList("a"));
            Assertions.assertThat((String)ByteBufferUtils.string((ByteBuffer)pk1)).isEqualTo("a");
            String str1 = RandomUtils.randomAlphanumeric();
            ByteBuffer pk2 = bridge.encodePartitionKey(partitioner, "ks", schema.createStatement, Collections.singletonList(str1));
            Assertions.assertThat((String)ByteBufferUtils.string((ByteBuffer)pk2)).isEqualTo(str1);
            List<String> keys = Arrays.asList(RandomUtils.randomAlphanumeric(), RandomUtils.randomAlphanumeric(), RandomUtils.randomAlphanumeric());
            TestSchema threePkSchema = TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.text()).withPartitionKey("b", (CqlField.CqlType)bridge.text()).withPartitionKey("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.bigint()).withColumn("e", (CqlField.CqlType)bridge.aInt()).build();
            ByteBuffer pk3 = bridge.encodePartitionKey(partitioner, "ks", threePkSchema.createStatement, keys);
            Assertions.assertThat((String)ByteBufferUtils.readShortLengthCompositeTypeString((ByteBuffer)pk3)).isEqualTo(keys.get(0));
            Assertions.assertThat((String)ByteBufferUtils.readShortLengthCompositeTypeString((ByteBuffer)pk3)).isEqualTo(keys.get(1));
            Assertions.assertThat((String)ByteBufferUtils.readShortLengthCompositeTypeString((ByteBuffer)pk3)).isEqualTo(keys.get(2));
        });
    }

    @Test
    public void testOverlaps() {
        CassandraBridgeUtilTests.runTest((partitioner, bridge, schema, testDir) -> {
            List keys = IntStream.range(0, 3).mapToObj(i -> RandomUtils.randomAlphanumeric()).collect(Collectors.toList());
            List buffers = bridge.encodePartitionKeys(partitioner, schema.keyspace, schema.createStatement, keys.stream().map(Collections::singletonList).collect(Collectors.toList()));
            List sortedTokens = buffers.stream().map(arg_0 -> ((Partitioner)partitioner).hash(arg_0)).sorted().collect(Collectors.toList());
            Assertions.assertThat((List)TestSSTable.allIn((Path)testDir)).isEmpty();
            this.writeSSTable(partitioner, bridge, schema, testDir, writer -> keys.forEach(key -> writer.write(new Object[]{key, RandomUtils.randomAlphanumeric(), RandomUtils.randomAlphanumeric()})));
            Assertions.assertThat((List)TestSSTable.allIn((Path)testDir)).hasSize(1);
            TestSSTable ssTable = (TestSSTable)TestSSTable.firstIn((Path)testDir);
            List<TokenRange> testRanges = Arrays.asList(TokenRange.openClosed((BigInteger)((BigInteger)sortedTokens.get(0)), (BigInteger)((BigInteger)sortedTokens.get(0))), TokenRange.closed((BigInteger)((BigInteger)sortedTokens.get(0)), (BigInteger)((BigInteger)sortedTokens.get(1))), TokenRange.closed((BigInteger)((BigInteger)sortedTokens.get(0)), (BigInteger)((BigInteger)sortedTokens.get(2))), TokenRange.openClosed((BigInteger)((BigInteger)sortedTokens.get(1)), (BigInteger)((BigInteger)sortedTokens.get(1))), TokenRange.closed((BigInteger)((BigInteger)sortedTokens.get(1)), (BigInteger)((BigInteger)sortedTokens.get(2))), TokenRange.openClosed((BigInteger)((BigInteger)sortedTokens.get(2)), (BigInteger)((BigInteger)sortedTokens.get(2)).add(BigInteger.ONE)));
            Path summaryDbFile = ssTable.fileComponentPath(FileType.SUMMARY);
            for (int j = 0; j < 2; ++j) {
                SSTableSummary summary = bridge.getSSTableSummary(partitioner, (SSTable)ssTable, 128, 256);
                Assertions.assertThat((BigInteger)summary.firstToken).isEqualTo(sortedTokens.get(0));
                Assertions.assertThat((BigInteger)summary.lastToken).isEqualTo(sortedTokens.get(2));
                TokenRange sstableRange = TokenRange.closed((BigInteger)summary.firstToken, (BigInteger)summary.lastToken);
                for (BigInteger token : sortedTokens) {
                    Assertions.assertThat((boolean)sstableRange.contains(token)).isTrue();
                }
                List result = bridge.overlaps((SSTable)ssTable, partitioner, 128, 256, testRanges);
                Assertions.assertThat((List)result).hasSize(testRanges.size());
                for (int i2 = 0; i2 < result.size(); ++i2) {
                    Assertions.assertThat((Boolean)((Boolean)result.get(i2))).isEqualTo(i2 < result.size() - 1);
                }
                if (summaryDbFile == null) continue;
                Files.deleteIfExists(summaryDbFile);
            }
        });
    }

    @Test
    public void testContains() {
        CassandraBridgeUtilTests.runTest((partitioner, bridge, schema, testDir) -> {
            Set keys = IntStream.range(0, 25).mapToObj(i -> RandomUtils.randomAlphanumeric()).collect(Collectors.toSet());
            List buffers = bridge.encodePartitionKeys(partitioner, schema.keyspace, schema.createStatement, keys.stream().map(Collections::singletonList).collect(Collectors.toList()));
            Assertions.assertThat((List)TestSSTable.allIn((Path)testDir)).isEmpty();
            this.writeSSTable(partitioner, bridge, schema, testDir, writer -> keys.forEach(key -> writer.write(new Object[]{key, RandomUtils.randomAlphanumeric(), RandomUtils.randomAlphanumeric()})));
            Assertions.assertThat((List)TestSSTable.allIn((Path)testDir)).hasSize(1);
            TestSSTable ssTable = (TestSSTable)TestSSTable.firstIn((Path)testDir);
            BloomFilter filter = bridge.openBloomFilter(partitioner, schema.keyspace, schema.table, (SSTable)ssTable);
            List result = buffers.stream().map(arg_0 -> ((BloomFilter)filter).mightContain(arg_0)).collect(Collectors.toList());
            Assertions.assertThat(result).hasSameSizeAs((Iterable)buffers);
            Assertions.assertThat((boolean)result.stream().allMatch(boolValue -> boolValue)).isTrue();
            List otherKeys = IntStream.range(0, 200).mapToObj(i -> RandomUtils.randomAlphanumeric((Set)keys)).collect(Collectors.toList());
            List randomBuffers = bridge.encodePartitionKeys(partitioner, schema.keyspace, schema.createStatement, otherKeys.stream().map(Collections::singletonList).collect(Collectors.toList()));
            BloomFilter randomBloomFilter = bridge.openBloomFilter(partitioner, schema.keyspace, schema.table, (SSTable)ssTable);
            List randomResult = randomBuffers.stream().map(arg_0 -> ((BloomFilter)randomBloomFilter).mightContain(arg_0)).collect(Collectors.toList());
            Assertions.assertThat(randomResult).hasSameSizeAs(otherKeys);
            Assertions.assertThat((boolean)randomResult.stream().anyMatch(boolValue -> boolValue == false)).isTrue();
            Assertions.assertThat((boolean)bridge.contains(partitioner, schema.keyspace, schema.table, (SSTable)ssTable, buffers).stream().allMatch(aBoolean -> aBoolean)).isTrue();
            Assertions.assertThat((boolean)bridge.contains(partitioner, schema.keyspace, schema.table, (SSTable)ssTable, randomBuffers).stream().noneMatch(aBoolean -> aBoolean)).isTrue();
            ArrayList allKeys = new ArrayList();
            allKeys.addAll(buffers);
            allKeys.addAll(randomBuffers);
            List exactResult = bridge.contains(partitioner, schema.keyspace, schema.table, (SSTable)ssTable, allKeys);
            Assertions.assertThat((List)exactResult).hasSameSizeAs(allKeys);
            for (int i2 = 0; i2 < exactResult.size(); ++i2) {
                boolean contains = (Boolean)exactResult.get(i2);
                Assertions.assertThat((boolean)contains).isEqualTo(i2 < buffers.size());
                if (filter.doesNotContain((ByteBuffer)allKeys.get(i2))) {
                    Assertions.assertThat((boolean)contains).isFalse();
                }
                if (!contains) continue;
                Assertions.assertThat((boolean)filter.mightContain((ByteBuffer)allKeys.get(i2))).isTrue();
            }
        });
    }

    @Test
    public void testReadKeys() {
        CassandraBridgeUtilTests.runTest((partitioner, bridge, schema, testDir) -> {
            Map expected = IntStream.range(0, 200).mapToObj(i -> RandomUtils.randomAlphanumeric((int)32)).collect(Collectors.toMap(Function.identity(), i -> RandomUtils.randomAlphanumeric((int)32)));
            this.writeSSTable(partitioner, bridge, schema, testDir, writer -> expected.forEach((key, value) -> writer.write(new Object[]{key, value, value})));
            List all = TestSSTable.allIn((Path)testDir);
            HashSet ssTables = new HashSet(all);
            HashMap actual = new HashMap(200);
            bridge.readStringPartitionKeys(partitioner, schema.keyspace, schema.createStatement, ssTables, null, expected.keySet().stream().map(Collections::singletonList).collect(Collectors.toList()), null, row -> actual.put(row.get("a").toString(), row));
            Assertions.assertThat(actual).hasSameSizeAs(expected);
            for (Map.Entry entry : expected.entrySet()) {
                Map actualRow = (Map)actual.get(entry.getKey());
                Assertions.assertThat((Map)actualRow).isNotNull();
                Assertions.assertThat(actualRow.get("b")).isEqualTo((Object)entry.getValue());
                Assertions.assertThat(actualRow.get("c")).isEqualTo((Object)entry.getValue());
            }
        });
    }

    private void writeSSTable(Partitioner partitioner, CassandraBridge bridge, TestSchema schema, Path testDir, Consumer<CassandraBridge.Writer> writer) {
        bridge.writeSSTable(partitioner, schema.keyspace, schema.table, testDir, schema.createStatement, schema.insertStatement, writer);
    }

    private static void runTest(TestRunable test) {
        QuickTheory.qt().forAll(TestUtils.partitioners(), TestUtils.bridges()).checkAssert((partitioner, bridge) -> {
            TestSchema schema = TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.text()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.text()).build();
            String testId = UUID.randomUUID().toString();
            Path testDir = tempPath.resolve(testId);
            try {
                TestUtils.createDirectory(testDir);
                test.run((Partitioner)partitioner, (CassandraBridge)bridge, schema, testDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)testDir.toFile());
                }
                catch (IOException iOException) {}
            }
        });
    }

    private static interface TestRunable {
        public void run(Partitioner var1, CassandraBridge var2, TestSchema var3, Path var4) throws IOException;
    }
}

