/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.bridge.BaseCassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.apache.cassandra.bridge.CdcBridge;
import org.apache.cassandra.cdc.avro.CqlToAvroSchemaConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdcBridgeFactory
extends BaseCassandraBridgeFactory {
    private static final Map<String, VersionSpecificBridge> CASSANDRA_BRIDGES = new ConcurrentHashMap<String, VersionSpecificBridge>(CassandraVersion.values().length);

    private CdcBridgeFactory() {
        throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass()) + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static CassandraBridge get(@NotNull String version) {
        return CdcBridgeFactory.get(CdcBridgeFactory.getCassandraVersion((String)version));
    }

    @NotNull
    public static CassandraBridge get(@NotNull CassandraVersionFeatures features) {
        return CdcBridgeFactory.get(CdcBridgeFactory.getCassandraVersion((CassandraVersionFeatures)features));
    }

    private static VersionSpecificBridge getVersionSpecificBridge(@NotNull CassandraVersion version) {
        String jarBaseName = version.jarBaseName();
        if (jarBaseName == null) {
            throw new NullPointerException("Cassandra version " + String.valueOf(version) + " is not supported");
        }
        return CASSANDRA_BRIDGES.computeIfAbsent(jarBaseName, CdcBridgeFactory::create);
    }

    @NotNull
    public static CassandraBridge get(@NotNull CassandraVersion version) {
        return CdcBridgeFactory.getVersionSpecificBridge((CassandraVersion)version).cassandraBridge;
    }

    @NotNull
    public static CdcBridge getCdcBridge(@NotNull CassandraVersionFeatures features) {
        return CdcBridgeFactory.getCdcBridge(CdcBridgeFactory.getCassandraVersion((CassandraVersionFeatures)features));
    }

    @NotNull
    public static CdcBridge getCdcBridge(@NotNull CassandraBridge bridge) {
        return CdcBridgeFactory.getCdcBridge(bridge.getVersion());
    }

    @NotNull
    public static CdcBridge getCdcBridge(@NotNull CassandraVersion version) {
        return CdcBridgeFactory.getVersionSpecificBridge((CassandraVersion)version).cdcBridge;
    }

    @NotNull
    public static CqlToAvroSchemaConverter getCqlToAvroSchemaConverter(@NotNull CassandraBridge bridge) {
        return CdcBridgeFactory.getCqlToAvroSchemaConverter(bridge.getVersion());
    }

    @Nullable
    public static CqlToAvroSchemaConverter getCqlToAvroSchemaConverter(@NotNull CassandraVersion version) {
        return CdcBridgeFactory.getVersionSpecificBridge((CassandraVersion)version).avroSchemaConverter;
    }

    @NotNull
    private static VersionSpecificBridge create(@NotNull String label) {
        try {
            ClassLoader loader = CdcBridgeFactory.buildClassLoader((String[])new String[]{CdcBridgeFactory.cassandraResourceName((String)label), CdcBridgeFactory.bridgeResourceName((String)label), CdcBridgeFactory.typesResourceName((String)label), CdcBridgeFactory.avroResourceName((String)label)});
            Class<?> bridge = loader.loadClass("org.apache.cassandra.bridge.CassandraBridgeImplementation");
            Constructor<?> constructor = bridge.getConstructor(new Class[0]);
            CassandraBridge bridgeInstance = (CassandraBridge)constructor.newInstance(new Object[0]);
            Class<?> cdcBridgeClass = loader.loadClass("org.apache.cassandra.bridge.CdcBridgeImplementation");
            Constructor<?> cdcBridgeConstructor = cdcBridgeClass.getConstructor(new Class[0]);
            CdcBridge cdcBridgeInstance = (CdcBridge)cdcBridgeConstructor.newInstance(new Object[0]);
            CqlToAvroSchemaConverter cqlToAvroSchemaConverter = null;
            try {
                Class<?> avroBridgeClass = loader.loadClass("org.apache.cassandra.cdc.avro.CqlToAvroSchemaConverterImplementation");
                Constructor<?> cqlToAvroSchemaConverterConstructor = avroBridgeClass.getConstructor(new Class[0]);
                cqlToAvroSchemaConverter = (CqlToAvroSchemaConverter)cqlToAvroSchemaConverterConstructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new VersionSpecificBridge(bridgeInstance, cdcBridgeInstance, cqlToAvroSchemaConverter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new RuntimeException("Failed to create Cassandra bridge for label " + label, exception);
        }
    }

    public static class VersionSpecificBridge {
        public final CassandraBridge cassandraBridge;
        public final CdcBridge cdcBridge;
        @Nullable
        final CqlToAvroSchemaConverter avroSchemaConverter;

        public VersionSpecificBridge(CassandraBridge cassandraBridge, CdcBridge cdcBridge, @Nullable CqlToAvroSchemaConverter avroSchemaConverter) {
            this.cassandraBridge = cassandraBridge;
            this.cdcBridge = cdcBridge;
            this.avroSchemaConverter = avroSchemaConverter;
        }
    }
}

