/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;

public abstract class TokenAllocatorBase<Unit>
implements TokenAllocator<Unit> {
    static final double MIN_INITIAL_SPLITS_RATIO = 1.0 - 1.0 / Math.sqrt(5.0);
    static final double MAX_INITIAL_SPLITS_RATIO = MIN_INITIAL_SPLITS_RATIO + 0.075;
    final NavigableMap<Token, Unit> sortedTokens;
    final ReplicationStrategy<Unit> strategy;
    final IPartitioner partitioner;

    protected TokenAllocatorBase(NavigableMap<Token, Unit> sortedTokens, ReplicationStrategy<Unit> strategy, IPartitioner partitioner) {
        this.sortedTokens = sortedTokens;
        this.strategy = strategy;
        this.partitioner = partitioner;
    }

    public abstract int getReplicas();

    protected Map<Unit, UnitInfo<Unit>> createUnitInfos(Map<Object, GroupInfo> groups) {
        HashMap map = Maps.newHashMap();
        for (Object n : this.sortedTokens.values()) {
            UnitInfo ni = (UnitInfo)map.get(n);
            if (ni == null) {
                ni = new UnitInfo(n, 0.0, groups, this.strategy);
                map.put(n, ni);
            }
            ++ni.tokenCount;
        }
        return map;
    }

    private Map.Entry<Token, Unit> mapEntryFor(Token t) {
        Map.Entry<Token, Unit> en = this.sortedTokens.floorEntry(t);
        if (en == null) {
            en = this.sortedTokens.lastEntry();
        }
        return en;
    }

    Unit unitFor(Token t) {
        return this.mapEntryFor(t).getValue();
    }

    private static <Unit> GroupInfo getGroup(Unit unit, Map<Object, GroupInfo> groupMap, ReplicationStrategy<Unit> strategy) {
        Object groupClass = strategy.getGroup(unit);
        GroupInfo group = groupMap.get(groupClass);
        if (group == null) {
            group = new GroupInfo(groupClass);
            groupMap.put(groupClass, group);
        }
        return group;
    }

    Collection<Token> generateSplits(Unit newUnit, int numTokens) {
        return this.generateSplits(newUnit, numTokens, MIN_INITIAL_SPLITS_RATIO, MAX_INITIAL_SPLITS_RATIO);
    }

    Collection<Token> generateSplits(Unit newUnit, int numTokens, double minRatio, double maxRatio) {
        Random random = new Random(this.sortedTokens.size());
        double potentialRatioGrowth = maxRatio - minRatio;
        ArrayList<Token> tokens = Lists.newArrayListWithExpectedSize(numTokens);
        if (this.sortedTokens.isEmpty()) {
            Token t = this.partitioner.getRandomToken();
            tokens.add(t);
            this.sortedTokens.put(t, newUnit);
        }
        while (tokens.size() < numTokens) {
            Token prev = (Token)this.sortedTokens.lastKey();
            double maxsz = 0.0;
            Token t1 = null;
            Token t2 = null;
            for (Token curr : this.sortedTokens.keySet()) {
                double sz = prev.size(curr);
                if (sz > maxsz) {
                    maxsz = sz;
                    t1 = prev;
                    t2 = curr;
                }
                prev = curr;
            }
            assert (t1 != null);
            Token t = this.partitioner.split(t1, t2, minRatio + potentialRatioGrowth * random.nextDouble());
            tokens.add(t);
            this.sortedTokens.put(t, newUnit);
        }
        return tokens;
    }

    static class Weighted<T>
    implements Comparable<Weighted<T>> {
        final double weight;
        final T value;

        public Weighted(double weight, T value) {
            this.weight = weight;
            this.value = value;
        }

        @Override
        public int compareTo(Weighted<T> o) {
            int cmp = Double.compare(o.weight, this.weight);
            return cmp;
        }

        public String toString() {
            return String.format("%s<%s>", this.value, this.weight);
        }
    }

    static class TokenInfo<Unit>
    extends BaseTokenInfo<Unit, TokenInfo<Unit>> {
        public TokenInfo(Token token, UnitInfo<Unit> owningUnit) {
            super(token, owningUnit);
        }

        @Override
        TokenInfo<Unit> prevInRing() {
            return (TokenInfo)this.prev;
        }
    }

    static class BaseTokenInfo<Unit, T extends BaseTokenInfo<Unit, T>>
    extends CircularList<T> {
        final Token token;
        final UnitInfo<Unit> owningUnit;
        Token replicationStart;
        Token replicationThreshold;
        double replicatedOwnership = 0.0;

        public BaseTokenInfo(Token token, UnitInfo<Unit> owningUnit) {
            this.token = token;
            this.owningUnit = owningUnit;
        }

        public String toString() {
            return String.format("%s(%s)", this.token, this.owningUnit);
        }

        TokenInfo<Unit> prevInRing() {
            return null;
        }
    }

    private static class CircularList<T extends CircularList<T>> {
        T prev;
        T next;

        private CircularList() {
        }

        T insertAfter(T head, T unit) {
            if (head == null) {
                this.next = this;
                this.prev = this.next;
                return this.next;
            }
            assert (unit != null);
            assert (((CircularList)unit).next != null);
            this.prev = unit;
            this.next = ((CircularList)unit).next;
            ((CircularList)this.prev).next = this;
            ((CircularList)this.next).prev = this;
            return head;
        }

        T removeFrom(T head) {
            ((CircularList)this.next).prev = this.prev;
            ((CircularList)this.prev).next = this.next;
            return (T)(this == head ? (this == this.next ? null : this.next) : head);
        }
    }

    static class UnitInfo<Unit> {
        final Unit unit;
        final GroupInfo group;
        double ownership;
        int tokenCount;
        UnitInfo<Unit> prevUsed;
        double adjustedOwnership;

        private UnitInfo(Unit unit, GroupInfo group) {
            this.unit = unit;
            this.group = group;
            this.tokenCount = 0;
        }

        public UnitInfo(Unit unit, double ownership, Map<Object, GroupInfo> groupMap, ReplicationStrategy<Unit> strategy) {
            this(unit, TokenAllocatorBase.getGroup(unit, groupMap, strategy));
            this.ownership = ownership;
        }

        public String toString() {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.unit;
            objectArray[1] = this.unit == this.group.group ? (this.group.prevSeen != null ? "*" : "") : ":" + this.group.toString();
            objectArray[2] = this.ownership;
            objectArray[3] = this.prevUsed != null ? (this.prevUsed == this ? "#" : "->" + this.prevUsed.toString()) : "";
            return String.format("%s%s(%.2e)%s", objectArray);
        }
    }

    static class GroupInfo {
        final Object group;
        GroupInfo prevSeen = null;
        GroupInfo prevPopulate = null;
        static GroupInfo TERMINATOR = new GroupInfo(null);

        public GroupInfo(Object group) {
            this.group = group;
        }

        public String toString() {
            return this.group.toString() + (this.prevSeen != null ? "*" : "");
        }
    }
}

