/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils.trie;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.apache.cassandra.index.sasi.utils.trie.AbstractPatriciaTrie;
import org.apache.cassandra.index.sasi.utils.trie.KeyAnalyzer;
import org.apache.cassandra.index.sasi.utils.trie.Tries;

public class PatriciaTrie<K, V>
extends AbstractPatriciaTrie<K, V>
implements Serializable {
    private static final long serialVersionUID = -2246014692353432660L;

    public PatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        super(keyAnalyzer);
    }

    public PatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer, Map<? extends K, ? extends V> m3) {
        super(keyAnalyzer, m3);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyAnalyzer;
    }

    @Override
    public SortedMap<K, V> prefixMap(K prefix) {
        return this.lengthInBits(prefix) == 0 ? this : new PrefixRangeMap(prefix);
    }

    @Override
    public K firstKey() {
        return this.firstEntry().getKey();
    }

    @Override
    public K lastKey() {
        AbstractPatriciaTrie.TrieEntry<K, V> entry = this.lastEntry();
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new RangeEntryMap(null, toKey);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new RangeEntryMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new RangeEntryMap(fromKey, null);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> higherEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (!this.root.isEmpty()) {
                return this.size() > 1 ? this.nextEntry(this.root) : null;
            }
            return this.firstEntry();
        }
        AbstractPatriciaTrie.TrieEntry found = this.getNearestEntryForKey(key);
        if (this.compareKeys(key, found.key)) {
            return this.nextEntry(found);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (Tries.isValidBitIndex(bitIndex)) {
            return this.replaceCeil(key, bitIndex);
        }
        if (Tries.isNullBitKey(bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.firstEntry();
            }
            if (this.size() > 1) {
                return this.nextEntry(this.firstEntry());
            }
            return null;
        }
        if (Tries.isEqualBitKey(bitIndex)) {
            return this.nextEntry(found);
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    AbstractPatriciaTrie.TrieEntry<K, V> ceilingEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        AbstractPatriciaTrie.TrieEntry found = this.getNearestEntryForKey(key);
        if (this.compareKeys(key, found.key)) {
            return found;
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (Tries.isValidBitIndex(bitIndex)) {
            return this.replaceCeil(key, bitIndex);
        }
        if (Tries.isNullBitKey(bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        if (Tries.isEqualBitKey(bitIndex)) {
            return found;
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> replaceCeil(K key, int bitIndex) {
        AbstractPatriciaTrie.TrieEntry<K, Object> added = new AbstractPatriciaTrie.TrieEntry<K, Object>(key, null, bitIndex);
        this.addEntry(added);
        this.incrementSize();
        AbstractPatriciaTrie.TrieEntry<K, Object> ceil = this.nextEntry(added);
        this.removeEntry(added);
        this.modCount -= 2;
        return ceil;
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> replaceLower(K key, int bitIndex) {
        AbstractPatriciaTrie.TrieEntry<K, Object> added = new AbstractPatriciaTrie.TrieEntry<K, Object>(key, null, bitIndex);
        this.addEntry(added);
        this.incrementSize();
        AbstractPatriciaTrie.TrieEntry<K, Object> prior = this.previousEntry(added);
        this.removeEntry(added);
        this.modCount -= 2;
        return prior;
    }

    AbstractPatriciaTrie.TrieEntry<K, V> lowerEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            return null;
        }
        AbstractPatriciaTrie.TrieEntry found = this.getNearestEntryForKey(key);
        if (this.compareKeys(key, found.key)) {
            return this.previousEntry(found);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (Tries.isValidBitIndex(bitIndex)) {
            return this.replaceLower(key, bitIndex);
        }
        if (Tries.isNullBitKey(bitIndex)) {
            return null;
        }
        if (Tries.isEqualBitKey(bitIndex)) {
            return this.previousEntry(found);
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    AbstractPatriciaTrie.TrieEntry<K, V> floorEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            return !this.root.isEmpty() ? this.root : null;
        }
        AbstractPatriciaTrie.TrieEntry found = this.getNearestEntryForKey(key);
        if (this.compareKeys(key, found.key)) {
            return found;
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (Tries.isValidBitIndex(bitIndex)) {
            return this.replaceLower(key, bitIndex);
        }
        if (Tries.isNullBitKey(bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        if (Tries.isEqualBitKey(bitIndex)) {
            return found;
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> subtree(K prefix) {
        AbstractPatriciaTrie.TrieEntry entry;
        int lengthInBits = this.lengthInBits(prefix);
        AbstractPatriciaTrie.TrieEntry current = this.root.left;
        AbstractPatriciaTrie.TrieEntry path = this.root;
        while (current.bitIndex > path.bitIndex && lengthInBits >= current.bitIndex) {
            path = current;
            current = !this.isBitSet(prefix, current.bitIndex) ? current.left : current.right;
        }
        AbstractPatriciaTrie.TrieEntry trieEntry = entry = current.isEmpty() ? path : current;
        if (entry.isEmpty()) {
            return null;
        }
        if (entry == this.root && this.lengthInBits(entry.getKey()) < lengthInBits) {
            return null;
        }
        if (this.isBitSet(prefix, lengthInBits) != this.isBitSet(entry.key, lengthInBits)) {
            return null;
        }
        int bitIndex = this.bitIndex(prefix, entry.key);
        return bitIndex >= 0 && bitIndex < lengthInBits ? null : entry;
    }

    @Override
    private AbstractPatriciaTrie.TrieEntry<K, V> lastEntry() {
        return this.followRight(this.root.left);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> followRight(AbstractPatriciaTrie.TrieEntry<K, V> node) {
        if (node.right == null) {
            return null;
        }
        while (node.right.bitIndex > node.bitIndex) {
            node = node.right;
        }
        return node.right;
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> previousEntry(AbstractPatriciaTrie.TrieEntry<K, V> start) {
        if (start.predecessor == null) {
            throw new IllegalArgumentException("must have come from somewhere!");
        }
        if (start.predecessor.right == start) {
            return PatriciaTrie.isValidUplink(start.predecessor.left, start.predecessor) ? start.predecessor.left : this.followRight(start.predecessor.left);
        }
        AbstractPatriciaTrie.TrieEntry node = start.predecessor;
        while (node.parent != null && node == node.parent.left) {
            node = node.parent;
        }
        if (node.parent == null) {
            return null;
        }
        if (PatriciaTrie.isValidUplink(node.parent.left, node.parent)) {
            if (node.parent.left == this.root) {
                return this.root.isEmpty() ? null : this.root;
            }
            return node.parent.left;
        }
        return this.followRight(node.parent.left);
    }

    private AbstractPatriciaTrie.TrieEntry<K, V> nextEntryInSubtree(AbstractPatriciaTrie.TrieEntry<K, V> node, AbstractPatriciaTrie.TrieEntry<K, V> parentOfSubtree) {
        return node == null ? this.firstEntry() : this.nextEntryImpl(node.predecessor, node, parentOfSubtree);
    }

    private boolean isPrefix(K key, K prefix) {
        return this.keyAnalyzer.isPrefix(key, prefix);
    }

    private final class PrefixRangeEntrySet
    extends RangeEntrySet {
        private final PrefixRangeMap delegate;
        private AbstractPatriciaTrie.TrieEntry<K, V> prefixStart;
        private int expectedModCount;

        public PrefixRangeEntrySet(PrefixRangeMap delegate) {
            super(delegate);
            this.expectedModCount = -1;
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.fixup();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            if (PatriciaTrie.this.modCount != this.expectedModCount) {
                this.prefixStart = PatriciaTrie.this.subtree(this.delegate.prefix);
                this.expectedModCount = PatriciaTrie.this.modCount;
            }
            if (this.prefixStart == null) {
                Set empty = Collections.emptySet();
                return empty.iterator();
            }
            if (PatriciaTrie.this.lengthInBits(this.delegate.prefix) >= this.prefixStart.bitIndex) {
                return new SingletonIterator(this.prefixStart);
            }
            return new EntryIterator(this.prefixStart, this.delegate.prefix);
        }

        private final class EntryIterator
        extends AbstractPatriciaTrie.TrieIterator<Map.Entry<K, V>> {
            protected final K prefix;
            protected boolean lastOne;
            protected AbstractPatriciaTrie.TrieEntry<K, V> subtree;

            EntryIterator(AbstractPatriciaTrie.TrieEntry<K, V> startScan, K prefix) {
                this.subtree = startScan;
                this.next = PatriciaTrie.this.followLeft(startScan);
                this.prefix = prefix;
            }

            @Override
            public Map.Entry<K, V> next() {
                AbstractPatriciaTrie.TrieEntry entry = this.nextEntry();
                if (this.lastOne) {
                    this.next = null;
                }
                return entry;
            }

            @Override
            protected AbstractPatriciaTrie.TrieEntry<K, V> findNext(AbstractPatriciaTrie.TrieEntry<K, V> prior) {
                return PatriciaTrie.this.nextEntryInSubtree(prior, this.subtree);
            }

            @Override
            public void remove() {
                boolean needsFixing = false;
                int bitIdx = this.subtree.bitIndex;
                if (this.current == this.subtree) {
                    needsFixing = true;
                }
                super.remove();
                if (bitIdx != this.subtree.bitIndex || needsFixing) {
                    this.subtree = PatriciaTrie.this.subtree(this.prefix);
                }
                if (PatriciaTrie.this.lengthInBits(this.prefix) >= this.subtree.bitIndex) {
                    this.lastOne = true;
                }
            }
        }

        private final class SingletonIterator
        implements Iterator<Map.Entry<K, V>> {
            private final AbstractPatriciaTrie.TrieEntry<K, V> entry;
            private int hit = 0;

            public SingletonIterator(AbstractPatriciaTrie.TrieEntry<K, V> entry) {
                this.entry = entry;
            }

            @Override
            public boolean hasNext() {
                return this.hit == 0;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hit != 0) {
                    throw new NoSuchElementException();
                }
                ++this.hit;
                return this.entry;
            }

            @Override
            public void remove() {
                if (this.hit != 1) {
                    throw new IllegalStateException();
                }
                ++this.hit;
                PatriciaTrie.this.removeEntry(this.entry);
            }
        }
    }

    private class PrefixRangeMap
    extends RangeMap {
        private final K prefix;
        private K fromKey;
        private K toKey;
        private int expectedModCount;
        private int size;

        private PrefixRangeMap(K prefix) {
            this.fromKey = null;
            this.toKey = null;
            this.expectedModCount = -1;
            this.size = -1;
            this.prefix = prefix;
        }

        private int fixup() {
            if (this.size == -1 || PatriciaTrie.this.modCount != this.expectedModCount) {
                Iterator it = this.entrySet().iterator();
                this.size = 0;
                Map.Entry entry = null;
                if (it.hasNext()) {
                    entry = it.next();
                    this.size = 1;
                }
                Object v0 = (this.fromKey = entry == null ? null : entry.getKey());
                if (this.fromKey != null) {
                    AbstractPatriciaTrie.TrieEntry prior = PatriciaTrie.this.previousEntry((AbstractPatriciaTrie.TrieEntry)entry);
                    this.fromKey = prior == null ? null : prior.getKey();
                }
                this.toKey = this.fromKey;
                while (it.hasNext()) {
                    ++this.size;
                    entry = it.next();
                }
                this.toKey = entry == null ? null : entry.getKey();
                Object v1 = this.toKey;
                if (this.toKey != null) {
                    this.toKey = (entry = PatriciaTrie.this.nextEntry((AbstractPatriciaTrie.TrieEntry)entry)) == null ? null : entry.getKey();
                }
                this.expectedModCount = PatriciaTrie.this.modCount;
            }
            return this.size;
        }

        @Override
        public K firstKey() {
            Object first;
            this.fixup();
            AbstractPatriciaTrie.TrieEntry e = this.fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.higherEntry(this.fromKey);
            Object k = first = e != null ? (Object)e.getKey() : null;
            if (e == null || !PatriciaTrie.this.isPrefix(first, this.prefix)) {
                throw new NoSuchElementException();
            }
            return first;
        }

        @Override
        public K lastKey() {
            Object last;
            this.fixup();
            AbstractPatriciaTrie.TrieEntry e = this.toKey == null ? PatriciaTrie.this.lastEntry() : PatriciaTrie.this.lowerEntry(this.toKey);
            Object k = last = e != null ? (Object)e.getKey() : null;
            if (e == null || !PatriciaTrie.this.isPrefix(last, this.prefix)) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        protected boolean inRange(K key) {
            return PatriciaTrie.this.isPrefix(key, this.prefix);
        }

        @Override
        protected boolean inRange2(K key) {
            return this.inRange(key);
        }

        @Override
        protected boolean inFromRange(K key, boolean forceInclusive) {
            return PatriciaTrie.this.isPrefix(key, this.prefix);
        }

        @Override
        protected boolean inToRange(K key, boolean forceInclusive) {
            return PatriciaTrie.this.isPrefix(key, this.prefix);
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new PrefixRangeEntrySet(this);
        }

        @Override
        public K getFromKey() {
            return this.fromKey;
        }

        @Override
        public K getToKey() {
            return this.toKey;
        }

        @Override
        public boolean isFromInclusive() {
            return false;
        }

        @Override
        public boolean isToInclusive() {
            return false;
        }

        @Override
        protected SortedMap<K, V> createRangeMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return new RangeEntryMap(fromKey, fromInclusive, toKey, toInclusive);
        }
    }

    private class RangeEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final RangeMap delegate;
        private int size = -1;
        private int expectedModCount = -1;

        public RangeEntrySet(RangeMap delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Object fromKey = this.delegate.getFromKey();
            Object toKey = this.delegate.getToKey();
            AbstractPatriciaTrie.TrieEntry first = fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.ceilingEntry(fromKey);
            AbstractPatriciaTrie.TrieEntry last = null;
            if (toKey != null) {
                last = PatriciaTrie.this.ceilingEntry(toKey);
            }
            return new EntryIterator(first, last);
        }

        @Override
        public int size() {
            if (this.size == -1 || this.expectedModCount != PatriciaTrie.this.modCount) {
                this.size = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++this.size;
                    it.next();
                }
                this.expectedModCount = PatriciaTrie.this.modCount;
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (!this.delegate.inRange(key)) {
                return false;
            }
            AbstractPatriciaTrie.TrieEntry node = PatriciaTrie.this.getEntry(key);
            return node != null && Tries.areEqual(node.getValue(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (!this.delegate.inRange(key)) {
                return false;
            }
            AbstractPatriciaTrie.TrieEntry node = PatriciaTrie.this.getEntry(key);
            if (node != null && Tries.areEqual(node.getValue(), entry.getValue())) {
                PatriciaTrie.this.removeEntry(node);
                return true;
            }
            return false;
        }

        private final class EntryIterator
        extends AbstractPatriciaTrie.TrieIterator<Map.Entry<K, V>> {
            private final K excludedKey;

            private EntryIterator(AbstractPatriciaTrie.TrieEntry<K, V> first, AbstractPatriciaTrie.TrieEntry<K, V> last) {
                super(first);
                this.excludedKey = last != null ? last.getKey() : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null && !Tries.areEqual(this.next.key, this.excludedKey);
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.next == null || Tries.areEqual(this.next.key, this.excludedKey)) {
                    throw new NoSuchElementException();
                }
                return this.nextEntry();
            }
        }
    }

    private class RangeEntryMap
    extends RangeMap {
        protected final K fromKey;
        protected final K toKey;
        protected final boolean fromInclusive;
        protected final boolean toInclusive;

        protected RangeEntryMap(K fromKey, K toKey) {
            this(fromKey, true, toKey, false);
        }

        protected RangeEntryMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null && toKey == null) {
                throw new IllegalArgumentException("must have a from or to!");
            }
            if (fromKey != null && toKey != null && PatriciaTrie.this.keyAnalyzer.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.fromInclusive = fromInclusive;
            this.toKey = toKey;
            this.toInclusive = toInclusive;
        }

        @Override
        public K firstKey() {
            Object first;
            AbstractPatriciaTrie.TrieEntry e = this.fromKey == null ? PatriciaTrie.this.firstEntry() : (this.fromInclusive ? PatriciaTrie.this.ceilingEntry(this.fromKey) : PatriciaTrie.this.higherEntry(this.fromKey));
            Object k = first = e != null ? (Object)e.getKey() : null;
            if (e == null || this.toKey != null && !this.inToRange(first, false)) {
                throw new NoSuchElementException();
            }
            return first;
        }

        @Override
        public K lastKey() {
            Object last;
            AbstractPatriciaTrie.TrieEntry e = this.toKey == null ? PatriciaTrie.this.lastEntry() : (this.toInclusive ? PatriciaTrie.this.floorEntry(this.toKey) : PatriciaTrie.this.lowerEntry(this.toKey));
            Object k = last = e != null ? (Object)e.getKey() : null;
            if (e == null || this.fromKey != null && !this.inFromRange(last, false)) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new RangeEntrySet(this);
        }

        @Override
        public K getFromKey() {
            return this.fromKey;
        }

        @Override
        public K getToKey() {
            return this.toKey;
        }

        @Override
        public boolean isFromInclusive() {
            return this.fromInclusive;
        }

        @Override
        public boolean isToInclusive() {
            return this.toInclusive;
        }

        @Override
        protected SortedMap<K, V> createRangeMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return new RangeEntryMap(fromKey, fromInclusive, toKey, toInclusive);
        }
    }

    private abstract class RangeMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        private volatile transient Set<Map.Entry<K, V>> entrySet;

        private RangeMap() {
        }

        protected abstract Set<Map.Entry<K, V>> createEntrySet();

        protected abstract K getFromKey();

        protected abstract boolean isFromInclusive();

        protected abstract K getToKey();

        protected abstract boolean isToInclusive();

        @Override
        public Comparator<? super K> comparator() {
            return PatriciaTrie.this.comparator();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inRange(Tries.cast(key)) && PatriciaTrie.this.containsKey(key);
        }

        @Override
        public V remove(Object key) {
            return !this.inRange(Tries.cast(key)) ? null : PatriciaTrie.this.remove(key);
        }

        @Override
        public V get(Object key) {
            return !this.inRange(Tries.cast(key)) ? null : PatriciaTrie.this.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("Key is out of range: " + key);
            }
            return PatriciaTrie.this.put(key, value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = this.createEntrySet();
            }
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("FromKey is out of range: " + fromKey);
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("ToKey is out of range: " + toKey);
            }
            return this.createRangeMap(fromKey, this.isFromInclusive(), toKey, this.isToInclusive());
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("ToKey is out of range: " + toKey);
            }
            return this.createRangeMap(this.getFromKey(), this.isFromInclusive(), toKey, this.isToInclusive());
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("FromKey is out of range: " + fromKey);
            }
            return this.createRangeMap(fromKey, this.isFromInclusive(), this.getToKey(), this.isToInclusive());
        }

        protected boolean inRange(K key) {
            Object fromKey = this.getFromKey();
            Object toKey = this.getToKey();
            return !(fromKey != null && !this.inFromRange(key, false) || toKey != null && !this.inToRange(key, false));
        }

        protected boolean inRange2(K key) {
            Object fromKey = this.getFromKey();
            Object toKey = this.getToKey();
            return !(fromKey != null && !this.inFromRange(key, false) || toKey != null && !this.inToRange(key, true));
        }

        protected boolean inFromRange(K key, boolean forceInclusive) {
            Object fromKey = this.getFromKey();
            boolean fromInclusive = this.isFromInclusive();
            int ret = PatriciaTrie.this.keyAnalyzer.compare(key, fromKey);
            return fromInclusive || forceInclusive ? ret >= 0 : ret > 0;
        }

        protected boolean inToRange(K key, boolean forceInclusive) {
            Object toKey = this.getToKey();
            boolean toInclusive = this.isToInclusive();
            int ret = PatriciaTrie.this.keyAnalyzer.compare(key, toKey);
            return toInclusive || forceInclusive ? ret <= 0 : ret < 0;
        }

        protected abstract SortedMap<K, V> createRangeMap(K var1, boolean var2, K var3, boolean var4);
    }
}

