/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.Map;
import java.util.TreeMap;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

public class ThreadSplitAggregator {
    private ThreadDumpAggregatorFactory[] aggregators;
    private Map<Long, ThreadTrack> data = new TreeMap<Long, ThreadTrack>();

    public ThreadSplitAggregator(ThreadDumpAggregatorFactory ... aggregators) {
        this.aggregators = aggregators;
    }

    public void feed(ThreadSnapshot threadDump) {
        ThreadTrack tt = this.track(threadDump.threadId());
        this.process(tt, threadDump);
    }

    private ThreadTrack track(long threadId) {
        ThreadTrack tt = this.data.get(threadId);
        if (tt == null) {
            tt = new ThreadTrack();
            tt.aggregations = new ThreadDumpAggregator[this.aggregators.length];
            for (int i = 0; i != tt.aggregations.length; ++i) {
                tt.aggregations[i] = this.aggregators[i].newInstance();
            }
            this.data.put(threadId, tt);
        }
        return tt;
    }

    private void process(ThreadTrack tt, ThreadSnapshot threadDump) {
        for (ThreadDumpAggregator tda : tt.aggregations) {
            tda.aggregate(threadDump);
        }
        tt.threadName = threadDump.threadName();
    }

    public Object[][] report() {
        Object[][] result = new Object[this.data.size()][];
        int n = 0;
        for (long threadId : this.data.keySet()) {
            result[n] = new Object[this.aggregators.length + 2];
            ThreadTrack tt = this.data.get(threadId);
            result[n][0] = tt.threadName;
            result[n][1] = threadId;
            for (int i = 0; i != this.aggregators.length; ++i) {
                result[n][2 + i] = tt.aggregations[i].info();
            }
            ++n;
        }
        return result;
    }

    private static class ThreadTrack {
        String threadName;
        ThreadDumpAggregator[] aggregations;

        private ThreadTrack() {
        }
    }
}

