/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeRangeChecker {
    private static String DATE_FORMAT = "yyyy.MM.dd_HH:mm:ss";
    private static String DATE_PATTERN = "(((((((\\d\\d)?\\d\\d[.])?\\d\\d[.])?\\d\\d[_])?\\d\\d[:])?\\d\\d[:])\\d\\d)";
    private long[] whiteCache = new long[0];
    private long[] blackCache = new long[0];
    private int[] lowerBound;
    private int[] upperBound;
    private TimeZone tz;
    private boolean inverted = false;
    private static int[] FIELDS = new int[]{1, 1, 2, 5, 11, 12, 13};

    public TimeRangeChecker(String lower, String upper, TimeZone tz) {
        this.lowerBound = this.parse(lower);
        this.upperBound = this.parse(upper);
        this.tz = tz;
        if (tz == null) {
            throw new NullPointerException("tz is null");
        }
        for (int i = 0; i != this.lowerBound.length; ++i) {
            if (this.lowerBound[i] == -1 && this.upperBound[i] != -1 || this.lowerBound[i] != -1 && this.upperBound[i] == -1) {
                throw new IllegalArgumentException("Bounds length mismatch '" + lower + "', '" + upper + "'");
            }
            if (this.lowerBound[i] == this.upperBound[i]) continue;
            if (this.lowerBound[i] <= this.upperBound[i]) break;
            this.inverted = true;
            break;
        }
    }

    private int[] parse(String bound) {
        try {
            Matcher m3 = Pattern.compile(DATE_PATTERN).matcher(bound);
            if (!m3.matches()) {
                throw new IllegalArgumentException("Cannot parser time range bound '" + bound + "'");
            }
            int[] p = new int[7];
            Arrays.fill(p, -1);
            if (m3.group(7) != null) {
                p[0] = Integer.parseInt(m3.group(7));
            }
            if (m3.group(6) != null) {
                p[1] = Integer.parseInt(this.substring(m3.group(6), 2, 1));
            }
            if (m3.group(5) != null) {
                p[2] = Integer.parseInt(this.substring(m3.group(5), 2, 1));
            }
            if (m3.group(4) != null) {
                p[3] = Integer.parseInt(this.substring(m3.group(4), 2, 1));
            }
            if (m3.group(3) != null) {
                p[4] = Integer.parseInt(this.substring(m3.group(3), 2, 1));
            }
            if (m3.group(2) != null) {
                p[5] = Integer.parseInt(this.substring(m3.group(2), 2, 1));
            }
            if (m3.group(1) != null) {
                p[6] = Integer.parseInt(this.substring(m3.group(1), 2, 0));
            }
            return p;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parser time range bound '" + bound + "'");
        }
    }

    private String substring(String txt, int n, int m3) {
        return txt.substring(txt.length() - n - m3, txt.length() - m3);
    }

    boolean isCached(long timestamp) {
        return this.match(this.whiteCache, timestamp) || this.match(this.blackCache, timestamp);
    }

    public boolean evaluate(long timestamp) {
        if (this.match(this.whiteCache, timestamp)) {
            return true;
        }
        if (this.match(this.blackCache, timestamp)) {
            return false;
        }
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
        fmt.setTimeZone(this.tz);
        String date = fmt.format(timestamp);
        int[] p = this.parse(date);
        int[] rl = Arrays.copyOf(p, p.length);
        int[] ru = Arrays.copyOf(p, p.length);
        boolean match = this.match(p, this.lowerBound, this.upperBound);
        for (int j = 0; j != rl.length; ++j) {
            if (this.lowerBound[j] == -1) continue;
            rl[j] = this.lowerBound[j];
            ru[j] = this.upperBound[j];
        }
        if (match) {
            long ldate = this.toDate(rl);
            long udate = this.toDate(ru);
            if (ldate == -1L || udate == -1L) {
                return true;
            }
            if (udate > ldate) {
                this.whiteCache = this.add(this.whiteCache, ldate, udate);
            } else if (timestamp >= ldate && timestamp >= udate) {
                udate = this.adjust(udate, 1);
                this.whiteCache = this.add(this.whiteCache, ldate, udate);
            } else {
                ldate = this.adjust(ldate, -1);
                this.whiteCache = this.add(this.whiteCache, ldate, udate);
            }
            return true;
        }
        long ldate = this.toDate(rl);
        long udate = this.toDate(ru);
        if (ldate == -1L || udate == -1L) {
            return false;
        }
        if (timestamp >= ldate && timestamp >= udate) {
            ldate = this.adjust(ldate, 1);
            this.blackCache = this.add(this.blackCache, udate, ldate);
        } else {
            udate = this.adjust(udate, -1);
            this.blackCache = this.add(this.blackCache, udate, ldate);
        }
        return false;
    }

    private boolean match(int[] p, int[] lower, int[] upper) {
        boolean matchUpper = true;
        boolean matchLower = true;
        for (int i = 0; i != this.lowerBound.length; ++i) {
            if (this.lowerBound[i] == -1) continue;
            if (this.checkInRange(p, i, matchLower, matchUpper)) {
                if (this.upperBound[i] != p[i]) {
                    matchUpper = false;
                }
                if (this.lowerBound[i] != p[i]) {
                    matchLower = false;
                }
                if (matchLower || matchUpper) continue;
                return true;
            }
            return false;
        }
        return !matchUpper;
    }

    private boolean checkInRange(int[] p, int i, boolean matchLower, boolean matchUpper) {
        if (this.inverted) {
            return matchLower && this.lowerBound[i] <= p[i] || matchUpper && this.upperBound[i] >= p[i];
        }
        return !(matchLower && this.lowerBound[i] > p[i] || matchUpper && this.upperBound[i] < p[i]);
    }

    private long adjust(long ldate, int step) {
        Calendar cal = Calendar.getInstance(this.tz);
        cal.setTime(new Date(ldate));
        int n = -1;
        for (int i = 0; i != this.lowerBound.length; ++i) {
            if (this.lowerBound[i] != -1) continue;
            n = i;
        }
        if (n == -1) {
            cal.add(1, 100 * step);
        } else if (n == 0) {
            cal.add(1, 10 * step);
        } else {
            cal.add(FIELDS[n], step);
        }
        return cal.getTimeInMillis();
    }

    private long[] add(long[] cache, long ldate, long udate) {
        long[] ncache = Arrays.copyOf(cache, cache.length + 2);
        ncache[cache.length] = ldate;
        ncache[cache.length + 1] = udate;
        return ncache;
    }

    private long toDate(int[] r) {
        try {
            Object[] args = new Object[7];
            for (int i = 0; i != 7; ++i) {
                args[i] = r[i];
            }
            SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
            fmt.setTimeZone(this.tz);
            String date = String.format("%02d%02d.%02d.%02d_%02d:%02d:%02d", args);
            return fmt.parse(date).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    private boolean match(long[] cache, long timestamp) {
        for (int n = 0; n < cache.length; n += 2) {
            if (cache[n] > timestamp || cache[n + 1] <= timestamp) continue;
            return true;
        }
        return false;
    }
}

