/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildInfo.class);
    public static final String APPLICATION_NAME = "cassandra-analytics";
    public static final String BUILD_VERSION = BuildInfo.getBuildVersion();
    public static final String BUILD_VERSION_AND_REVISION = BuildInfo.getBuildVersionAndRevision();
    public static final String READER_USER_AGENT = BuildInfo.getUserAgent("reader");
    public static final String WRITER_USER_AGENT = BuildInfo.getUserAgent("writer");
    public static final String WRITER_S3_USER_AGENT = BuildInfo.getUserAgent("writer-s3");

    private BuildInfo() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    private static String getUserAgent(String feature) {
        return String.format("%s/%s %s", APPLICATION_NAME, BUILD_VERSION, feature);
    }

    @VisibleForTesting
    static String getBuildVersion() {
        return BuildInfo.getBuildInfo(properties -> properties.getProperty("build-version"));
    }

    public static boolean isAtLeastJava11(String version) {
        if (version == null) {
            return false;
        }
        if (version.contains(".")) {
            return version.compareTo("11") >= 0;
        }
        return Integer.parseInt(version) >= 11;
    }

    public static String javaSpecificationVersion() {
        String javaSpecificationVersionPropertyName = "java.specification.version";
        try {
            return System.getProperty(javaSpecificationVersionPropertyName);
        }
        catch (SecurityException exception) {
            LOGGER.error("Unable to determine java specification version from system property={}", (Object)javaSpecificationVersionPropertyName, (Object)exception);
            return null;
        }
    }

    private static String getBuildVersionAndRevision() {
        return BuildInfo.getBuildInfo(properties -> properties.getProperty("build-version") + "-" + properties.getProperty("build-rev"));
    }

    private static String getBuildInfo(Function<Properties, String> extractor) {
        String string;
        block8: {
            InputStream in = BuildInfo.class.getResourceAsStream("/cassandra-analytics-build.properties");
            try {
                Properties properties = new Properties();
                properties.load(in);
                string = extractor.apply(properties);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.warn("Could not load the resource to get Cassandra Analytics build version", (Throwable)exception);
                    return "unknown";
                }
            }
            in.close();
        }
        return string;
    }
}

