/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.CommitResult;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.StreamError;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkWriteValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkWriteValidator.class);
    private static final int ERROR_MESSAGE_MAX_LENGTH = 65536;
    private final ClusterInfo cluster;
    private final ReplicaAwareFailureHandler<RingInstance> failureHandler;
    private final JobInfo job;
    private String phase = "Initializing";

    public BulkWriteValidator(BulkWriterContext bulkWriterContext, ReplicaAwareFailureHandler<RingInstance> failureHandler) {
        this.cluster = bulkWriterContext.cluster();
        this.job = bulkWriterContext.job();
        this.failureHandler = failureHandler;
    }

    public static void validateClOrFail(TokenRangeMapping<RingInstance> tokenRangeMapping, ReplicaAwareFailureHandler<RingInstance> failureHandler, Logger logger, String phase, JobInfo job, ClusterInfo cluster) {
        List<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> failedRanges = failureHandler.getFailedRanges(tokenRangeMapping, job, cluster);
        if (!failedRanges.isEmpty()) {
            String header = String.format("Failed to write %s ranges with %s for job %s in phase %s. ", failedRanges.size(), job.getConsistencyLevel(), job.getId(), phase);
            String errorDetails = BulkWriteValidator.logEachErrorAndAggregate(logger, phase, failedRanges);
            String message = header + errorDetails;
            logger.error(message);
            throw new ConsistencyNotSatisfiedException(message);
        }
        logger.info("Succeeded {} with {}", (Object)phase, (Object)job.getConsistencyLevel());
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        LOGGER.info("Updating write phase from {} to {}", (Object)this.phase, (Object)phase);
        this.phase = phase;
    }

    public synchronized void updateFailureHandler(List<StreamError> streamErrors) {
        streamErrors.forEach(err -> {
            LOGGER.info("Populate stream error from tasks. {}", err);
            this.failureHandler.addFailure(err.failedRange, err.instance, err.errMsg);
        });
    }

    public static void updateFailureHandler(CommitResult commitResult, String phase, ReplicaAwareFailureHandler<RingInstance> failureHandler) {
        LOGGER.debug("Commit Result: {}", (Object)commitResult);
        commitResult.failures.forEach((uuid, err) -> {
            LOGGER.warn("[{}]: {} failed on {} with message {}", new Object[]{uuid, phase, commitResult.instance.nodeName(), err.errMsg});
            failureHandler.addFailure(err.tokenRange, commitResult.instance, err.errMsg);
        });
    }

    private static String logEachErrorAndAggregate(Logger logger, String phase, List<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> failedRanges) {
        StringBuilder sb = new StringBuilder();
        for (ReplicaAwareFailureHandler.ConsistencyFailurePerRange failedRange : failedRanges) {
            for (Map.Entry entry : failedRange.failuresPerInstance.entrySet()) {
                logger.error("Failed in phase {} for {} on {}. Failure: {}", new Object[]{phase, failedRange.range, entry.getKey(), entry.getValue()});
                if (sb.length() >= 65536) {
                    sb.setLength(65533);
                    sb.append("...");
                    continue;
                }
                sb.append("Instance: ").append(entry.getKey()).append(" All failures: ").append(entry.getValue());
            }
        }
        return sb.toString();
    }

    public void updateFailureHandler(Range<BigInteger> failedRange, RingInstance instance, String reason) {
        this.failureHandler.addFailure(failedRange, instance, reason);
    }

    public void validateClOrFail(TokenRangeMapping<RingInstance> tokenRangeMapping) {
        this.validateClOrFail(tokenRangeMapping, true);
    }

    public void validateClOrFail(TokenRangeMapping<RingInstance> tokenRangeMapping, boolean refreshInstanceAvailability) {
        if (refreshInstanceAvailability) {
            this.updateInstanceAvailability();
        }
        BulkWriteValidator.validateClOrFail(tokenRangeMapping, this.failureHandler, LOGGER, this.phase, this.job, this.cluster);
    }

    private void updateInstanceAvailability() {
        this.cluster.refreshClusterInfo();
        Map<RingInstance, WriteAvailability> availability = this.cluster.clusterWriteAvailability();
        availability.forEach(this::validateAvailabilityAndUpdateFailures);
    }

    private void validateAvailabilityAndUpdateFailures(RingInstance instance, WriteAvailability availability) {
        switch (availability) {
            case INVALID_STATE: {
                String errorMessage = String.format("Instance (%s) is in an invalid state (%s) during import. Please rerun import once topology changes are complete.", instance.nodeName(), instance.nodeState());
                throw new RuntimeException(errorMessage);
            }
            case UNAVAILABLE_DOWN: {
                Collection unavailableRanges = this.cluster.getTokenRangeMapping(true).getTokenRanges().get((Object)instance);
                unavailableRanges.forEach(failedRange -> {
                    String nodeDisplayName = instance.nodeName();
                    String message = String.format("%s %s", nodeDisplayName, availability.getMessage());
                    LOGGER.warn("{} failed in phase {} on {} because {}", new Object[]{failedRange, this.phase, nodeDisplayName, message});
                    this.failureHandler.addFailure((Range<BigInteger>)failedRange, instance, message);
                });
                break;
            }
        }
    }
}

