/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.spark.bulkwriter.CommitError;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitResult
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitResult.class);
    private static final long serialVersionUID = 773475991511158249L;
    public final String migrationId;
    protected RingInstance instance;
    public final Map<String, Range<BigInteger>> passed;
    public final Map<String, CommitError> failures;

    public CommitResult(String migrationId, RingInstance instance, Map<String, Range<BigInteger>> commitRanges) {
        this.migrationId = migrationId;
        this.instance = instance;
        this.passed = new HashMap<String, Range<BigInteger>>(commitRanges);
        this.failures = new HashMap<String, CommitError>();
    }

    public void addFailedCommit(String uuid, @NotNull Range<BigInteger> tokenRange, @NotNull String error) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Adding failed commit with missing UUID");
        Preconditions.checkNotNull(tokenRange, (Object)"Adding failed commit with missing token range");
        Preconditions.checkNotNull((Object)error, (Object)"Adding failed commit with missing error message");
        LOGGER.error("[{}]: Failed to commit {} on {}: {}", new Object[]{uuid, tokenRange, this.instance, error});
        this.passed.remove(uuid);
        this.failures.put(uuid, new CommitError(tokenRange, error));
    }

    public String toString() {
        return String.format("CommitResult{migrationId='%s', instance=%s, passed=%s, failures=%s}", this.migrationId, this.instance, this.passed, this.failures);
    }
}

