/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.common.request.ImportSSTableRequest;
import o.a.c.sidecar.client.shaded.common.response.SSTableImportResponse;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarDataTransferApi
implements DirectDataTransferApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarDataTransferApi.class);
    private static final String SSTABLE_NAME_SEPARATOR = "-";
    private static final int SSTABLE_GENERATION_REVERSE_OFFSET = 3;
    private final SidecarClient sidecarClient;
    private final CassandraBridge bridge;
    private final int sidecarPort;
    private final JobInfo job;

    public SidecarDataTransferApi(CassandraContext cassandraContext, CassandraBridge bridge, JobInfo job) {
        this.sidecarClient = cassandraContext.getSidecarClient();
        this.sidecarPort = cassandraContext.sidecarPort();
        this.bridge = bridge;
        this.job = job;
    }

    @Override
    public void uploadSSTableComponent(Path componentFile, int ssTableIdx, CassandraInstance instance, String sessionID, Digest digest) throws SidecarApiCallException {
        String componentName = this.updateComponentName(componentFile, ssTableIdx);
        String uploadId = this.getUploadId(sessionID, this.job.getRestoreJobId().toString());
        QualifiedTableName qt = this.job.qualifiedTableName();
        try {
            this.sidecarClient.uploadSSTableRequest((SidecarInstance)this.toSidecarInstance(instance), CassandraBridgeFactory.maybeQuotedIdentifier(this.bridge, qt.quoteIdentifiers(), qt.keyspace()), CassandraBridgeFactory.maybeQuotedIdentifier(this.bridge, qt.quoteIdentifiers(), qt.table()), uploadId, componentName, digest.toSidecarDigest(), componentFile.toAbsolutePath().toString()).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            LOGGER.warn("Failed to upload file={}, keyspace={}, table={}, uploadId={}, componentName={}, instance={}", new Object[]{componentFile, qt.keyspace(), qt.table(), uploadId, componentName, instance, exception});
            throw new SidecarApiCallException(String.format("Failed to upload file=%s into keyspace=%s, table=%s, componentName=%s with uploadId=%s to instance=%s. Cause=%s", componentFile, qt.keyspace(), qt.table(), componentName, uploadId, instance, exception.getMessage()), (Throwable)exception);
        }
    }

    @Override
    public DirectDataTransferApi.RemoteCommitResult commitSSTables(CassandraInstance instance, String migrationId, List<String> uuids) throws SidecarApiCallException {
        if (uuids.size() != 1) {
            throw new UnsupportedOperationException("Only a single UUID is supported, you provided " + uuids.size());
        }
        String uploadId = this.getUploadId(uuids.get(0), this.job.getRestoreJobId().toString());
        ImportSSTableRequest.ImportOptions importOptions = new ImportSSTableRequest.ImportOptions();
        importOptions.verifySSTables(true).extendedVerify(!this.job.skipExtendedVerify());
        try {
            QualifiedTableName qt = this.job.qualifiedTableName();
            SSTableImportResponse response = (SSTableImportResponse)this.sidecarClient.importSSTableRequest((SidecarInstance)this.toSidecarInstance(instance), CassandraBridgeFactory.maybeQuotedIdentifier(this.bridge, qt.quoteIdentifiers(), qt.keyspace()), CassandraBridgeFactory.maybeQuotedIdentifier(this.bridge, qt.quoteIdentifiers(), qt.table()), uploadId, importOptions).get();
            if (response.success()) {
                return new DirectDataTransferApi.RemoteCommitResult(response.success(), Collections.emptyList(), Collections.singletonList(uploadId), null);
            }
            return new DirectDataTransferApi.RemoteCommitResult(response.success(), Collections.singletonList(uploadId), Collections.emptyList(), null);
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SidecarApiCallException("Failed to commit sorted string tables", (Throwable)exception);
        }
    }

    @Override
    public void cleanUploadSession(CassandraInstance instance, String sessionID, String jobID) throws SidecarApiCallException {
        String uploadId = this.getUploadId(sessionID, jobID);
        try {
            this.sidecarClient.cleanUploadSession((SidecarInstance)this.toSidecarInstance(instance), uploadId).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            LOGGER.warn("Failed to clean upload uploadId={}, instance={}", (Object)uploadId, (Object)instance);
            throw new SidecarApiCallException("Failed to clean the upload session with ID " + uploadId, (Throwable)exception);
        }
    }

    protected String updateComponentName(Path componentFile, int ssTableIdx) {
        CharSequence[] ssTableNameParts = componentFile.getFileName().toString().split(SSTABLE_NAME_SEPARATOR);
        if (ssTableNameParts.length < 3) {
            throw new IllegalArgumentException("Invalid component file name: " + String.valueOf(componentFile.getFileName()));
        }
        ssTableNameParts[ssTableNameParts.length - 3] = Integer.toString(ssTableIdx);
        return String.join((CharSequence)SSTABLE_NAME_SEPARATOR, ssTableNameParts);
    }

    protected String getUploadId(String sessionID, String jobId) {
        return sessionID + SSTABLE_NAME_SEPARATOR + jobId;
    }

    protected SidecarInstanceImpl toSidecarInstance(CassandraInstance instance) {
        return new SidecarInstanceImpl(instance.nodeName(), this.sidecarPort);
    }
}

