/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.SidecarInstanceImpl;
import org.apache.cassandra.sidecar.codecs.SidecarInstanceCodec;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.SidecarPeerHealthConfiguration;
import org.apache.cassandra.sidecar.coordination.SidecarPeerHealthProvider;
import org.apache.cassandra.sidecar.coordination.SidecarPeerProvider;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.apache.cassandra.sidecar.utils.EventBusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SidecarPeerHealthMonitorTask
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarPeerHealthMonitorTask.class);
    private EventBus eventBus;
    private final SidecarPeerHealthConfiguration config;
    private final SidecarPeerProvider sidecarPeerProvider;
    private final SidecarPeerHealthProvider healthProvider;
    private final Map<SidecarInstance, SidecarPeerHealthProvider.Health> status = new ConcurrentHashMap<SidecarInstance, SidecarPeerHealthProvider.Health>();

    @Inject
    public SidecarPeerHealthMonitorTask(SidecarConfiguration sidecarConfiguration, SidecarPeerProvider sidecarPeerProvider, SidecarPeerHealthProvider healthProvider) {
        this.config = sidecarConfiguration.sidecarPeerHealthConfiguration();
        this.sidecarPeerProvider = sidecarPeerProvider;
        this.healthProvider = healthProvider;
    }

    public Map<SidecarInstance, SidecarPeerHealthProvider.Health> status() {
        return this.status;
    }

    @Override
    public void deploy(Vertx vertx, PeriodicTaskExecutor executor) {
        this.eventBus = vertx.eventBus();
        this.eventBus.registerDefaultCodec(SidecarInstanceImpl.class, new SidecarInstanceCodec());
        EventBusUtils.onceLocalConsumer(this.eventBus, SidecarServerEvents.ON_CASSANDRA_CQL_READY.address(), ignored -> executor.schedule(this));
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        return this.config.enabled() ? ScheduleDecision.EXECUTE : ScheduleDecision.SKIP;
    }

    @Override
    public DurationSpec delay() {
        return this.config.executeInterval();
    }

    @Override
    public void execute(Promise<Void> promise) {
        try {
            this.run().onSuccess(v -> promise.tryComplete()).onFailure(arg_0 -> promise.tryFail(arg_0));
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error running down detector", t);
            promise.fail(t);
        }
    }

    protected Future<CompositeFuture> run() {
        Set<SidecarInstance> sidecarPeers = this.sidecarPeerProvider.get();
        if (sidecarPeers.isEmpty()) {
            LOGGER.warn("No Sidecar sidecarPeers detected");
            return Future.succeededFuture();
        }
        List futures = sidecarPeers.stream().map(instance -> this.healthProvider.health((SidecarInstance)instance).onSuccess(healthCheckResult -> this.updateHealth((SidecarInstance)instance, (SidecarPeerHealthProvider.Health)((Object)((Object)healthCheckResult)))).onFailure(throwable -> {
            LOGGER.error("Failed to run health check, marking instance as DOWN host={} port={}", new Object[]{instance.hostname(), instance.port(), throwable});
            this.markDown((SidecarInstance)instance);
        })).collect(Collectors.toList());
        return Future.all(futures).onComplete(f -> {
            if (f.succeeded()) {
                this.status.keySet().retainAll(sidecarPeers);
            } else {
                LOGGER.error("Unexpected error in down detector", f.cause());
            }
        });
    }

    protected void updateHealth(SidecarInstance instance, SidecarPeerHealthProvider.Health health) {
        switch (health) {
            case UP: {
                this.markOk(instance);
                break;
            }
            case DOWN: {
                this.markDown(instance);
            }
        }
    }

    protected void markOk(SidecarInstance instance) {
        if (this.compareAndUpdate(instance, SidecarPeerHealthProvider.Health.UP)) {
            LOGGER.info("Sidecar instance is now OK hostname={} port={}", (Object)instance.hostname(), (Object)instance.port());
            this.eventBus.publish(SidecarServerEvents.ON_SIDECAR_PEER_UP.address(), (Object)instance);
        }
    }

    protected void markDown(SidecarInstance instance) {
        if (this.compareAndUpdate(instance, SidecarPeerHealthProvider.Health.DOWN)) {
            LOGGER.warn("Sidecar instance is now DOWN hostname={} port={}", (Object)instance.hostname(), (Object)instance.port());
            this.eventBus.publish(SidecarServerEvents.ON_SIDECAR_PEER_DOWN.address(), (Object)instance);
        }
    }

    protected boolean compareAndUpdate(SidecarInstance instance, SidecarPeerHealthProvider.Health newStatus) {
        return this.status.put(instance, newStatus) != newStatus;
    }
}

