/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import org.apache.cassandra.sidecar.adapters.base.exception.OperationUnavailableException;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.common.server.exceptions.JmxAuthenticationException;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.exceptions.NoSuchCassandraInstanceException;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler<T>
implements Handler<RoutingContext> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String INSTANCE_ID = "instanceId";
    protected static final String KEYSPACE_PATH_PARAM = "keyspace";
    protected static final String TABLE_PATH_PARAM = "table";
    protected final InstanceMetadataFetcher metadataFetcher;
    protected final ExecutorPools executorPools;
    protected final CassandraInputValidator validator;

    protected AbstractHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        this.metadataFetcher = metadataFetcher;
        this.executorPools = executorPools;
        this.validator = validator;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        String host = this.host(context);
        SocketAddress remoteAddress = request.remoteAddress();
        T requestParams = null;
        try {
            requestParams = this.extractParamsOrThrow(context);
            this.logger.debug("{} received request={}, remoteAddress={}, instance={}", new Object[]{this.getClass().getSimpleName(), requestParams, remoteAddress, host});
            this.handleInternal(context, request, host, remoteAddress, requestParams);
        }
        catch (Exception exception) {
            this.processFailure(exception, context, host, remoteAddress, requestParams);
        }
    }

    protected abstract T extractParamsOrThrow(RoutingContext var1);

    protected abstract void handleInternal(RoutingContext var1, HttpServerRequest var2, @NotNull String var3, SocketAddress var4, T var5);

    @NotNull
    public String host(RoutingContext context) {
        if (context.request().params().contains(INSTANCE_ID)) {
            String instanceIdParam = context.request().getParam(INSTANCE_ID);
            if (instanceIdParam == null) {
                throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "InstanceId query parameter must be provided");
            }
            try {
                int instanceId = Integer.parseInt(instanceIdParam);
                return this.metadataFetcher.instance(instanceId).host();
            }
            catch (NumberFormatException ex) {
                throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "InstanceId query parameter must be a valid integer");
            }
            catch (IllegalStateException | NoSuchCassandraInstanceException ex) {
                throw new HttpException(HttpResponseStatus.NOT_FOUND.code(), ex.getMessage());
            }
        }
        try {
            return AbstractHandler.extractHostAddressWithoutPort(context.request());
        }
        catch (IllegalArgumentException ex) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), ex.getMessage());
        }
    }

    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, T request) {
        HttpException httpException = this.determineHttpException(cause);
        if (HttpStatusClass.CLIENT_ERROR.contains(httpException.getStatusCode())) {
            this.logger.warn("{} request failed due to client error. request={}, remoteAddress={}, instance={}", new Object[]{this.getClass().getSimpleName(), request, remoteAddress, host, cause});
        } else if (HttpStatusClass.SERVER_ERROR.contains(httpException.getStatusCode())) {
            this.logger.error("{} request failed due to server error. request={}, remoteAddress={}, instance={}", new Object[]{this.getClass().getSimpleName(), request, remoteAddress, host, cause});
        }
        context.fail((Throwable)httpException);
    }

    protected HttpException determineHttpException(Throwable cause) {
        if (cause instanceof HttpException) {
            return (HttpException)cause;
        }
        if (cause instanceof JmxAuthenticationException) {
            return HttpExceptions.wrapHttpException(HttpResponseStatus.SERVICE_UNAVAILABLE, cause);
        }
        if (cause instanceof OperationUnavailableException) {
            return HttpExceptions.wrapHttpException(HttpResponseStatus.SERVICE_UNAVAILABLE, cause.getMessage(), cause);
        }
        if (cause instanceof NoSuchCassandraInstanceException) {
            return HttpExceptions.wrapHttpException(HttpResponseStatus.MISDIRECTED_REQUEST, cause.getMessage(), cause);
        }
        if (cause instanceof IllegalArgumentException) {
            return HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, cause.getMessage(), cause);
        }
        if (cause instanceof IllegalStateException) {
            return HttpExceptions.wrapHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, cause.getMessage(), cause);
        }
        return HttpExceptions.wrapHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, cause);
    }

    protected QualifiedTableName qualifiedTableName(RoutingContext context) {
        return this.qualifiedTableName(context, true);
    }

    protected QualifiedTableName qualifiedTableName(RoutingContext context, boolean required) {
        return new QualifiedTableName(this.keyspace(context, required), this.tableName(context, required));
    }

    protected Name keyspace(RoutingContext context, boolean required) {
        String keyspace = context.pathParam(KEYSPACE_PATH_PARAM);
        if (required || keyspace != null) {
            return this.validator.validateKeyspaceName(keyspace);
        }
        return null;
    }

    private Name tableName(RoutingContext context, boolean required) {
        String tableName = context.pathParam(TABLE_PATH_PARAM);
        if (required || tableName != null) {
            return this.validator.validateTableName(tableName);
        }
        return null;
    }

    @NotNull
    public static String extractHostAddressWithoutPort(HttpServerRequest request) throws IllegalArgumentException {
        String host = request.host();
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (String)"Missing 'host' header in the request");
        if (host.contains(":")) {
            if (host.split(":").length > 2 && !host.startsWith("[")) {
                return host;
            }
            String hostWithoutPort = host.substring(0, host.lastIndexOf(58));
            return hostWithoutPort.startsWith("[") ? hostWithoutPort.substring(1, hostWithoutPort.length() - 1) : hostWithoutPort;
        }
        return host;
    }
}

