/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import org.apache.cassandra.sidecar.common.data.ConsistencyVerificationResult;
import org.apache.cassandra.sidecar.common.data.RestoreJobProgressFetchPolicy;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreRange;
import org.apache.cassandra.sidecar.restore.RestoreJobProgress;
import org.apache.cassandra.sidecar.restore.RestoreJobProgressCollector;

public class RestoreJobProgressCollectors {
    private RestoreJobProgressCollectors() {
        throw new UnsupportedOperationException("Initialization is not allowed");
    }

    public static RestoreJobProgressCollector create(RestoreJob restoreJob, RestoreJobProgressFetchPolicy fetchPolicy) {
        switch (fetchPolicy) {
            case ALL: {
                return new CollectAll(restoreJob);
            }
            case FIRST_FAILED: {
                return new CollectFirstFailed(restoreJob);
            }
            case ALL_FAILED_AND_PENDING: {
                return new CollectAllFailedAndPending(restoreJob);
            }
        }
        throw new IllegalStateException("Encountered unknown fetch policy: " + fetchPolicy);
    }

    private static class CollectAllFailedAndPending
    extends BaseCollector {
        protected CollectAllFailedAndPending(RestoreJob restoreJob) {
            super(restoreJob);
        }

        @Override
        public boolean canCollectMore() {
            return true;
        }

        @Override
        protected boolean shouldSkip(ConsistencyVerificationResult checkResult) {
            return checkResult == ConsistencyVerificationResult.SATISFIED;
        }
    }

    private static class CollectFirstFailed
    extends BaseCollector {
        CollectFirstFailed(RestoreJob restoreJob) {
            super(restoreJob);
        }

        @Override
        public boolean canCollectMore() {
            return !this.seenFailed;
        }

        @Override
        protected boolean shouldSkip(ConsistencyVerificationResult checkResult) {
            return checkResult == ConsistencyVerificationResult.SATISFIED || checkResult == ConsistencyVerificationResult.PENDING;
        }
    }

    private static class CollectAll
    extends BaseCollector {
        CollectAll(RestoreJob restoreJob) {
            super(restoreJob);
        }

        @Override
        public boolean canCollectMore() {
            return true;
        }
    }

    private static abstract class BaseCollector
    implements RestoreJobProgressCollector {
        private final RestoreJobProgress.Builder progressBuilder;
        protected boolean seenFailed = false;
        protected boolean seenPending = false;

        protected BaseCollector(RestoreJob restoreJob) {
            this.progressBuilder = new RestoreJobProgress.Builder(restoreJob);
        }

        protected boolean shouldSkip(ConsistencyVerificationResult checkResult) {
            return false;
        }

        @Override
        public void collect(RestoreRange range, ConsistencyVerificationResult checkResult) {
            if (checkResult == ConsistencyVerificationResult.FAILED) {
                this.seenFailed = true;
            } else if (checkResult == ConsistencyVerificationResult.PENDING) {
                this.seenPending = true;
            }
            if (this.shouldSkip(checkResult)) {
                return;
            }
            switch (checkResult) {
                case FAILED: {
                    this.progressBuilder.addFailedRange(range);
                    break;
                }
                case PENDING: {
                    this.progressBuilder.addPendingRange(range);
                    break;
                }
                case SATISFIED: {
                    this.progressBuilder.addSucceededRange(range);
                }
            }
        }

        @Override
        public RestoreJobProgress toRestoreJobProgress() {
            ConsistencyVerificationResult overallStatus = this.determineOverallStatus();
            return this.progressBuilder.withOverallStatus(overallStatus).build();
        }

        private ConsistencyVerificationResult determineOverallStatus() {
            if (this.seenFailed) {
                return ConsistencyVerificationResult.FAILED;
            }
            if (this.seenPending) {
                return ConsistencyVerificationResult.PENDING;
            }
            return ConsistencyVerificationResult.SATISFIED;
        }
    }
}

