/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.cluster.locator;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Token
implements Comparable<Token> {
    private static final Comparator<Token> TOKEN_COMPARATOR = Comparator.comparing(Token::toBigInteger);
    private final BigInteger value;

    public static Token from(BigInteger value) {
        return new Token(value);
    }

    public static Token from(String valueStr) {
        return new Token(new BigInteger(valueStr));
    }

    public static Token from(long value) {
        return new Token(BigInteger.valueOf(value));
    }

    private Token(BigInteger value) {
        this.value = value;
    }

    public BigInteger toBigInteger() {
        return this.value;
    }

    public Token increment() {
        return new Token(this.value.add(BigInteger.ONE));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.value, token.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(@NotNull Token other) {
        return Objects.compare(this, Objects.requireNonNull(other), TOKEN_COMPARATOR);
    }

    public String toString() {
        return "Token(" + this.value + ")";
    }
}

