/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.parser;

import org.apache.cayenne.template.parser.Node;
import org.apache.cayenne.template.parser.SQLTemplateParserTreeConstants;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;

    public SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return SQLTemplateParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (Node aChildren : this.children) {
                SimpleNode n = (SimpleNode)aChildren;
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }
}

