/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;

public class IndexExtractorFromSparseBloomFilterTest
extends AbstractIndexExtractorTest {
    protected Shape shape = Shape.fromKM((int)17, (int)72);

    @Override
    protected IndexExtractor createEmptyExtractor() {
        return new SparseBloomFilter(this.shape);
    }

    @Override
    protected IndexExtractor createExtractor() {
        IncrementingHasher hasher = new IncrementingHasher(4L, 7L);
        SparseBloomFilter bf = new SparseBloomFilter(this.shape);
        bf.merge((Hasher)hasher);
        return bf;
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 3;
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{2, 4, 9, 11, 16, 18, 23, 25, 30, 32, 37, 39, 44, 46, 53, 60, 67};
    }
}

