/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.CollatingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CollatingIteratorTest
extends AbstractIteratorTest<Integer> {
    private Comparator<Integer> comparator;
    private ArrayList<Integer> evens;
    private ArrayList<Integer> odds;
    private ArrayList<Integer> fib;

    @Override
    public CollatingIterator<Integer> makeEmptyIterator() {
        return new CollatingIterator(this.comparator);
    }

    @Override
    public CollatingIterator<Integer> makeObject() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.odds.iterator());
        iter.addIterator(this.fib.iterator());
        return iter;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.comparator = new ComparableComparator();
        this.evens = new ArrayList();
        this.odds = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            if (0 == i % 2) {
                this.evens.add(i);
                continue;
            }
            this.odds.add(i);
        }
        this.fib = new ArrayList();
        this.fib.add(1);
        this.fib.add(1);
        this.fib.add(2);
        this.fib.add(3);
        this.fib.add(5);
        this.fib.add(8);
        this.fib.add(13);
        this.fib.add(21);
    }

    @Test
    public void testGetSetComparator() {
        CollatingIterator iter = new CollatingIterator();
        Assertions.assertNull((Object)iter.getComparator());
        iter.setComparator(this.comparator);
        Assertions.assertSame(this.comparator, (Object)iter.getComparator());
        iter.setComparator(null);
        Assertions.assertNull((Object)iter.getComparator());
    }

    @Test
    public void testIterateEven() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        for (Integer even : this.evens) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)even, (Integer)((Integer)iter.next()));
            Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateEvenEven() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.evens.iterator());
        for (Integer even : this.evens) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)even, (Integer)((Integer)iter.next()));
            Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)even, (Integer)((Integer)iter.next()));
            Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateEvenOdd() {
        CollatingIterator iter = new CollatingIterator(this.comparator, this.evens.iterator(), this.odds.iterator());
        for (int i = 0; i < 20; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)i, (Integer)((Integer)iter.next()));
            Assertions.assertEquals((int)(i % 2), (int)iter.getIteratorIndex());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateFibEvenOdd() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.fib.iterator());
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.odds.iterator());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)2, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)2, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)3, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)3, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)4, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)5, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)5, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)6, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)7, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)8, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)8, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)9, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)10, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)11, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)12, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)13, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)13, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)14, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)15, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)16, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)17, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)18, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)1, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)19, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)2, (int)iter.getIteratorIndex());
        Assertions.assertEquals((Integer)21, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((int)0, (int)iter.getIteratorIndex());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateOddEven() {
        CollatingIterator iter = new CollatingIterator(this.comparator, this.odds.iterator(), this.evens.iterator());
        for (int i = 0; i < 20; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)i, (Integer)((Integer)iter.next()));
            Assertions.assertEquals((int)(i % 2 == 0 ? 1 : 0), (int)iter.getIteratorIndex());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testNullComparator() {
        List<Integer> l1 = Arrays.asList(1, 3, 5);
        List<Integer> l2 = Arrays.asList(2, 4, 6);
        CollatingIterator collatingIterator1 = new CollatingIterator(null, l1.iterator(), l2.iterator());
        Assertions.assertThrows(NullPointerException.class, () -> ((CollatingIterator)collatingIterator1).next(), (String)"You must invoke setComparator");
        int i = 0;
        CollatingIterator collatingIterator2 = new CollatingIterator(null, l1.iterator(), l2.iterator());
        collatingIterator2.setComparator((Comparator)new ComparableComparator());
        while (collatingIterator2.hasNext()) {
            Integer n = (Integer)collatingIterator2.next();
            Assertions.assertEquals((int)n, (int)(i + 1), (String)"wrong order");
            ++i;
        }
        Assertions.assertEquals((int)i, (int)(l1.size() + l2.size()), (String)"wrong size");
    }

    @Test
    public void testRemoveFromDouble() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.odds.iterator());
        int expectedSize = this.evens.size() + this.odds.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0 && val % 3 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        Assertions.assertEquals((int)expectedSize, (int)(this.evens.size() + this.odds.size()));
    }

    @Test
    public void testRemoveFromSingle() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        int expectedSize = this.evens.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        Assertions.assertEquals((int)expectedSize, (int)this.evens.size());
    }
}

