/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMapTest<M extends Map<K, V>, K, V>
extends AbstractObjectTest {
    protected M map;
    protected Set<Map.Entry<K, V>> entrySet;
    protected Set<K> keySet;
    protected Collection<V> values;
    protected Map<K, V> confirmed;

    public static <K, V> Map.Entry<K, V> cloneMapEntry(Map.Entry<K, V> entry) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(entry.getKey(), entry.getValue());
        return map.entrySet().iterator().next();
    }

    public void addSampleMappings(Map<? super K, ? super V> m) {
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (int i = 0; i < keys.length; ++i) {
            try {
                m.put(keys[i], values[i]);
                continue;
            }
            catch (NullPointerException exception) {
                Assertions.assertTrue((keys[i] == null || values[i] == null ? 1 : 0) != 0, (String)"NullPointerException only allowed to be thrown if either the key or value is null.");
                Assertions.assertTrue((keys[i] == null || !this.isAllowNullKey() ? 1 : 0) != 0, (String)"NullPointerException on null key, but isAllowNullKey is not overridden to return false.");
                Assertions.assertTrue((values[i] == null || !this.isAllowNullValue() ? 1 : 0) != 0, (String)"NullPointerException on null value, but isAllowNullValue is not overridden to return false.");
                Assertions.fail((String)"Unknown reason for NullPointer.");
            }
        }
        Assertions.assertEquals((int)keys.length, (int)m.size(), (String)"size must reflect number of mappings added.");
    }

    public boolean areEqualElementsDistinguishable() {
        return false;
    }

    public BulkTest bulkTestMapEntrySet() {
        return new TestMapEntrySet();
    }

    public BulkTest bulkTestMapKeySet() {
        return new TestMapKeySet();
    }

    public BulkTest bulkTestMapValues() {
        return new TestMapValues();
    }

    protected V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.getMap().computeIfAbsent(key, mappingFunction);
    }

    protected <E> List<E> getAsList(Object[] o) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : o) {
            result.add(element);
        }
        return result;
    }

    @Override
    public String getCompatibilityVersion() {
        return super.getCompatibilityVersion();
    }

    public Map<K, V> getConfirmed() {
        return this.confirmed;
    }

    protected int getIterationBehaviour() {
        return 0;
    }

    public M getMap() {
        return this.map;
    }

    public V[] getNewSampleValues() {
        Object[] result = new Object[]{this.isAllowNullValue() && this.isAllowDuplicateValues() ? null : "newnonnullvalue", "newvalue", this.isAllowDuplicateValues() ? "newvalue" : "newvalue2", "newblahv", "newfoov", "newbarv", "newbazv", "newtmpv", "newgoshv", "newgollyv", "newgeev", "newhellov", "newgoodbyev", "newwe'llv", "newseev", "newyouv", "newallv", "newagainv"};
        return result;
    }

    public K[] getOtherKeys() {
        return this.getOtherNonNullStringElements();
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public V[] getOtherValues() {
        return this.getOtherNonNullStringElements();
    }

    public K[] getSampleKeys() {
        Object[] result = new Object[]{"blah", "foo", "bar", "baz", "tmp", "gosh", "golly", "gee", "hello", "goodbye", "we'll", "see", "you", "all", "again", "key", "key2", this.isAllowNullKey() ? null : "nonnullkey"};
        return result;
    }

    public V[] getSampleValues() {
        Object[] result = new Object[]{"blahv", "foov", "barv", "bazv", "tmpv", "goshv", "gollyv", "geev", "hellov", "goodbyev", "we'llv", "seev", "youv", "allv", "againv", this.isAllowNullValue() ? null : "nonnullvalue", "value", this.isAllowDuplicateValues() ? "value" : "value2"};
        return result;
    }

    public boolean isAllowDuplicateValues() {
        return true;
    }

    public boolean isAllowNullKey() {
        return true;
    }

    public boolean isAllowNullValue() {
        return this.isAllowNullValueGet() && this.isAllowNullValuePut();
    }

    public boolean isAllowNullValueGet() {
        return true;
    }

    public boolean isAllowNullValuePut() {
        return true;
    }

    public boolean isFailFastExpected() {
        return true;
    }

    public boolean isGetStructuralModify() {
        return false;
    }

    protected boolean isLazyMapTest() {
        return false;
    }

    public boolean isPutAddSupported() {
        return true;
    }

    public boolean isPutChangeSupported() {
        return true;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isReplaceAllSupported() {
        return true;
    }

    public boolean isSetValueSupported() {
        return this.isPutChangeSupported();
    }

    public boolean isSubMapViewsSerializable() {
        return true;
    }

    public Map<K, V> makeConfirmedMap() {
        return new HashMap();
    }

    private Map.Entry<K, V>[] makeEntryArray(K[] keys, V[] values) {
        Map.Entry[] result = new Map.Entry[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Map<K, V> map = this.makeConfirmedMap();
            map.put(keys[i], values[i]);
            result[i] = map.entrySet().iterator().next();
        }
        return result;
    }

    public M makeFullMap() {
        Object m = this.makeObject();
        this.addSampleMappings((Map<? super K, ? super V>)m);
        return (M)m;
    }

    public abstract M makeObject();

    protected V putIfAbsent(K key, V value) {
        return this.getMap().putIfAbsent(key, value);
    }

    public void resetEmpty() {
        this.map = this.makeObject();
        this.views();
        this.confirmed = this.makeConfirmedMap();
    }

    public void resetFull() {
        this.map = this.makeFullMap();
        this.views();
        this.confirmed = this.makeConfirmedMap();
        K[] k = this.getSampleKeys();
        V[] v = this.getSampleValues();
        for (int i = 0; i < k.length; ++i) {
            this.confirmed.put(k[i], v[i]);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.map = null;
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.confirmed = null;
    }

    @Test
    public void testEmptyMapCompatibility() throws Exception {
        Object map = this.makeObject();
        if (map instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
            Assertions.assertEquals((int)0, (int)map2.size(), (String)"Map is empty");
        }
    }

    @Test
    public void testEntrySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set entrySet = this.getMap().entrySet();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        Assertions.assertFalse((boolean)entrySet.isEmpty());
        entrySet.clear();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        Assertions.assertTrue((boolean)entrySet.isEmpty());
        this.resetFull();
        entrySet = this.getMap().entrySet();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        Assertions.assertFalse((boolean)entrySet.isEmpty());
        this.getMap().clear();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        Assertions.assertTrue((boolean)entrySet.isEmpty());
    }

    @Test
    public void testEntrySetContains1() {
        this.resetFull();
        Set entrySet = this.getMap().entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Assertions.assertTrue((boolean)entrySet.contains(entry));
    }

    @Test
    public void testEntrySetContains2() {
        this.resetFull();
        Set entrySet = this.getMap().entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Map.Entry test = AbstractMapTest.cloneMapEntry(entry);
        Assertions.assertTrue((boolean)entrySet.contains(test));
    }

    @Test
    public void testEntrySetContains3() {
        this.resetFull();
        Set entrySet = this.getMap().entrySet();
        Map.Entry entry = entrySet.iterator().next();
        HashMap temp = new HashMap();
        temp.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry test = temp.entrySet().iterator().next();
        Assertions.assertFalse((boolean)entrySet.contains(test));
    }

    @Test
    public void testEntrySetIteratorRemoveChangesMap() {
        this.resetFull();
        Iterator iter = this.getMap().entrySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next().getKey();
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            Assertions.assertFalse((boolean)this.getMap().containsKey(key));
        }
    }

    @Test
    public void testEntrySetRemove1() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getMap().size();
        Set entrySet = this.getMap().entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Object key = entry.getKey();
        Assertions.assertTrue((boolean)entrySet.remove(entry));
        Assertions.assertFalse((boolean)this.getMap().containsKey(key));
        Assertions.assertEquals((int)(size - 1), (int)this.getMap().size());
    }

    @Test
    public void testEntrySetRemove2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getMap().size();
        Set entrySet = this.getMap().entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Object key = entry.getKey();
        Map.Entry test = AbstractMapTest.cloneMapEntry(entry);
        Assertions.assertTrue((boolean)entrySet.remove(test));
        Assertions.assertFalse((boolean)this.getMap().containsKey(key));
        Assertions.assertEquals((int)(size - 1), (int)this.getMap().size());
    }

    @Test
    public void testEntrySetRemove3() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getMap().size();
        Set entrySet = this.getMap().entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Object key = entry.getKey();
        HashMap temp = new HashMap();
        temp.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry test = temp.entrySet().iterator().next();
        Assertions.assertFalse((boolean)entrySet.remove(test));
        Assertions.assertTrue((boolean)this.getMap().containsKey(key));
        Assertions.assertEquals((int)size, (int)this.getMap().size());
    }

    @Test
    public void testEntrySetRemoveAll() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        for (int i = 0; i < sampleKeys.length; ++i) {
            if (!this.getMap().containsKey(sampleKeys[i])) {
                return;
            }
            V value = sampleValues[i];
            Object test = this.getMap().get(sampleKeys[i]);
            if (value == test || value != null && value.equals(test)) continue;
            return;
        }
        Set entrySet = this.getMap().entrySet();
        HashSet comparisonSet = new HashSet(entrySet);
        try {
            Assertions.assertFalse((boolean)entrySet.removeAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)sampleKeys.length, (int)this.getMap().size());
        try {
            Assertions.assertTrue((boolean)entrySet.removeAll(comparisonSet));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testEntrySetRemoveChangesMap() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        Set entrySet = this.getMap().entrySet();
        for (int i = 0; i < sampleKeys.length; ++i) {
            try {
                entrySet.remove(new DefaultMapEntry(sampleKeys[i], sampleValues[i]));
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            Assertions.assertFalse((boolean)this.getMap().containsKey(sampleKeys[i]), (String)"Entry should have been removed from the underlying map.");
        }
    }

    @Test
    public void testEntrySetRetainAll() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        for (int i = 0; i < sampleKeys.length; ++i) {
            if (!this.getMap().containsKey(sampleKeys[i])) {
                return;
            }
            V value = sampleValues[i];
            Object test = this.getMap().get(sampleKeys[i]);
            if (value == test || value != null && value.equals(test)) continue;
            return;
        }
        Set entrySet = this.getMap().entrySet();
        HashSet comparisonSet = new HashSet(entrySet);
        try {
            Assertions.assertFalse((boolean)entrySet.retainAll(comparisonSet));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)sampleKeys.length, (int)this.getMap().size());
        try {
            Assertions.assertTrue((boolean)entrySet.retainAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testForEach() {
        this.resetFull();
        AtomicInteger i = new AtomicInteger();
        this.getMap().forEach((k, v) -> {
            Assertions.assertTrue((boolean)this.getMap().containsKey(k));
            Assertions.assertTrue((boolean)this.getMap().containsValue(v));
            i.incrementAndGet();
        });
        Assertions.assertEquals((int)i.get(), (int)this.getMap().size());
    }

    @Test
    public void testFullMapCompatibility() throws Exception {
        M map = this.makeFullMap();
        if (map instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
            Assertions.assertEquals((int)this.getSampleKeys().length, (int)map2.size(), (String)"Map is the right size");
        }
    }

    @Test
    public void testKeySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set keySet = this.getMap().keySet();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        Assertions.assertFalse((boolean)keySet.isEmpty());
        keySet.clear();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        Assertions.assertTrue((boolean)keySet.isEmpty());
        this.resetFull();
        keySet = this.getMap().keySet();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        Assertions.assertFalse((boolean)keySet.isEmpty());
        this.getMap().clear();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        Assertions.assertTrue((boolean)keySet.isEmpty());
    }

    @Test
    public void testKeySetIteratorRemoveChangesMap() {
        this.resetFull();
        Iterator iter = this.getMap().keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            Assertions.assertFalse((boolean)this.getMap().containsKey(key));
        }
    }

    @Test
    public void testKeySetRemoveAll() {
        this.resetFull();
        Set keys = this.getMap().keySet();
        List<K> sampleKeysAsList = Arrays.asList(this.getSampleKeys());
        if (!keys.equals(sampleKeysAsList)) {
            return;
        }
        try {
            Assertions.assertFalse((boolean)keys.removeAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals(sampleKeysAsList, keys);
        try {
            Assertions.assertTrue((boolean)keys.removeAll(sampleKeysAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testKeySetRemoveChangesMap() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        Set keys = this.getMap().keySet();
        for (K sampleKey : sampleKeys) {
            try {
                keys.remove(sampleKey);
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            Assertions.assertFalse((boolean)this.getMap().containsKey(sampleKey), (String)"Key should have been removed from the underlying map.");
        }
    }

    @Test
    public void testKeySetRetainAll() {
        this.resetFull();
        Set keys = this.getMap().keySet();
        List<K> sampleKeysAsList = Arrays.asList(this.getSampleKeys());
        if (!keys.equals(sampleKeysAsList)) {
            return;
        }
        try {
            Assertions.assertFalse((boolean)keys.retainAll(sampleKeysAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals(sampleKeysAsList, keys);
        try {
            Assertions.assertTrue((boolean)keys.retainAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testMakeMap() {
        Object em = this.makeObject();
        Assertions.assertNotNull((Object)em, (String)"failure in test: makeEmptyMap must return a non-null map.");
        Object em2 = this.makeObject();
        Assertions.assertNotNull((Object)em, (String)"failure in test: makeEmptyMap must return a non-null map.");
        Assertions.assertNotSame((Object)em, (Object)em2, (String)"failure in test: makeEmptyMap must return a new map with each invocation.");
        M fm = this.makeFullMap();
        Assertions.assertNotNull(fm, (String)"failure in test: makeFullMap must return a non-null map.");
        M fm2 = this.makeFullMap();
        Assertions.assertNotNull(fm2, (String)"failure in test: makeFullMap must return a non-null map.");
        Assertions.assertNotSame(fm, fm2, (String)"failure in test: makeFullMap must return a new map with each invocation.");
    }

    @Test
    public void testMapClear() {
        if (!this.isRemoveSupported()) {
            this.resetFull();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getMap().clear(), (String)"Expected UnsupportedOperationException on clear");
            return;
        }
        this.resetEmpty();
        this.getMap().clear();
        this.getConfirmed().clear();
        this.verify();
        this.resetFull();
        this.getMap().clear();
        this.getConfirmed().clear();
        this.verify();
    }

    @Test
    public void testMapComputeIfAbsent() {
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        Object[] newValues = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            Object value;
            Object key;
            int i;
            AtomicInteger inc = new AtomicInteger();
            while (inc.get() < keys.length) {
                i = inc.get();
                key = keys[i];
                value = values[i];
                boolean expectKey = key != null && value != null || key == null && !this.getMap().containsKey(key);
                HashMap oldMap = new HashMap(this.getMap());
                Object currValue = this.computeIfAbsent(key, k -> value);
                this.getConfirmed().computeIfAbsent(key, k -> value);
                if (!this.isLazyMapTest()) {
                    this.verify();
                }
                Supplier<String> messageSupplier = () -> String.format("[%,d] map.computeIfAbsent key '%s', value '%s', old %s", inc.get(), key, value, oldMap);
                Assertions.assertEquals((Object)value, (Object)currValue, messageSupplier);
                if (this.isLazyMapTest()) {
                    Assertions.assertTrue((boolean)this.getMap().containsKey(key), messageSupplier);
                    Assertions.assertTrue((boolean)this.getMap().containsValue(value), messageSupplier);
                } else {
                    Assertions.assertEquals((Object)expectKey, (Object)this.getMap().containsKey(key), messageSupplier);
                    Assertions.assertEquals((Object)expectKey, (Object)this.getMap().containsValue(value), messageSupplier);
                }
                inc.incrementAndGet();
            }
            if (this.isPutChangeSupported()) {
                inc = new AtomicInteger();
                while (inc.get() < keys.length) {
                    i = inc.get();
                    key = keys[i];
                    value = newValues[i];
                    boolean valueAlreadyPresent = this.getMap().containsValue(value);
                    Object prevValue = this.getMap().get(key);
                    HashMap oldMap = new HashMap(this.getMap());
                    Object computedValue = this.computeIfAbsent(key, k -> value);
                    this.getConfirmed().computeIfAbsent(key, k -> value);
                    if (!this.isLazyMapTest()) {
                        this.verify();
                    }
                    Object arrValue = values[i];
                    Supplier<String> messageSupplier = () -> String.format("[%,d] map.computeIfAbsent key '%s', value '%s', old %s", inc.get(), key, value, oldMap);
                    if (valueAlreadyPresent || key == null) {
                        Assertions.assertNotEquals((Object)value, (Object)computedValue, messageSupplier);
                    } else if (prevValue != null && value != null) {
                        Assertions.assertEquals(prevValue, (Object)computedValue, messageSupplier);
                    } else if (prevValue == null) {
                        Assertions.assertEquals((Object)value, (Object)computedValue, messageSupplier);
                    } else if (value == null) {
                        Assertions.assertEquals(prevValue, (Object)computedValue, messageSupplier);
                    }
                    if (prevValue == null) {
                        Assertions.assertEquals((Object)value, this.getMap().get(key), messageSupplier);
                    } else {
                        Assertions.assertEquals((Object)computedValue, this.getMap().get(key), messageSupplier);
                    }
                    Assertions.assertTrue((boolean)this.getMap().containsKey(key), messageSupplier);
                    if (valueAlreadyPresent && value != null) {
                        Assertions.assertFalse((boolean)this.getMap().containsValue(value), messageSupplier);
                    }
                    if (!this.isAllowDuplicateValues() && valueAlreadyPresent && value != null) {
                        Assertions.assertFalse((boolean)this.getMap().containsValue(arrValue), (String)String.format("Map should not contain old value after computeIfAbsent when changed: [%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, value));
                    }
                    inc.incrementAndGet();
                }
            } else {
                try {
                    this.computeIfAbsent(keys[0], k -> newValues[0]);
                    Assertions.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on putIfAbsent (change)");
                }
                catch (IllegalArgumentException | UnsupportedOperationException inc2) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            try {
                this.computeIfAbsent(keys[0], k -> values[0]);
                Assertions.fail((String)"Expected UnsupportedOperationException or IllegalArgumentException on putIfAbsent (add) when fixed size");
            }
            catch (IllegalArgumentException | UnsupportedOperationException inc2) {
                // empty catch block
            }
            this.resetFull();
            Iterator it = this.getMap().keySet().iterator();
            for (int i = 0; it.hasNext() && i < newValues.length; ++i) {
                Object key = it.next();
                Object newValue = newValues[i];
                boolean newValueAlready = this.getMap().containsValue(newValue);
                Object prevValue = this.getMap().get(key);
                Object oldValue = this.getMap().putIfAbsent(key, (Object)newValue);
                Object value = this.getConfirmed().putIfAbsent(key, newValue);
                this.verify();
                Assertions.assertEquals((Object)value, (Object)oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                Assertions.assertEquals(prevValue, (Object)oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                if (prevValue == null) {
                    Assertions.assertEquals((Object)newValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                } else {
                    Assertions.assertEquals((Object)oldValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                }
                Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)"Map should still contain key after putIfAbsent when changed");
                if (newValueAlready && newValue != null) {
                    Assertions.assertFalse((boolean)this.getMap().containsValue(newValue), (String)String.format("[%,d] Map at '%s' shouldn't contain new value '%s' after putIfAbsent when changed", i, key, newValue));
                }
                if (this.isAllowDuplicateValues()) continue;
                Assertions.assertFalse((boolean)this.getMap().containsValue(values[i]), (String)"Map should not contain old value after putIfAbsent when changed");
            }
        } else {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getMap().putIfAbsent((Object)keys[0], (Object)values[0]), (String)"Expected UnsupportedOperationException on put (add)");
        }
    }

    @Test
    public void testMapComputeIfPresent() {
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        Object[] newValues = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            Object value;
            Object key;
            int i;
            AtomicInteger inc = new AtomicInteger();
            while (inc.get() < keys.length) {
                i = inc.get();
                key = keys[i];
                value = values[i];
                boolean expectKey = this.getMap().containsKey(key);
                HashMap oldMap = new HashMap(this.getMap());
                Object computedValue = this.getMap().computeIfPresent(key, (k, v) -> value);
                this.getConfirmed().computeIfPresent(key, (k, v) -> value);
                if (!this.isLazyMapTest()) {
                    this.verify();
                }
                Supplier<String> messageSupplier = () -> String.format("[%,d] map.computeIfPresent key '%s', value '%s', old %s", inc.get(), key, value, oldMap);
                Assertions.assertNull((Object)computedValue, messageSupplier);
                if (this.isLazyMapTest()) {
                    Assertions.assertTrue((boolean)this.getMap().containsKey(key), messageSupplier);
                    Assertions.assertEquals((Object)(value == null ? 1 : 0), (Object)this.getMap().containsValue(value), messageSupplier);
                } else {
                    Assertions.assertEquals((Object)expectKey, (Object)this.getMap().containsKey(key), messageSupplier);
                    Assertions.assertEquals((Object)expectKey, (Object)this.getMap().containsValue(value), messageSupplier);
                }
                this.getConfirmed().computeIfPresent(key, (k, v) -> value);
                Assertions.assertNull((Object)computedValue, messageSupplier);
                inc.incrementAndGet();
            }
            if (this.isPutChangeSupported()) {
                inc = new AtomicInteger();
                while (inc.get() < keys.length) {
                    i = inc.get();
                    key = keys[i];
                    value = values[i];
                    Object newValue = newValues[i];
                    boolean valueAlreadyPresent = this.getMap().containsValue(newValue);
                    Object prevValue = this.getMap().get(key);
                    HashMap oldMap = new HashMap(this.getMap());
                    Supplier<String> messageSupplier0 = () -> String.format("[%,d] map.computeIfPresent key '%s', value '%s', old %s", inc.get(), key, value, oldMap);
                    Supplier<String> messageSupplier1 = () -> String.format("[%,d] map.computeIfPresent key '%s', newValue '%s', old %s", inc.get(), key, newValue, oldMap);
                    oldMap.clear();
                    oldMap.putAll(this.getMap());
                    this.getMap().put(key, (Object)value);
                    this.getConfirmed().put(key, value);
                    Object computedValue = this.getMap().computeIfPresent(key, (k, v) -> value);
                    this.getConfirmed().computeIfPresent(key, (k, v) -> value);
                    if (value != null) {
                        Assertions.assertNotNull((Object)computedValue, messageSupplier0);
                    } else {
                        Assertions.assertNull((Object)computedValue, messageSupplier0);
                    }
                    oldMap.clear();
                    oldMap.putAll(this.getMap());
                    boolean keyPresent = this.getMap().containsKey(key);
                    computedValue = this.getMap().computeIfPresent(key, (k, v) -> newValue);
                    this.getConfirmed().computeIfPresent(key, (k, v) -> newValue);
                    if (!this.isLazyMapTest()) {
                        this.verify();
                    }
                    if (keyPresent && value != null) {
                        Assertions.assertEquals((Object)newValue, (Object)computedValue, messageSupplier1);
                    } else {
                        Assertions.assertNull((Object)computedValue, messageSupplier1);
                    }
                    Assertions.assertEquals((Object)(newValue != null ? 1 : 0), (Object)this.getMap().containsKey(key), messageSupplier1);
                    if (!this.isAllowDuplicateValues() && valueAlreadyPresent && newValue != null) {
                        Assertions.assertFalse((boolean)this.getMap().containsValue(value), (String)String.format("Map should not contain old value after computeIfPresent when changed: [%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                    }
                    inc.incrementAndGet();
                }
            } else {
                try {
                    this.getMap().computeIfPresent((Object)keys[0], (k, v) -> newValues[0]);
                    Assertions.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on putIfAbsent (change)");
                }
                catch (IllegalArgumentException | UnsupportedOperationException inc2) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            this.getMap().computeIfPresent(keys[0], (k, v) -> values[0]);
            if (this.isPutAddSupported()) {
                this.resetFull();
                Iterator it = this.getMap().keySet().iterator();
                for (int i = 0; it.hasNext() && i < newValues.length; ++i) {
                    Object key = it.next();
                    Object newValue = newValues[i];
                    boolean newValueAlready = this.getMap().containsValue(newValue);
                    Object prevValue = this.getMap().get(key);
                    Object oldValue = this.getMap().computeIfPresent(key, (k, v) -> newValue);
                    Object value = this.getConfirmed().computeIfPresent(key, (k, v) -> newValue);
                    this.verify();
                    Assertions.assertEquals((Object)value, (Object)oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                    Assertions.assertEquals(prevValue, (Object)oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                    if (prevValue == null) {
                        Assertions.assertEquals((Object)newValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                    } else {
                        Assertions.assertEquals((Object)oldValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                    }
                    Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)"Map should still contain key after putIfAbsent when changed");
                    if (newValueAlready && newValue != null) {
                        Assertions.assertFalse((boolean)this.getMap().containsValue(newValue), (String)String.format("[%,d] Map at '%s' shouldn't contain new value '%s' after putIfAbsent when changed", i, key, newValue));
                    }
                    if (this.isAllowDuplicateValues()) continue;
                    Assertions.assertFalse((boolean)this.getMap().containsValue(values[i]), (String)"Map should not contain old value after putIfAbsent when changed");
                }
            }
        } else if (this.getMap().containsKey(keys[0])) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getMap().computeIfPresent((Object)keys[0], (k, v) -> values[0]), (String)"Expected UnsupportedOperationException on put (add)");
        } else {
            this.getMap().computeIfPresent((Object)keys[0], (k, v) -> values[0]);
        }
    }

    @Test
    public void testMapComputeIfPresentOnEmpty() {
        this.resetEmpty();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        K[] otherKeys = this.getOtherKeys();
        Object[] otherValues = this.getOtherValues();
        K key = otherKeys[0];
        Assertions.assertFalse((boolean)this.getMap().containsKey(key));
        Assertions.assertNull((Object)this.getMap().computeIfPresent(key, (k, v) -> otherValues[0]));
        Assertions.assertEquals((Object)this.isLazyMapTest(), (Object)this.getMap().containsKey(key));
        Assertions.assertEquals((Object)(!this.isLazyMapTest() ? 1 : 0), (Object)this.getMap().isEmpty());
    }

    @Test
    public void testMapContainsKey() {
        K[] keys = this.getSampleKeys();
        this.resetEmpty();
        for (K key : keys) {
            Assertions.assertFalse((boolean)this.getMap().containsKey(key), (String)"Map must not contain key when map is empty");
        }
        this.verify();
        this.resetFull();
        for (K key : keys) {
            Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)("Map must contain key for a mapping in the map. Missing: " + key));
        }
        this.verify();
    }

    @Test
    public void testMapContainsValue() {
        V[] values = this.getSampleValues();
        this.resetEmpty();
        if (this.isAllowNullValueGet()) {
            Assertions.assertFalse((boolean)this.getMap().containsValue(null));
        } else {
            Assertions.assertThrows(NullPointerException.class, () -> this.getMap().containsValue(null));
        }
        for (V value : values) {
            Assertions.assertFalse((boolean)this.getMap().containsValue(value), (String)"Empty map must not contain value");
        }
        this.verify();
        this.resetFull();
        for (V value : values) {
            Assertions.assertTrue((boolean)this.getMap().containsValue(value), (String)"Map must contain value for a mapping in the map.");
        }
        this.verify();
    }

    @Test
    public void testMapEquals() {
        this.resetEmpty();
        Assertions.assertEquals(this.getMap(), this.confirmed, (String)"Empty maps unequal.");
        this.verify();
        this.resetFull();
        Assertions.assertEquals(this.getMap(), this.confirmed, (String)"Full maps unequal.");
        this.verify();
        this.resetFull();
        Iterator<K> iter = this.confirmed.keySet().iterator();
        iter.next();
        iter.remove();
        Assertions.assertFalse((boolean)this.getMap().equals(this.confirmed), (String)"Different maps equal.");
        this.resetFull();
        Assertions.assertFalse((boolean)this.getMap().equals(null), (String)"equals(null) returned true.");
        Assertions.assertFalse((boolean)this.getMap().equals(new Object()), (String)"equals(new Object()) returned true.");
        this.verify();
    }

    @Test
    public void testMapGet() {
        this.resetEmpty();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (K key : keys) {
            Assertions.assertNull(this.getMap().get(key), (String)"Empty map.get() should return null.");
        }
        this.verify();
        this.resetFull();
        for (int i = 0; i < keys.length; ++i) {
            Assertions.assertEquals(values[i], this.getMap().get(keys[i]), (String)"Full map.get() should return value from mapping.");
        }
    }

    @Test
    public void testMapGetOrDefault() {
        int i;
        this.resetEmpty();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (K key : keys) {
            Assertions.assertNull(this.getMap().getOrDefault(key, null));
        }
        K[] otherKeys = this.getOtherKeys();
        V[] otherValues = this.getOtherValues();
        for (i = 0; i < otherKeys.length; ++i) {
            K otherKey = otherKeys[i];
            Assertions.assertNull(this.getMap().getOrDefault(otherKey, null));
            V otherValue = otherValues[i];
            if (this.getMap().containsKey(otherKey)) {
                Assertions.assertEquals(this.getMap().get(otherKey), this.getMap().getOrDefault(otherKey, otherValue));
                continue;
            }
            Assertions.assertEquals(otherValue, this.getMap().getOrDefault(otherKey, otherValue));
        }
        if (!this.isLazyMapTest()) {
            this.verify();
        }
        this.resetFull();
        for (i = 0; i < keys.length; ++i) {
            Assertions.assertEquals(values[i], this.getMap().getOrDefault(keys[i], values[i]));
        }
    }

    @Test
    public void testMapHashCode() {
        this.resetEmpty();
        Assertions.assertEquals((int)this.getMap().hashCode(), (int)this.confirmed.hashCode(), (String)"Empty maps have different hashCodes.");
        this.resetFull();
        Assertions.assertEquals((int)this.getMap().hashCode(), (int)this.confirmed.hashCode(), (String)"Equal maps have different hashCodes.");
    }

    @Test
    public void testMapIsEmpty() {
        this.resetEmpty();
        Assertions.assertTrue((boolean)this.getMap().isEmpty(), (String)"Map.isEmpty() should return true with an empty map");
        this.verify();
        this.resetFull();
        Assertions.assertFalse((boolean)this.getMap().isEmpty(), (String)"Map.isEmpty() should return false with a non-empty map");
        this.verify();
    }

    @Test
    public void testMapPut() {
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            Object o;
            int i;
            for (i = 0; i < keys.length; ++i) {
                o = this.getMap().put((Object)keys[i], (Object)values[i]);
                this.getConfirmed().put(keys[i], values[i]);
                this.verify();
                Assertions.assertNull((Object)o, (String)"First map.put should return null");
                Assertions.assertTrue((boolean)this.getMap().containsKey(keys[i]), (String)"Map should contain key after put");
                Assertions.assertTrue((boolean)this.getMap().containsValue(values[i]), (String)"Map should contain value after put");
            }
            if (this.isPutChangeSupported()) {
                for (i = 0; i < keys.length; ++i) {
                    o = this.getMap().put((Object)keys[i], newValues[i]);
                    this.getConfirmed().put(keys[i], newValues[i]);
                    this.verify();
                    Assertions.assertEquals((Object)values[i], (Object)o, (String)"Map.put should return previous value when changed");
                    Assertions.assertTrue((boolean)this.getMap().containsKey(keys[i]), (String)"Map should still contain key after put when changed");
                    Assertions.assertTrue((boolean)this.getMap().containsValue(newValues[i]), (String)"Map should contain new value after put when changed");
                    if (this.isAllowDuplicateValues()) continue;
                    Assertions.assertFalse((boolean)this.getMap().containsValue(values[i]), (String)"Map should not contain old value after put when changed");
                }
            } else {
                try {
                    this.getMap().put((Object)keys[0], newValues[0]);
                    Assertions.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on put (change)");
                }
                catch (IllegalArgumentException | UnsupportedOperationException i2) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            try {
                this.getMap().put((Object)keys[0], (Object)values[0]);
                Assertions.fail((String)"Expected UnsupportedOperationException or IllegalArgumentException on put (add) when fixed size");
            }
            catch (IllegalArgumentException | UnsupportedOperationException i2) {
                // empty catch block
            }
            this.resetFull();
            Iterator it = this.getMap().keySet().iterator();
            for (int i = 0; it.hasNext() && i < newValues.length; ++i) {
                Object key = it.next();
                V o = this.getMap().put(key, newValues[i]);
                V value = this.getConfirmed().put(key, newValues[i]);
                this.verify();
                Assertions.assertEquals(value, o, (String)"Map.put should return previous value when changed");
                Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)"Map should still contain key after put when changed");
                Assertions.assertTrue((boolean)this.getMap().containsValue(newValues[i]), (String)"Map should contain new value after put when changed");
                if (this.isAllowDuplicateValues()) continue;
                Assertions.assertFalse((boolean)this.getMap().containsValue(values[i]), (String)"Map should not contain old value after put when changed");
            }
        } else {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getMap().put((Object)keys[0], (Object)values[0]), (String)"Expected UnsupportedOperationException on put (add)");
        }
    }

    @Test
    public void testMapPutAll() {
        int i;
        if (!this.isPutAddSupported()) {
            if (!this.isPutChangeSupported()) {
                M temp = this.makeFullMap();
                this.resetEmpty();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getMap().putAll(temp), (String)"Expected UnsupportedOperationException on putAll");
            }
            return;
        }
        this.resetEmpty();
        Assertions.assertEquals((int)0, (int)this.getMap().size());
        this.getMap().putAll(new HashMap());
        Assertions.assertEquals((int)0, (int)this.getMap().size());
        this.resetFull();
        int size = this.getMap().size();
        this.getMap().putAll(new HashMap());
        Assertions.assertEquals((int)size, (int)this.getMap().size());
        this.resetEmpty();
        Object m2 = this.makeFullMap();
        this.getMap().putAll(m2);
        this.getConfirmed().putAll((Map<K, V>)m2);
        this.verify();
        this.resetEmpty();
        m2 = this.makeConfirmedMap();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (i = 0; i < keys.length; ++i) {
            m2.put(keys[i], values[i]);
        }
        this.getMap().putAll(m2);
        this.getConfirmed().putAll((Map<K, V>)m2);
        this.verify();
        this.resetEmpty();
        m2 = this.makeConfirmedMap();
        this.getMap().put(keys[0], values[0]);
        this.getConfirmed().put(keys[0], values[0]);
        this.verify();
        for (i = 1; i < keys.length; ++i) {
            m2.put(keys[i], values[i]);
        }
        this.getMap().putAll(m2);
        this.getConfirmed().putAll((Map<K, V>)m2);
        this.verify();
    }

    @Test
    public void testMapPutIfAbsent() {
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            Object key;
            int i;
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                Object value = values[i];
                Object o = this.putIfAbsent(key, value);
                this.getConfirmed().putIfAbsent(key, value);
                this.verify();
                Assertions.assertNull((Object)o, (String)"First map.putIfAbsent should return null");
                Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)"Map should contain key after putIfAbsent");
                Assertions.assertTrue((boolean)this.getMap().containsValue(value), (String)"Map should contain value after putIfAbsent");
            }
            if (this.isPutChangeSupported()) {
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    V newValue = newValues[i];
                    boolean newValueAlready = this.getMap().containsValue(newValue);
                    Object prevValue = this.getMap().get(key);
                    V oldValue = this.putIfAbsent(key, newValue);
                    this.getConfirmed().putIfAbsent(key, newValue);
                    this.verify();
                    Object arrValue = values[i];
                    Assertions.assertEquals((Object)arrValue, oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                    Assertions.assertEquals(prevValue, oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                    if (prevValue == null) {
                        Assertions.assertEquals(newValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                    } else {
                        Assertions.assertEquals(oldValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                    }
                    Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)"Map should still contain key after putIfAbsent when changed");
                    if (newValueAlready && newValue != null) {
                        Assertions.assertFalse((boolean)this.getMap().containsValue(newValue), (String)String.format("[%,d] Map at '%s' shouldn't contain new value '%s' after putIfAbsent when changed", i, key, newValue));
                    }
                    if (this.isAllowDuplicateValues() || !newValueAlready || newValue == null) continue;
                    Assertions.assertFalse((boolean)this.getMap().containsValue(arrValue), (String)String.format("Map should not contain old value after putIfAbsent when changed: [%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                }
            } else {
                try {
                    this.putIfAbsent(keys[0], newValues[0]);
                    Assertions.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on putIfAbsent (change)");
                }
                catch (IllegalArgumentException | UnsupportedOperationException i2) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            K key0 = keys[0];
            Object value0 = values[0];
            if (this.getMap().containsKey(key0)) {
                Assertions.assertEquals(this.getMap().get(key0), (Object)this.putIfAbsent(key0, value0));
            } else if (this.isPutAddSupported()) {
                this.putIfAbsent(key0, value0);
            } else {
                try {
                    this.putIfAbsent(key0, value0);
                    Assertions.fail((String)"Expected UnsupportedOperationException or IllegalArgumentException on putIfAbsent (add) when fixed size");
                }
                catch (IllegalArgumentException | UnsupportedOperationException newValue) {
                    // empty catch block
                }
            }
            this.resetFull();
            Iterator it = this.getMap().keySet().iterator();
            for (int i = 0; it.hasNext() && i < newValues.length; ++i) {
                Object key = it.next();
                V newValue = newValues[i];
                boolean newValueAlready = this.getMap().containsValue(newValue);
                Object prevValue = this.getMap().get(key);
                V oldValue = this.putIfAbsent(key, newValue);
                V value = this.getConfirmed().putIfAbsent(key, newValue);
                this.verify();
                Assertions.assertEquals(value, oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                Assertions.assertEquals(prevValue, oldValue, (String)"Map.putIfAbsent should return previous value when changed");
                if (prevValue == null) {
                    Assertions.assertEquals(newValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                } else {
                    Assertions.assertEquals(oldValue, this.getMap().get(key), (String)String.format("[%,d] key '%s', prevValue '%s', newValue '%s'", i, key, prevValue, newValue));
                }
                Assertions.assertTrue((boolean)this.getMap().containsKey(key), (String)"Map should still contain key after putIfAbsent when changed");
                if (newValueAlready && newValue != null) {
                    Assertions.assertFalse((boolean)this.getMap().containsValue(newValue), (String)String.format("[%,d] Map at '%s' shouldn't contain new value '%s' after putIfAbsent when changed", i, key, newValue));
                }
                if (this.isAllowDuplicateValues()) continue;
                Assertions.assertFalse((boolean)this.getMap().containsValue(values[i]), (String)"Map should not contain old value after putIfAbsent when changed");
            }
        } else {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.putIfAbsent(keys[0], values[0]), (String)"Expected UnsupportedOperationException on put (add)");
        }
    }

    @Test
    public void testMapPutNullKey() {
        this.resetFull();
        V[] values = this.getSampleValues();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullKey()) {
                this.getMap().put(null, values[0]);
            } else {
                try {
                    this.getMap().put(null, values[0]);
                    Assertions.fail((String)"put(null, value) should throw NPE/IAE");
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testMapPutNullValue() {
        this.resetFull();
        K[] keys = this.getSampleKeys();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullValue()) {
                this.getMap().put(keys[0], null);
            } else {
                try {
                    this.getMap().put(keys[0], null);
                    Assertions.fail((String)"put(key, null) should throw NPE/IAE");
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testMapRemove() {
        if (!this.isRemoveSupported()) {
            this.resetFull();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getMap().remove(this.getMap().keySet().iterator().next()), (String)"Expected UnsupportedOperationException on remove");
            return;
        }
        this.resetEmpty();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (K key : keys) {
            Object o = this.getMap().remove(key);
            Assertions.assertNull(o, (String)"First map.remove should return null");
        }
        this.verify();
        this.resetFull();
        for (int i = 0; i < keys.length; ++i) {
            Object o = this.getMap().remove(keys[i]);
            this.getConfirmed().remove(keys[i]);
            this.verify();
            Assertions.assertEquals(values[i], o, (String)"map.remove with valid key should return value");
        }
        K[] other = this.getOtherKeys();
        this.resetFull();
        int size = this.getMap().size();
        for (K element : other) {
            Object o = this.getMap().remove(element);
            Assertions.assertNull(o, (String)"map.remove for nonexistent key should return null");
            Assertions.assertEquals((int)size, (int)this.getMap().size(), (String)"map.remove for nonexistent key should not shrink map");
        }
        this.verify();
    }

    @Test
    public void testMapSize() {
        this.resetEmpty();
        Assertions.assertEquals((int)0, (int)this.getMap().size(), (String)"Map.size() should be 0 with an empty map");
        this.verify();
        this.resetFull();
        Assertions.assertEquals((int)this.getSampleKeys().length, (int)this.getMap().size(), (String)"Map.size() should equal the number of entries in the map");
        this.verify();
    }

    @Test
    public void testMapToString() {
        this.resetEmpty();
        Assertions.assertNotNull((Object)this.getMap().toString(), (String)"Empty map toString() should not return null");
        this.verify();
        this.resetFull();
        Assertions.assertNotNull((Object)this.getMap().toString(), (String)"Empty map toString() should not return null");
        this.verify();
    }

    @Test
    public void testRemoveKeyValue() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        for (int i = 0; i < sampleKeys.length; ++i) {
            Assertions.assertTrue((boolean)this.getMap().remove(sampleKeys[i], sampleValues[i]));
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testReplaceAll() {
        Assumptions.assumeTrue((this.isSetValueSupported() && this.isReplaceAllSupported() ? 1 : 0) != 0);
        this.resetFull();
        Object[] newValues = this.getNewSampleValues();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        this.getMap().replaceAll((k, v) -> v);
        Assertions.assertEquals(this.makeFullMap(), this.getMap());
        this.getMap().replaceAll((k, v) -> v);
        AtomicInteger i = new AtomicInteger();
        HashMap newMap = new HashMap();
        this.getMap().replaceAll((k, v) -> {
            Object v2 = newValues[i.getAndIncrement()];
            newMap.put(k, v2);
            return v2;
        });
        Assertions.assertEquals(newMap, this.getMap());
    }

    @Test
    public void testReplaceKeyValue() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        AtomicInteger inc = new AtomicInteger();
        while (inc.get() < sampleKeys.length) {
            int i = inc.get();
            V value = sampleValues[i];
            K sampleKey = sampleKeys[i];
            Supplier<String> messageSupplier = () -> String.format("[%,d] key '%s'; %s", inc.get(), sampleKey, this.getMap());
            Assertions.assertEquals(value, this.getMap().replace(sampleKey, value), messageSupplier);
            Assertions.assertEquals(value, this.getMap().replace(sampleKey, value), messageSupplier);
            V newValue = newValues[i];
            Assertions.assertEquals(value, this.getMap().replace(sampleKey, newValue), messageSupplier);
            Object oldValue = this.getMap().get(sampleKey);
            Assertions.assertEquals(oldValue, this.getMap().replace(sampleKey, newValue), messageSupplier);
            oldValue = this.getMap().get(sampleKey);
            Assertions.assertEquals(oldValue, this.getMap().replace(sampleKey, value), messageSupplier);
            if (this.isAllowNullValue()) {
                oldValue = this.getMap().get(sampleKey);
                Assertions.assertEquals(oldValue, this.getMap().replace(sampleKey, null), messageSupplier);
                Assertions.assertNull(this.getMap().get(sampleKey), messageSupplier);
                Assertions.assertNull(this.getMap().replace(sampleKey, null), messageSupplier);
                Assertions.assertNull(this.getMap().replace(sampleKey, value), messageSupplier);
            }
            inc.incrementAndGet();
        }
    }

    @Test
    public void testReplaceKeyValueValue() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        AtomicInteger inc = new AtomicInteger();
        while (inc.get() < sampleKeys.length) {
            int i = inc.get();
            V value = sampleValues[i];
            K key = sampleKeys[i];
            Supplier<String> messageSupplier = () -> String.format("[%,d] key '%s', value '%s'; %s", inc.get(), key, value, this.getMap());
            boolean containsKey = this.getMap().containsKey(key);
            Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, value, value), messageSupplier);
            containsKey = this.getMap().containsKey(key);
            Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, value, value), messageSupplier);
            V newValue = newValues[i];
            containsKey = this.getMap().containsKey(key);
            Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, value, newValue), messageSupplier);
            Object oldValue = this.getMap().get(key);
            containsKey = this.getMap().containsKey(key);
            Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, oldValue, newValue), messageSupplier);
            oldValue = this.getMap().get(key);
            containsKey = this.getMap().containsKey(key);
            Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, oldValue, value), messageSupplier);
            if (this.isAllowNullValue()) {
                oldValue = this.getMap().get(key);
                containsKey = this.getMap().containsKey(key);
                Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, oldValue, null), messageSupplier);
                Assertions.assertNull(this.getMap().get(key), messageSupplier);
                containsKey = this.getMap().containsKey(key);
                Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, null, null), messageSupplier);
                containsKey = this.getMap().containsKey(key);
                Assertions.assertEquals((Object)containsKey, (Object)this.getMap().replace(key, null, value), messageSupplier);
            }
            inc.incrementAndGet();
        }
    }

    @Test
    public void testSampleMappings() {
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        Assertions.assertNotNull(keys, (String)"failure in test: Must have keys returned from getSampleKeys.");
        Assertions.assertNotNull(values, (String)"failure in test: Must have values returned from getSampleValues.");
        Assertions.assertEquals((int)keys.length, (int)values.length, (String)"failure in test: not the same number of sample keys and values.");
        Assertions.assertEquals((int)values.length, (int)newValues.length, (String)"failure in test: not the same number of values and new values.");
        for (int i = 0; i < keys.length - 1; ++i) {
            for (int j = i + 1; j < keys.length; ++j) {
                Assertions.assertTrue((keys[i] != null || keys[j] != null ? 1 : 0) != 0, (String)"failure in test: duplicate null keys.");
                Assertions.assertTrue((keys[i] == null || keys[j] == null || !keys[i].equals(keys[j]) && !keys[j].equals(keys[i]) ? 1 : 0) != 0, (String)"failure in test: duplicate non-null key.");
            }
            Assertions.assertTrue((keys[i] != null || this.isAllowNullKey() ? 1 : 0) != 0, (String)"failure in test: found null key, but isNullKeySupported is false.");
            Assertions.assertTrue((values[i] != null || this.isAllowNullValue() ? 1 : 0) != 0, (String)"failure in test: found null value, but isNullValueSupported is false.");
            Assertions.assertTrue((newValues[i] != null || this.isAllowNullValue() ? 1 : 0) != 0, (String)"failure in test: found null new value, but isNullValueSupported is false.");
            Assertions.assertTrue((values[i] != newValues[i] && (values[i] == null || !values[i].equals(newValues[i])) ? 1 : 0) != 0, (String)"failure in test: values should not be the same as new value");
        }
    }

    @Test
    public void testValuesClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Collection values = this.getMap().values();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        Assertions.assertFalse((boolean)values.isEmpty());
        values.clear();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        Assertions.assertTrue((boolean)values.isEmpty());
        this.resetFull();
        values = this.getMap().values();
        Assertions.assertFalse((boolean)this.getMap().isEmpty());
        Assertions.assertFalse((boolean)values.isEmpty());
        this.getMap().clear();
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
        Assertions.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testValuesIteratorRemoveChangesMap() {
        this.resetFull();
        List<V> sampleValuesAsList = Arrays.asList(this.getSampleValues());
        Map cardinality = CollectionUtils.getCardinalityMap(sampleValuesAsList);
        Collection values = this.getMap().values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            Integer count = (Integer)cardinality.get(value);
            if (count == null) {
                return;
            }
            try {
                iter.remove();
                count = count - 1;
                cardinality.put(value, count);
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            boolean expected = count > 0;
            StringBuilder msg = new StringBuilder("Value should ");
            msg.append(expected ? "yet " : "no longer ");
            msg.append("be present in the underlying map");
            Assertions.assertEquals((Object)expected, (Object)this.getMap().containsValue(value), (String)msg.toString());
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testValuesRemoveAll() {
        this.resetFull();
        Collection values = this.getMap().values();
        List<V> sampleValuesAsList = Arrays.asList(this.getSampleValues());
        if (!values.equals(sampleValuesAsList)) {
            return;
        }
        try {
            Assertions.assertFalse((boolean)values.removeAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)sampleValuesAsList.size(), (int)this.getMap().size());
        try {
            Assertions.assertTrue((boolean)values.removeAll(sampleValuesAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testValuesRemoveChangesMap() {
        this.resetFull();
        V[] sampleValues = this.getSampleValues();
        Collection values = this.getMap().values();
        for (V sampleValue : sampleValues) {
            int j;
            if (!this.map.containsValue(sampleValue)) continue;
            for (j = 0; values.contains(sampleValue) && j < 10000; ++j) {
                try {
                    values.remove(sampleValue);
                    continue;
                }
                catch (UnsupportedOperationException e) {
                    return;
                }
            }
            Assertions.assertTrue((j < 10000 ? 1 : 0) != 0, (String)"values().remove(obj) is broken");
            Assertions.assertFalse((boolean)this.getMap().containsValue(sampleValue), (String)"Value should have been removed from the underlying map.");
        }
    }

    @Test
    public void testValuesRetainAll() {
        this.resetFull();
        Collection values = this.getMap().values();
        List<V> sampleValuesAsList = Arrays.asList(this.getSampleValues());
        if (!values.equals(sampleValuesAsList)) {
            return;
        }
        try {
            Assertions.assertFalse((boolean)values.retainAll(sampleValuesAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)sampleValuesAsList.size(), (int)this.getMap().size());
        try {
            Assertions.assertTrue((boolean)values.retainAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void verify() {
        this.verifyMap();
        this.verifyEntrySet();
        this.verifyKeySet();
        this.verifyValues();
    }

    public void verifyEntrySet() {
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        Assertions.assertEquals((int)size, (int)this.entrySet.size(), (String)("entrySet should be same size as HashMap's\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()));
        Assertions.assertEquals((Object)empty, (Object)this.entrySet.isEmpty(), (String)("entrySet should be empty if HashMap is\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()));
        Assertions.assertTrue((boolean)this.entrySet.containsAll(this.getConfirmed().entrySet()), (String)("entrySet should contain all HashMap's elements\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()));
        Assertions.assertEquals((int)this.getConfirmed().entrySet().hashCode(), (int)this.entrySet.hashCode(), (String)("entrySet hashCodes should be the same\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()));
        Assertions.assertEquals(this.getConfirmed().entrySet(), this.entrySet, (String)"Map's entry set should still equal HashMap's");
    }

    public void verifyKeySet() {
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        Assertions.assertEquals((int)size, (int)this.keySet.size(), (String)("keySet should be same size as HashMap's\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()));
        Assertions.assertEquals((Object)empty, (Object)this.keySet.isEmpty(), (String)("keySet should be empty if HashMap is\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()));
        Assertions.assertTrue((boolean)this.keySet.containsAll(this.getConfirmed().keySet()), (String)("keySet should contain all HashMap's elements\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()));
        Assertions.assertEquals((int)this.getConfirmed().keySet().hashCode(), (int)this.keySet.hashCode(), (String)("keySet hashCodes should be the same\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()));
        Assertions.assertEquals(this.getConfirmed().keySet(), this.keySet, (String)"Map's key set should still equal HashMap's");
    }

    public void verifyMap() {
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        Assertions.assertEquals((int)size, (int)this.getMap().size(), (String)"Map should be same size as HashMap");
        Assertions.assertEquals((Object)empty, (Object)this.getMap().isEmpty(), (String)"Map should be empty if HashMap is");
        Assertions.assertEquals((int)this.getConfirmed().hashCode(), (int)this.getMap().hashCode(), (String)"hashCodes should be the same");
        Assertions.assertEquals(this.map, this.confirmed, (String)"Map should still equal HashMap");
        Assertions.assertEquals(this.getMap(), this.getConfirmed(), (String)"Map should still equal HashMap");
    }

    public void verifyValues() {
        ArrayList<V> known = new ArrayList<V>(this.getConfirmed().values());
        this.values = this.getMap().values();
        ArrayList<V> test = new ArrayList<V>(this.values);
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        Assertions.assertEquals((int)size, (int)this.values.size(), (String)("values should be same size as HashMap's\nTest: " + test + "\nReal: " + known));
        Assertions.assertEquals((Object)empty, (Object)this.values.isEmpty(), (String)("values should be empty if HashMap is\nTest: " + test + "\nReal: " + known));
        Assertions.assertTrue((boolean)test.containsAll(known), (String)("values should contain all HashMap's elements\nTest: " + test + "\nReal: " + known));
        Assertions.assertTrue((boolean)known.containsAll(test), (String)("values should contain all HashMap's elements\nTest: " + test + "\nReal: " + known));
        for (Object v : known) {
            boolean removed = test.remove(v);
            Assertions.assertTrue((boolean)removed, (String)"Map's values should still equal HashMap's");
        }
        Assertions.assertTrue((boolean)test.isEmpty(), (String)"Map's values should still equal HashMap's");
    }

    private void views() {
        this.keySet = this.getMap().keySet();
        this.entrySet = this.getMap().entrySet();
    }

    public class TestMapEntrySet
    extends AbstractSetTest<Map.Entry<K, V>> {
        @Override
        public boolean areEqualElementsDistinguishable() {
            return AbstractMapTest.this.areEqualElementsDistinguishable();
        }

        public Map.Entry<K, V> getEntry(Iterator<Map.Entry<K, V>> itConfirmed, K key) {
            Map.Entry entry = null;
            while (itConfirmed.hasNext()) {
                Map.Entry temp = itConfirmed.next();
                if (temp.getKey() == null) {
                    if (key != null) continue;
                    entry = temp;
                    break;
                }
                if (!temp.getKey().equals(key)) continue;
                entry = temp;
                break;
            }
            Assertions.assertNotNull(entry, (String)("No matching entry in map for key '" + key + "'"));
            return entry;
        }

        public Map.Entry<K, V>[] getFullElements() {
            return this.getFullNonNullElements();
        }

        public Map.Entry<K, V>[] getFullNonNullElements() {
            Object[] k = AbstractMapTest.this.getSampleKeys();
            Object[] v = AbstractMapTest.this.getSampleValues();
            return AbstractMapTest.this.makeEntryArray(k, v);
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMapTest.this.getIterationBehaviour();
        }

        public Map.Entry<K, V>[] getOtherElements() {
            Object[] k = AbstractMapTest.this.getOtherKeys();
            Object[] v = AbstractMapTest.this.getOtherValues();
            return AbstractMapTest.this.makeEntryArray(k, v);
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        public boolean isGetStructuralModify() {
            return AbstractMapTest.this.isGetStructuralModify();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> makeFullCollection() {
            return AbstractMapTest.this.makeFullMap().entrySet();
        }

        @Override
        public Set<Map.Entry<K, V>> makeObject() {
            return AbstractMapTest.this.makeObject().entrySet();
        }

        @Override
        public void resetEmpty() {
            AbstractMapTest.this.resetEmpty();
            this.setCollection(AbstractMapTest.this.getMap().entrySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().entrySet());
        }

        @Override
        public void resetFull() {
            AbstractMapTest.this.resetFull();
            this.setCollection(AbstractMapTest.this.getMap().entrySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().entrySet());
        }

        @Test
        public void testMapEntrySetIteratorEntry() {
            this.resetFull();
            int count = 0;
            for (Map.Entry entry : this.getCollection()) {
                Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsKey(entry.getKey()));
                Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsValue(entry.getValue()));
                if (!this.isGetStructuralModify()) {
                    Assertions.assertEquals(AbstractMapTest.this.getMap().get(entry.getKey()), entry.getValue());
                }
                ++count;
            }
            Assertions.assertEquals((int)this.getCollection().size(), (int)count);
        }

        @Test
        public void testMapEntrySetIteratorEntrySetValue() {
            Object key1 = AbstractMapTest.this.getSampleKeys()[0];
            Object key2 = AbstractMapTest.this.getSampleKeys().length == 1 ? AbstractMapTest.this.getSampleKeys()[0] : AbstractMapTest.this.getSampleKeys()[1];
            Object newValue1 = AbstractMapTest.this.getNewSampleValues()[0];
            Object newValue2 = AbstractMapTest.this.getNewSampleValues().length == 1 ? AbstractMapTest.this.getNewSampleValues()[0] : AbstractMapTest.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator it = this.getCollection().iterator();
            Map.Entry entry1 = this.getEntry(it, key1);
            it = this.getCollection().iterator();
            Map.Entry entry2 = this.getEntry(it, key2);
            Iterator itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed1 = this.getEntry(itConfirmed, key1);
            itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed2 = this.getEntry(itConfirmed, key2);
            this.verify();
            if (!AbstractMapTest.this.isSetValueSupported()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> entry1.setValue(newValue1));
                return;
            }
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            Assertions.assertEquals(newValue1, entry1.getValue());
            Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsKey(entry1.getKey()));
            Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsValue(newValue1));
            Assertions.assertEquals(newValue1, AbstractMapTest.this.getMap().get(entry1.getKey()));
            this.verify();
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            Assertions.assertEquals(newValue1, entry1.getValue());
            Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsKey(entry1.getKey()));
            Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsValue(newValue1));
            Assertions.assertEquals(newValue1, AbstractMapTest.this.getMap().get(entry1.getKey()));
            this.verify();
            entry2.setValue(newValue2);
            entryConfirmed2.setValue(newValue2);
            Assertions.assertEquals(newValue2, entry2.getValue());
            Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsKey(entry2.getKey()));
            Assertions.assertTrue((boolean)AbstractMapTest.this.getMap().containsValue(newValue2));
            Assertions.assertEquals(newValue2, AbstractMapTest.this.getMap().get(entry2.getKey()));
            this.verify();
        }

        @Test
        public void testMapEntrySetRemoveNonMapEntry() {
            if (!this.isRemoveSupported()) {
                return;
            }
            this.resetFull();
            Assertions.assertFalse((boolean)this.getCollection().remove(null));
            Assertions.assertFalse((boolean)this.getCollection().remove(new Object()));
        }

        @Override
        public void verify() {
            super.verify();
            AbstractMapTest.this.verify();
        }
    }

    public class TestMapKeySet
    extends AbstractSetTest<K> {
        @Override
        public K[] getFullElements() {
            return AbstractMapTest.this.getSampleKeys();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMapTest.this.getIterationBehaviour();
        }

        @Override
        public K[] getOtherElements() {
            return AbstractMapTest.this.getOtherKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Set<K> makeFullCollection() {
            return AbstractMapTest.this.makeFullMap().keySet();
        }

        @Override
        public Set<K> makeObject() {
            return AbstractMapTest.this.makeObject().keySet();
        }

        @Override
        public void resetEmpty() {
            AbstractMapTest.this.resetEmpty();
            this.setCollection(AbstractMapTest.this.getMap().keySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().keySet());
        }

        @Override
        public void resetFull() {
            AbstractMapTest.this.resetFull();
            this.setCollection(AbstractMapTest.this.getMap().keySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().keySet());
        }

        @Override
        public void verify() {
            super.verify();
            AbstractMapTest.this.verify();
        }
    }

    public class TestMapValues
    extends AbstractCollectionTest<V> {
        @Override
        public boolean areEqualElementsDistinguishable() {
            return true;
        }

        @Override
        public V[] getFullElements() {
            return AbstractMapTest.this.getSampleValues();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMapTest.this.getIterationBehaviour();
        }

        @Override
        public V[] getOtherElements() {
            return AbstractMapTest.this.getOtherValues();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Collection<V> makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection<V> makeConfirmedFullCollection() {
            return null;
        }

        @Override
        public Collection<V> makeFullCollection() {
            return AbstractMapTest.this.makeFullMap().values();
        }

        @Override
        public Collection<V> makeObject() {
            return AbstractMapTest.this.makeObject().values();
        }

        @Override
        public void resetEmpty() {
            AbstractMapTest.this.resetEmpty();
            this.setCollection(AbstractMapTest.this.map.values());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().values());
        }

        @Override
        public void resetFull() {
            AbstractMapTest.this.resetFull();
            this.setCollection(AbstractMapTest.this.map.values());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().values());
        }

        @Override
        public void verify() {
            super.verify();
            AbstractMapTest.this.verify();
        }
    }
}

