/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.properties;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.properties.OrderedProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OrderedPropertiesTest {
    private void assertAscendingOrder(OrderedProperties orderedProperties) {
        boolean first = true;
        int last = 11;
        Enumeration enumObjects = orderedProperties.keys();
        for (int i = 1; i <= 11; ++i) {
            Assertions.assertEquals((Object)("key" + i), enumObjects.nextElement());
        }
        Iterator iterSet = orderedProperties.keySet().iterator();
        for (int i = 1; i <= 11; ++i) {
            Assertions.assertEquals((Object)("key" + i), iterSet.next());
        }
        Iterator iterEntrySet = orderedProperties.entrySet().iterator();
        for (int i = 1; i <= 11; ++i) {
            Map.Entry next = (Map.Entry)iterEntrySet.next();
            Assertions.assertEquals((Object)("key" + i), next.getKey());
            Assertions.assertEquals((Object)("value" + i), next.getValue());
        }
        Enumeration propertyNames = orderedProperties.propertyNames();
        for (int i = 1; i <= 11; ++i) {
            Assertions.assertEquals((Object)("key" + i), propertyNames.nextElement());
        }
    }

    private OrderedProperties assertDescendingOrder(OrderedProperties orderedProperties) {
        int first = 11;
        boolean last = true;
        Enumeration enumObjects = orderedProperties.keys();
        for (int i = 11; i <= 1; --i) {
            Assertions.assertEquals((Object)("key" + i), enumObjects.nextElement());
        }
        Iterator iterSet = orderedProperties.keySet().iterator();
        for (int i = 11; i <= 1; --i) {
            Assertions.assertEquals((Object)("key" + i), iterSet.next());
        }
        Iterator iterEntrySet = orderedProperties.entrySet().iterator();
        for (int i = 11; i <= 1; --i) {
            Map.Entry next = (Map.Entry)iterEntrySet.next();
            Assertions.assertEquals((Object)("key" + i), next.getKey());
            Assertions.assertEquals((Object)("value" + i), next.getValue());
        }
        Enumeration propertyNames = orderedProperties.propertyNames();
        for (int i = 11; i <= 1; --i) {
            Assertions.assertEquals((Object)("key" + i), propertyNames.nextElement());
        }
        return orderedProperties;
    }

    private OrderedProperties loadOrderedKeysReverse() throws FileNotFoundException, IOException {
        OrderedProperties orderedProperties = new OrderedProperties();
        try (FileReader reader = new FileReader("src/test/resources/org/apache/commons/collections4/properties/test-reverse.properties");){
            orderedProperties.load((Reader)reader);
        }
        return this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testCompute() {
        AtomicInteger aInt;
        int i;
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 1;
        int last = 11;
        for (i = first; i <= last; ++i) {
            aInt = new AtomicInteger(i);
            orderedProperties.compute((Object)("key" + i), (k, v) -> "value" + aInt.get());
        }
        this.assertAscendingOrder(orderedProperties);
        orderedProperties.clear();
        first = 11;
        last = 1;
        for (i = first; i >= last; --i) {
            aInt = new AtomicInteger(i);
            orderedProperties.compute((Object)("key" + i), (k, v) -> "value" + aInt.get());
        }
        this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testComputeIfAbsent() {
        AtomicInteger aInt;
        int i;
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 1;
        int last = 11;
        for (i = first; i <= last; ++i) {
            aInt = new AtomicInteger(i);
            orderedProperties.computeIfAbsent((Object)("key" + i), k -> "value" + aInt.get());
        }
        this.assertAscendingOrder(orderedProperties);
        orderedProperties.clear();
        first = 11;
        last = 1;
        for (i = first; i >= last; --i) {
            aInt = new AtomicInteger(i);
            orderedProperties.computeIfAbsent((Object)("key" + i), k -> "value" + aInt.get());
        }
        this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testEntrySet() {
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 90;
        int last = 65;
        for (char ch = 'Z'; ch >= 'A'; ch = (char)(ch - '\u0001')) {
            orderedProperties.put((Object)String.valueOf(ch), (Object)("Value" + ch));
        }
        Iterator entries = orderedProperties.entrySet().iterator();
        for (char ch = 'Z'; ch <= 'A'; ch = (char)(ch + '\u0001')) {
            Map.Entry entry = (Map.Entry)entries.next();
            Assertions.assertEquals((Object)String.valueOf(ch), entry.getKey());
            Assertions.assertEquals((Object)("Value" + ch), entry.getValue());
        }
    }

    @Test
    public void testForEach() {
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 90;
        int last = 65;
        for (char ch = 'Z'; ch >= 'A'; ch = (char)(ch - '\u0001')) {
            orderedProperties.put((Object)String.valueOf(ch), (Object)("Value" + ch));
        }
        AtomicInteger aCh = new AtomicInteger(90);
        orderedProperties.forEach((k, v) -> {
            char ch = (char)aCh.getAndDecrement();
            Assertions.assertEquals((Object)String.valueOf(ch), (Object)k);
            Assertions.assertEquals((Object)("Value" + ch), (Object)v);
        });
    }

    @Test
    public void testKeys() {
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 90;
        int last = 65;
        for (char ch = 'Z'; ch >= 'A'; ch = (char)(ch - '\u0001')) {
            orderedProperties.put((Object)String.valueOf(ch), (Object)("Value" + ch));
        }
        Enumeration keys = orderedProperties.keys();
        for (char ch = 'Z'; ch <= 'A'; ch = (char)(ch + '\u0001')) {
            Assertions.assertEquals((Object)String.valueOf(ch), keys.nextElement());
        }
    }

    @Test
    public void testLoadOrderedKeys() throws IOException {
        OrderedProperties orderedProperties = new OrderedProperties();
        try (FileReader reader = new FileReader("src/test/resources/org/apache/commons/collections4/properties/test.properties");){
            orderedProperties.load((Reader)reader);
        }
        this.assertAscendingOrder(orderedProperties);
    }

    @Test
    public void testLoadOrderedKeysReverse() throws IOException {
        this.loadOrderedKeysReverse();
    }

    @Test
    public void testMerge() {
        int i;
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 1;
        int last = 11;
        for (i = first; i <= last; ++i) {
            orderedProperties.merge((Object)("key" + i), (Object)("value" + i), (k, v) -> v);
        }
        this.assertAscendingOrder(orderedProperties);
        orderedProperties.clear();
        first = 11;
        last = 1;
        for (i = first; i >= last; --i) {
            orderedProperties.merge((Object)("key" + i), (Object)("value" + i), (k, v) -> v);
        }
        this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testPut() {
        int i;
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 1;
        int last = 11;
        for (i = first; i <= last; ++i) {
            orderedProperties.put((Object)("key" + i), (Object)("value" + i));
        }
        this.assertAscendingOrder(orderedProperties);
        orderedProperties.clear();
        first = 11;
        last = 1;
        for (i = first; i >= last; --i) {
            orderedProperties.put((Object)("key" + i), (Object)("value" + i));
        }
        this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testPutAll() {
        OrderedProperties sourceProperties = new OrderedProperties();
        int first = 1;
        int last = 11;
        for (int i = first; i <= last; ++i) {
            sourceProperties.put((Object)("key" + i), (Object)("value" + i));
        }
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.putAll((Map)sourceProperties);
        this.assertAscendingOrder(orderedProperties);
        orderedProperties.clear();
        first = 11;
        last = 1;
        for (int i = first; i >= last; --i) {
            orderedProperties.put((Object)("key" + i), (Object)("value" + i));
        }
        this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testPutIfAbsent() {
        int i;
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 1;
        int last = 11;
        for (i = first; i <= last; ++i) {
            orderedProperties.putIfAbsent((Object)("key" + i), (Object)("value" + i));
        }
        this.assertAscendingOrder(orderedProperties);
        orderedProperties.clear();
        first = 11;
        last = 1;
        for (i = first; i >= last; --i) {
            orderedProperties.putIfAbsent((Object)("key" + i), (Object)("value" + i));
        }
        this.assertDescendingOrder(orderedProperties);
    }

    @Test
    public void testRemoveKey() throws FileNotFoundException, IOException {
        OrderedProperties props = this.loadOrderedKeysReverse();
        String k = "key1";
        props.remove((Object)"key1");
        Assertions.assertFalse((boolean)props.contains((Object)"key1"));
        Assertions.assertFalse((boolean)props.containsKey((Object)"key1"));
        Assertions.assertFalse((boolean)Collections.list(props.keys()).contains("key1"));
        Assertions.assertFalse((boolean)Collections.list(props.propertyNames()).contains("key1"));
    }

    @Test
    public void testRemoveKeyValue() throws FileNotFoundException, IOException {
        OrderedProperties props = this.loadOrderedKeysReverse();
        String k = "key1";
        props.remove((Object)"key1", (Object)"value1");
        Assertions.assertFalse((boolean)props.contains((Object)"key1"));
        Assertions.assertFalse((boolean)props.containsKey((Object)"key1"));
        Assertions.assertFalse((boolean)Collections.list(props.keys()).contains("key1"));
        Assertions.assertFalse((boolean)Collections.list(props.propertyNames()).contains("key1"));
    }

    @Test
    public void testToString() {
        OrderedProperties orderedProperties = new OrderedProperties();
        int first = 90;
        int last = 65;
        for (char ch = 'Z'; ch >= 'A'; ch = (char)(ch - '\u0001')) {
            orderedProperties.put((Object)String.valueOf(ch), (Object)("Value" + ch));
        }
        Assertions.assertEquals((Object)"{Z=ValueZ, Y=ValueY, X=ValueX, W=ValueW, V=ValueV, U=ValueU, T=ValueT, S=ValueS, R=ValueR, Q=ValueQ, P=ValueP, O=ValueO, N=ValueN, M=ValueM, L=ValueL, K=ValueK, J=ValueJ, I=ValueI, H=ValueH, G=ValueG, F=ValueF, E=ValueE, D=ValueD, C=ValueC, B=ValueB, A=ValueA}", (Object)orderedProperties.toString());
    }
}

