/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBlock;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;

public class PhotoshopApp13Data {
    private final boolean forceUtf8Encoding;
    private final List<IptcRecord> records;
    private final List<IptcBlock> rawBlocks;

    public PhotoshopApp13Data(List<IptcRecord> records, List<IptcBlock> rawBlocks) {
        this(records, rawBlocks, false);
    }

    public PhotoshopApp13Data(List<IptcRecord> records, List<IptcBlock> rawBlocks, boolean forceUtf8Encoding) {
        this.rawBlocks = rawBlocks == null ? Collections.emptyList() : Collections.unmodifiableList(rawBlocks);
        this.records = records == null ? Collections.emptyList() : Collections.unmodifiableList(records);
        this.forceUtf8Encoding = forceUtf8Encoding;
    }

    public List<IptcBlock> getNonIptcBlocks() {
        ArrayList<IptcBlock> result = new ArrayList<IptcBlock>();
        for (IptcBlock block : this.rawBlocks) {
            if (block.isIptcBlock()) continue;
            result.add(block);
        }
        return result;
    }

    public List<IptcBlock> getRawBlocks() {
        return new ArrayList<IptcBlock>(this.rawBlocks);
    }

    public List<IptcRecord> getRecords() {
        return new ArrayList<IptcRecord>(this.records);
    }

    public boolean isForceUtf8Encoding() {
        return this.forceUtf8Encoding;
    }
}

