/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.internal.introspection.SandboxUberspect;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BuilderTest {
    BuilderTest() {
    }

    private static JexlBuilder builder() {
        return new JexlBuilder();
    }

    @Test
    void testFlags() {
        Assertions.assertTrue((boolean)BuilderTest.builder().antish(true).antish());
        Assertions.assertFalse((boolean)BuilderTest.builder().antish(false).antish());
        Assertions.assertTrue((boolean)BuilderTest.builder().cancellable(true).cancellable());
        Assertions.assertFalse((boolean)BuilderTest.builder().cancellable(false).cancellable());
        Assertions.assertTrue((boolean)BuilderTest.builder().safe(true).safe());
        Assertions.assertFalse((boolean)BuilderTest.builder().safe(false).safe());
        Assertions.assertTrue((boolean)BuilderTest.builder().silent(true).silent());
        Assertions.assertFalse((boolean)BuilderTest.builder().silent(false).silent());
        Assertions.assertTrue((boolean)BuilderTest.builder().lexical(true).lexical());
        Assertions.assertFalse((boolean)BuilderTest.builder().lexical(false).lexical());
        Assertions.assertTrue((boolean)BuilderTest.builder().lexicalShade(true).lexicalShade());
        Assertions.assertFalse((boolean)BuilderTest.builder().lexicalShade(false).lexicalShade());
        Assertions.assertTrue((boolean)BuilderTest.builder().silent(true).silent());
        Assertions.assertFalse((boolean)BuilderTest.builder().silent(false).silent());
        Assertions.assertTrue((boolean)BuilderTest.builder().strict(true).strict());
        Assertions.assertFalse((boolean)BuilderTest.builder().strict(false).strict());
        Assertions.assertTrue((boolean)BuilderTest.builder().booleanLogical(true).options().isBooleanLogical());
        Assertions.assertFalse((boolean)BuilderTest.builder().booleanLogical(false).options().isBooleanLogical());
        Assertions.assertTrue((boolean)BuilderTest.builder().strictInterpolation(true).options().isStrictInterpolation());
        Assertions.assertFalse((boolean)BuilderTest.builder().strictInterpolation(false).options().isStrictInterpolation());
    }

    @Test
    void testOther() {
        ClassLoader cls = this.getClass().getClassLoader().getParent();
        Assertions.assertEquals((Object)cls, (Object)BuilderTest.builder().loader(cls).loader());
        Charset cs = StandardCharsets.UTF_16;
        Assertions.assertEquals((Object)cs, (Object)BuilderTest.builder().charset(cs).charset());
        Assertions.assertEquals((Object)cs, (Object)BuilderTest.builder().loader(cs).charset());
        JexlUberspect u0 = BuilderTest.builder().create().getUberspect();
        JexlSandbox sandbox = new JexlSandbox();
        SandboxUberspect uberspect = new SandboxUberspect(u0, sandbox);
        Assertions.assertEquals((Object)sandbox, (Object)BuilderTest.builder().sandbox(sandbox).sandbox());
        Assertions.assertEquals((Object)uberspect, (Object)BuilderTest.builder().uberspect((JexlUberspect)uberspect).uberspect());
    }

    @Test
    void testValues() {
        Assertions.assertEquals((int)1, (int)BuilderTest.builder().collectMode(1).collectMode());
        Assertions.assertEquals((int)0, (int)BuilderTest.builder().collectMode(0).collectMode());
        Assertions.assertEquals((int)32, (int)BuilderTest.builder().cacheThreshold(32).cacheThreshold());
        Assertions.assertEquals((int)8, (int)BuilderTest.builder().stackOverflow(8).stackOverflow());
    }
}

