/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.NodeSetContext;
import org.apache.commons.jxpath.ri.axes.PredicateContext;
import org.apache.commons.jxpath.ri.axes.SimplePathInterpreter;
import org.apache.commons.jxpath.ri.axes.UnionContext;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class ExpressionPath
extends Path {
    private final Expression expression;
    private final Expression[] predicates;
    private boolean basicKnown;
    private boolean basic;

    public ExpressionPath(Expression expression, Expression[] predicates, Step[] steps) {
        super(steps);
        this.expression = expression;
        this.predicates = predicates;
    }

    @Override
    public Object compute(EvalContext context) {
        return this.expressionPath(context, false);
    }

    @Override
    public boolean computeContextDependent() {
        if (this.expression.isContextDependent()) {
            return true;
        }
        if (this.predicates != null) {
            for (Expression predicate : this.predicates) {
                if (!predicate.isContextDependent()) continue;
                return true;
            }
        }
        return super.computeContextDependent();
    }

    @Override
    public Object computeValue(EvalContext context) {
        return this.expressionPath(context, true);
    }

    protected Object expressionPath(EvalContext evalContext, boolean firstMatch) {
        EvalContext ctx;
        NodePointer ptr;
        Object value = this.expression.compute(evalContext);
        EvalContext context = value instanceof InitialContext ? (InitialContext)value : (value instanceof EvalContext ? new UnionContext(evalContext, new EvalContext[]{(EvalContext)value}) : evalContext.getRootContext().getConstantContext(value));
        if (firstMatch && this.isSimpleExpressionPath() && !(context instanceof NodeSetContext) && (ptr = (NodePointer)(ctx = context).getSingleNodePointer()) != null && (ptr.getIndex() == Integer.MIN_VALUE || this.predicates == null || this.predicates.length == 0)) {
            return SimplePathInterpreter.interpretSimpleExpressionPath(evalContext, ptr, this.predicates, this.getSteps());
        }
        if (this.predicates != null) {
            for (int j = 0; j < this.predicates.length; ++j) {
                if (j != 0) {
                    context = new UnionContext(context, new EvalContext[]{context});
                }
                context = new PredicateContext(context, this.predicates[j]);
            }
        }
        return firstMatch ? this.getSingleNodePointerForSteps(context) : this.evalSteps(context);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression[] getPredicates() {
        return this.predicates;
    }

    public synchronized boolean isSimpleExpressionPath() {
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = this.isSimplePath() && this.areBasicPredicates(this.getPredicates());
        }
        return this.basic;
    }

    public String toString() {
        Step[] steps;
        StringBuilder buffer = new StringBuilder();
        if (this.expression instanceof CoreOperation || this.expression instanceof ExpressionPath || this.expression instanceof LocationPath) {
            buffer.append('(');
            buffer.append(this.expression);
            buffer.append(')');
        } else {
            buffer.append(this.expression);
        }
        if (this.predicates != null) {
            for (Expression predicate : this.predicates) {
                buffer.append('[');
                buffer.append(predicate);
                buffer.append(']');
            }
        }
        if ((steps = this.getSteps()) != null) {
            for (Step step : steps) {
                buffer.append("/");
                buffer.append(step);
            }
        }
        return buffer.toString();
    }
}

