/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.FastTimeZone;
import org.apache.commons.lang3.time.TimeZones;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FastTimeZoneTest
extends AbstractLangTest {
    private static final int HOURS_23 = 82800000;
    private static final int HOURS_2 = 0x6DDD00;
    private static final int MINUTES_59 = 3540000;
    private static final int MINUTES_5 = 300000;

    FastTimeZoneTest() {
    }

    @Test
    void testBareGmt() {
        Assertions.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"GMT"));
    }

    @Test
    void testGetGmtTimeZone() {
        Assertions.assertEquals((int)0, (int)FastTimeZone.getGmtTimeZone().getRawOffset());
    }

    @Test
    void testGmtPrefix() {
        Assertions.assertEquals((int)82800000, (int)FastTimeZone.getGmtTimeZone((String)"GMT+23:00").getRawOffset());
        Assertions.assertEquals((int)-82800000, (int)FastTimeZone.getGmtTimeZone((String)"GMT-23:00").getRawOffset());
    }

    @Test
    void testHoursColonMinutes() {
        Assertions.assertEquals((int)82800000, (int)FastTimeZone.getGmtTimeZone((String)"23:00").getRawOffset());
        Assertions.assertEquals((int)0x6DDD00, (int)FastTimeZone.getGmtTimeZone((String)"2:00").getRawOffset());
        Assertions.assertEquals((int)3540000, (int)FastTimeZone.getGmtTimeZone((String)"00:59").getRawOffset());
        Assertions.assertEquals((int)300000, (int)FastTimeZone.getGmtTimeZone((String)"00:5").getRawOffset());
        Assertions.assertEquals((int)86340000, (int)FastTimeZone.getGmtTimeZone((String)"23:59").getRawOffset());
        Assertions.assertEquals((int)7500000, (int)FastTimeZone.getGmtTimeZone((String)"2:5").getRawOffset());
    }

    @Test
    void testHoursMinutes() {
        Assertions.assertEquals((int)82800000, (int)FastTimeZone.getGmtTimeZone((String)"2300").getRawOffset());
        Assertions.assertEquals((int)0x6DDD00, (int)FastTimeZone.getGmtTimeZone((String)"0200").getRawOffset());
        Assertions.assertEquals((int)3540000, (int)FastTimeZone.getGmtTimeZone((String)"0059").getRawOffset());
        Assertions.assertEquals((int)300000, (int)FastTimeZone.getGmtTimeZone((String)"0005").getRawOffset());
        Assertions.assertEquals((int)86340000, (int)FastTimeZone.getGmtTimeZone((String)"2359").getRawOffset());
        Assertions.assertEquals((int)7500000, (int)FastTimeZone.getGmtTimeZone((String)"0205").getRawOffset());
    }

    @Test
    void testOlson() {
        Assertions.assertEquals((Object)TimeZones.getTimeZone((String)"America/New_York"), (Object)FastTimeZone.getTimeZone((String)"America/New_York"));
    }

    @Test
    void testSign() {
        Assertions.assertEquals((int)82800000, (int)FastTimeZone.getGmtTimeZone((String)"+23:00").getRawOffset());
        Assertions.assertEquals((int)0x6DDD00, (int)FastTimeZone.getGmtTimeZone((String)"+2:00").getRawOffset());
        Assertions.assertEquals((int)-82800000, (int)FastTimeZone.getGmtTimeZone((String)"-23:00").getRawOffset());
        Assertions.assertEquals((int)-7200000, (int)FastTimeZone.getGmtTimeZone((String)"-2:00").getRawOffset());
    }

    @Test
    void testUTC() {
        Assertions.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"UTC"));
    }

    @Test
    void testZ() {
        Assertions.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"Z"));
    }

    @Test
    void testZeroOffsetsReturnSingleton() {
        Assertions.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"+0"));
        Assertions.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"-0"));
    }
}

