/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.LogBeta;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class BetaDistribution
extends AbstractContinuousDistribution {
    private final double alpha;
    private final double beta;
    private final double logBeta;
    private final double mean;
    private final double variance;

    private BetaDistribution(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.logBeta = LogBeta.value((double)alpha, (double)beta);
        double alphabetasum = alpha + beta;
        this.mean = alpha / alphabetasum;
        this.variance = alpha * beta / (alphabetasum * alphabetasum * (alphabetasum + 1.0));
    }

    public static BetaDistribution of(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", alpha);
        }
        if (beta <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", beta);
        }
        return new BetaDistribution(alpha, beta);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        if (x < 0.0 || x > 1.0) {
            return 0.0;
        }
        return RegularizedBeta.derivative((double)x, (double)this.alpha, (double)this.beta);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0 || x > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            if (this.alpha < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.alpha == 1.0) {
                return -this.logBeta;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 1.0) {
            if (this.beta < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.beta == 1.0) {
                return -this.logBeta;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double logX = Math.log(x);
        double log1mX = Math.log1p(-x);
        return (this.alpha - 1.0) * logX + (this.beta - 1.0) * log1mX - this.logBeta;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return RegularizedBeta.value((double)x, (double)this.alpha, (double)this.beta);
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= 1.0) {
            return 0.0;
        }
        return RegularizedBeta.complement((double)x, (double)this.alpha, (double)this.beta);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return 1.0;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateContinuousSampler)ChengBetaSampler.of((UniformRandomProvider)rng, (double)this.alpha, (double)this.beta)).sample();
    }
}

