/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class LogUniformDistribution
extends AbstractContinuousDistribution {
    private final double lower;
    private final double upper;
    private final double logA;
    private final double logB;
    private final double logBmLogA;
    private final double logLogBmLogA;

    private LogUniformDistribution(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
        this.logA = Math.log(lower);
        this.logB = Math.log(upper);
        this.logBmLogA = this.logB - this.logA;
        this.logLogBmLogA = Math.log(this.logBmLogA);
    }

    public static LogUniformDistribution of(double lower, double upper) {
        if (lower >= upper) {
            throw new DistributionException("Lower bound %s >= upper bound %s", lower, upper);
        }
        if (!Double.isFinite(upper - lower)) {
            throw new DistributionException("Range %s is not finite", upper - lower);
        }
        if (lower <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", lower);
        }
        return new LogUniformDistribution(lower, upper);
    }

    @Override
    public double density(double x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        if (x < this.lower || x > this.upper) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(x) - this.logLogBmLogA;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.lower) {
            return 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return (Math.log(x) - this.logA) / this.logBmLogA;
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= this.lower) {
            return 1.0;
        }
        if (x >= this.upper) {
            return 0.0;
        }
        return (this.logB - Math.log(x)) / this.logBmLogA;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.clipToRange(Math.exp(this.logA + p * this.logBmLogA));
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.clipToRange(Math.exp(this.logB - p * this.logBmLogA));
    }

    @Override
    public double getMean() {
        return (this.upper - this.lower) / this.logBmLogA;
    }

    @Override
    public double getVariance() {
        double a = this.lower;
        double b = this.upper;
        double d = -this.logBmLogA;
        return (a - b) * (a * (d - 2.0) + b * (d + 2.0)) / (2.0 * d * d);
    }

    @Override
    public double getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public double getSupportUpperBound() {
        return this.upper;
    }

    private double clipToRange(double x) {
        return LogUniformDistribution.clip(x, this.lower, this.upper);
    }

    private static double clip(double x, double lower, double upper) {
        if (x <= lower) {
            return lower;
        }
        return x < upper ? x : upper;
    }

    @Override
    double getMedian() {
        return Math.exp(0.5 * (this.logA + this.logB));
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        SharedStateContinuousSampler s = ContinuousUniformSampler.of((UniformRandomProvider)rng, (double)this.logA, (double)this.logB);
        return () -> Math.exp(s.sample());
    }
}

