/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.Gamma;
import org.apache.commons.numbers.gamma.GammaRatio;
import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.numbers.gamma.RegularizedGamma;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class NakagamiDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private final double mu;
    private final double omega;
    private final double densityPrefactor;
    private final double logDensityPrefactor;
    private final double mean;
    private final double variance;

    private NakagamiDistribution(double mu, double omega) {
        this.mu = mu;
        this.omega = omega;
        this.densityPrefactor = 2.0 * Math.pow(mu, mu) / (Gamma.value((double)mu) * Math.pow(omega, mu));
        this.logDensityPrefactor = 0.6931471805599453 + Math.log(mu) * mu - LogGamma.value((double)mu) - Math.log(omega) * mu;
        double v = GammaRatio.delta((double)mu, (double)0.5);
        this.mean = Math.sqrt(omega / mu) / v;
        this.variance = omega - omega / mu / v / v;
    }

    public static NakagamiDistribution of(double mu, double omega) {
        if (mu <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", mu);
        }
        if (omega <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", omega);
        }
        return new NakagamiDistribution(mu, omega);
    }

    public double getShape() {
        return this.mu;
    }

    public double getScale() {
        return this.omega;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return this.densityPrefactor * Math.pow(x, 2.0 * this.mu - 1.0) * Math.exp(-this.mu * x * x / this.omega);
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.logDensityPrefactor + Math.log(x) * (2.0 * this.mu - 1.0) - this.mu * x * x / this.omega;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return RegularizedGamma.P.value((double)this.mu, (double)(this.mu * x * x / this.omega));
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return RegularizedGamma.Q.value((double)this.mu, (double)(this.mu * x * x / this.omega));
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        double shape = this.mu;
        double scale = this.omega / this.mu;
        SharedStateContinuousSampler sampler = AhrensDieterMarsagliaTsangGammaSampler.of((UniformRandomProvider)rng, (double)shape, (double)scale);
        return () -> Math.sqrt(sampler.sample());
    }
}

