/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import io.netty.util.collection.LongObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCounterRebuildManager;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.SizeAwareMetric;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagingManagerImpl
implements PagingManager {
    private static final int PAGE_TX_CLEANUP_PRINT_LIMIT = 1000;
    private static final int ARTEMIS_PAGING_COUNTER_SNAPSHOT_INTERVAL = Integer.parseInt(System.getProperty("artemis.paging.counter.snapshot.interval", "60"));
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile boolean started = false;
    private final ReentrantReadWriteLock syncLock = new ReentrantReadWriteLock();
    private final Set<PagingStore> blockedStored = new ConcurrentHashSet();
    private final ConcurrentMap<SimpleString, PagingStore> stores = new ConcurrentHashMap<SimpleString, PagingStore>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ActiveMQServer server;
    private PagingStoreFactory pagingStoreFactory;
    private volatile boolean globalFull;
    private final SizeAwareMetric globalSizeMetric;
    private long maxSize;
    private long maxMessages;
    private volatile boolean cleanupEnabled = true;
    private volatile boolean diskFull = false;
    private volatile long diskUsableSpace = 0L;
    private volatile long diskTotalSpace = 0L;
    private final Executor managerExecutor;
    private final Queue<Runnable> memoryCallback = new ConcurrentLinkedQueue<Runnable>();
    private final ConcurrentMap<Long, PageTransactionInfo> transactions = new ConcurrentHashMap<Long, PageTransactionInfo>();
    private ActiveMQScheduledComponent snapshotUpdater = null;
    private final SimpleString managementAddress;
    private volatile boolean rebuildingPageCounters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGlobalFull(boolean globalFull) {
        Queue<Runnable> queue = this.memoryCallback;
        synchronized (queue) {
            this.globalFull = globalFull;
            this.checkMemoryRelease();
        }
    }

    public void replacePageStoreFactory(PagingStoreFactory factory) {
        this.pagingStoreFactory = factory;
    }

    public PagingStoreFactory getPagingStoreFactory() {
        return this.pagingStoreFactory;
    }

    public PagingManagerImpl(PagingStoreFactory pagingSPI, HierarchicalRepository<AddressSettings> addressSettingsRepository, long maxSize, long maxMessages, SimpleString managementAddress, ActiveMQServer server) {
        this.pagingStoreFactory = pagingSPI;
        this.addressSettingsRepository = addressSettingsRepository;
        addressSettingsRepository.registerListener(this);
        this.maxSize = maxSize;
        this.maxMessages = maxMessages;
        this.globalSizeMetric = new SizeAwareMetric(maxSize, maxSize, maxMessages, maxMessages);
        this.globalSizeMetric.setOverCallback(() -> this.setGlobalFull(true));
        this.globalSizeMetric.setUnderCallback(() -> this.setGlobalFull(false));
        this.managerExecutor = pagingSPI.newExecutor();
        this.managementAddress = managementAddress;
        this.server = server;
    }

    SizeAwareMetric getSizeAwareMetric() {
        return this.globalSizeMetric;
    }

    void resetMaxSize(long maxSize, long maxMessages) {
        this.maxSize = maxSize;
        this.maxMessages = maxMessages;
        this.globalSizeMetric.setMax(maxSize, maxSize, maxMessages, maxMessages);
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getMaxMessages() {
        return this.maxMessages;
    }

    public PagingManagerImpl(PagingStoreFactory pagingSPI, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this(pagingSPI, addressSettingsRepository, -1L, -1L, null, null);
    }

    public PagingManagerImpl(PagingStoreFactory pagingSPI, HierarchicalRepository<AddressSettings> addressSettingsRepository, SimpleString managementAddress) {
        this(pagingSPI, addressSettingsRepository, -1L, -1L, managementAddress, null);
    }

    @Override
    public void addBlockedStore(PagingStore store) {
        this.blockedStored.add(store);
    }

    public Set<PagingStore> getBlockedSet() {
        return new HashSet<PagingStore>(this.blockedStored);
    }

    @Override
    public void onChange() {
        this.reapplySettings();
    }

    private void reapplySettings() {
        for (PagingStore store : this.stores.values()) {
            AddressSettings settings = this.addressSettingsRepository.getMatch(store.getAddress().toString());
            store.applySetting(settings);
        }
    }

    @Override
    public PagingManagerImpl addSize(int size, boolean sizeOnly) {
        long newSize = this.globalSizeMetric.addSize(size, sizeOnly);
        if (newSize < 0L) {
            ActiveMQServerLogger.LOGGER.negativeGlobalAddressSize(newSize);
        }
        return this;
    }

    @Override
    public long getGlobalSize() {
        return this.globalSizeMetric.getSize();
    }

    @Override
    public long getGlobalMessages() {
        return this.globalSizeMetric.getElements();
    }

    protected void checkMemoryRelease() {
        if (!(this.diskFull || this.maxSize >= 0L && this.globalFull || this.blockedStored.isEmpty())) {
            if (!this.memoryCallback.isEmpty()) {
                if (this.managerExecutor != null) {
                    this.managerExecutor.execute(this::memoryReleased);
                } else {
                    this.memoryReleased();
                }
            }
            this.blockedStored.removeIf(PagingStore::checkReleasedMemory);
        }
    }

    @Override
    public void execute(Runnable run) {
        this.managerExecutor.execute(run);
    }

    @Override
    public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        this.pagingStoreFactory.injectMonitor(monitor);
        monitor.addCallback(new LocalMonitor());
    }

    protected void setDiskFull(boolean diskFull) {
        this.diskFull = diskFull;
    }

    @Override
    public boolean isDiskFull() {
        return this.diskFull;
    }

    @Override
    public long getDiskUsableSpace() {
        return this.diskUsableSpace;
    }

    @Override
    public long getDiskTotalSpace() {
        return this.diskTotalSpace;
    }

    @Override
    public boolean isUsingGlobalSize() {
        return this.maxSize > 0L;
    }

    @Override
    public void checkMemory(Runnable runWhenAvailable) {
        if (this.isGlobalFull()) {
            this.memoryCallback.add((Runnable)AtomicRunnable.checkAtomic((Runnable)runWhenAvailable));
            return;
        }
        runWhenAvailable.run();
    }

    @Override
    public void checkStorage(Runnable runWhenAvailable) {
        if (this.diskFull) {
            this.memoryCallback.add((Runnable)AtomicRunnable.checkAtomic((Runnable)runWhenAvailable));
            return;
        }
        runWhenAvailable.run();
    }

    private void memoryReleased() {
        Runnable runnable;
        while ((runnable = this.memoryCallback.poll()) != null) {
            runnable.run();
        }
    }

    @Override
    public boolean isGlobalFull() {
        return this.diskFull || this.maxSize > 0L && this.globalFull;
    }

    @Override
    public void disableCleanup() {
        if (!this.cleanupEnabled) {
            return;
        }
        this.lock();
        try {
            this.cleanupEnabled = false;
            for (PagingStore store : this.stores.values()) {
                store.disableCleanup();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void resumeCleanup() {
        if (this.cleanupEnabled) {
            return;
        }
        this.lock();
        try {
            this.cleanupEnabled = true;
            for (PagingStore store : this.stores.values()) {
                store.enableCleanup();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public SimpleString[] getStoreNames() {
        Set names = this.stores.keySet();
        return names.toArray(new SimpleString[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadStores() throws Exception {
        this.lock();
        try {
            List<PagingStore> reloadedStores = this.pagingStoreFactory.reloadStores(this.addressSettingsRepository);
            for (PagingStore store : reloadedStores) {
                PagingStore oldStore = (PagingStore)this.stores.remove(store.getStoreName());
                if (oldStore != null) {
                    oldStore.stop();
                }
                store.getCursorProvider().counterRebuildStarted();
                store.start();
                this.stores.put(store.getStoreName(), store);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void deletePageStore(SimpleString storeName) throws Exception {
        PagingStore store;
        this.syncLock.readLock().lock();
        try {
            store = (PagingStore)this.stores.remove(CompositeAddress.extractAddressName((SimpleString)storeName));
        }
        finally {
            this.syncLock.readLock().unlock();
        }
        if (store != null) {
            store.destroy();
        }
    }

    @Override
    public PagingStore getPageStore(SimpleString rawStoreName) throws Exception {
        SimpleString storeName = CompositeAddress.extractAddressName((SimpleString)rawStoreName);
        if (this.managementAddress != null && storeName.startsWith(this.managementAddress)) {
            return null;
        }
        PagingStore store = (PagingStore)this.stores.get(storeName);
        if (store != null) {
            return store;
        }
        try {
            return this.stores.computeIfAbsent(storeName, s -> {
                try {
                    return this.newStore((SimpleString)s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw (Exception)e.getCause();
        }
    }

    @Override
    public void addTransaction(PageTransactionInfo pageTransaction) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding pageTransaction {}", (Object)pageTransaction.getTransactionID());
        }
        this.transactions.put(pageTransaction.getTransactionID(), pageTransaction);
    }

    @Override
    public void removeTransaction(long id) {
        if (logger.isTraceEnabled()) {
            logger.trace("Removing pageTransaction {}", (Object)id);
        }
        this.transactions.remove(id);
    }

    @Override
    public PageTransactionInfo getTransaction(long id) {
        if (logger.isTraceEnabled()) {
            logger.trace("looking up pageTX = {}", (Object)id);
        }
        return (PageTransactionInfo)this.transactions.get(id);
    }

    @Override
    public Map<Long, PageTransactionInfo> getTransactions() {
        return this.transactions;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isRebuildingCounters() {
        return this.rebuildingPageCounters;
    }

    public void start() throws Exception {
        this.lock();
        try {
            if (this.started) {
                return;
            }
            this.pagingStoreFactory.setPagingManager(this);
            this.reloadStores();
            if (ARTEMIS_PAGING_COUNTER_SNAPSHOT_INTERVAL > 0) {
                this.snapshotUpdater = new ActiveMQScheduledComponent(this.pagingStoreFactory.getScheduledExecutor(), this.pagingStoreFactory.newExecutor(), ARTEMIS_PAGING_COUNTER_SNAPSHOT_INTERVAL, TimeUnit.SECONDS, false){

                    public void run() {
                        try {
                            logger.debug("Updating counter snapshots");
                            PagingManagerImpl.this.counterSnapshot();
                        }
                        catch (Throwable e) {
                            logger.warn(e.getMessage(), e);
                        }
                    }
                };
                this.snapshotUpdater.start();
            }
            this.started = true;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void counterSnapshot() {
        for (PagingStore store : this.stores.values()) {
            store.counterSnapshot();
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.snapshotUpdater != null) {
            this.snapshotUpdater.stop();
            this.snapshotUpdater = null;
        }
        this.lock();
        try {
            for (PagingStore store : this.stores.values()) {
                store.stop();
            }
            this.pagingStoreFactory.stop();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void processReload() throws Exception {
        logger.debug("Processing reload");
        for (PagingStore store : this.stores.values()) {
            logger.debug("Processing reload on page store {}", (Object)store.getAddress());
            store.processReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagingStore newStore(SimpleString address) throws Exception {
        assert (this.managementAddress == null || this.managementAddress != null && !address.startsWith(this.managementAddress));
        this.syncLock.readLock().lock();
        try {
            PagingStore store = this.pagingStoreFactory.newStore(address, this.addressSettingsRepository.getMatch(address.toString()));
            store.start();
            if (!this.cleanupEnabled) {
                store.disableCleanup();
            }
            PagingStore pagingStore = store;
            return pagingStore;
        }
        finally {
            this.syncLock.readLock().unlock();
        }
    }

    @Override
    public void unlock() {
        this.syncLock.writeLock().unlock();
    }

    @Override
    public void lock() {
        this.syncLock.writeLock().lock();
    }

    @Override
    public void forEachTransaction(BiConsumer<Long, PageTransactionInfo> transactionConsumer) {
        this.transactions.forEach(transactionConsumer);
    }

    @Override
    public Future<Object> rebuildCounters(Set<Long> storedLargeMessages) {
        if (this.rebuildingPageCounters) {
            logger.debug("Rebuild page counters is already underway, ignoring call");
        }
        LongObjectHashMap transactionsSet = new LongObjectHashMap();
        this.transactions.forEach((arg_0, arg_1) -> PagingManagerImpl.lambda$rebuildCounters$3((Map)transactionsSet, arg_0, arg_1));
        AtomicLong minLargeMessageID = new AtomicLong(Long.MAX_VALUE);
        HashMap<SimpleString, PagingStore> currentStoreMap = new HashMap<SimpleString, PagingStore>();
        this.stores.forEach(currentStoreMap::put);
        if (logger.isDebugEnabled()) {
            logger.debug("Page Transactions during rebuildCounters:");
            transactionsSet.forEach((a, b) -> logger.debug("{} = {}", a, b));
        }
        currentStoreMap.forEach((arg_0, arg_1) -> this.lambda$rebuildCounters$5((Map)transactionsSet, storedLargeMessages, minLargeMessageID, arg_0, arg_1));
        this.managerExecutor.execute(() -> this.lambda$rebuildCounters$6((Map)transactionsSet, currentStoreMap));
        FutureTask<Object> task = new FutureTask<Object>(() -> null);
        this.managerExecutor.execute(task);
        this.managerExecutor.execute(() -> {
            this.rebuildingPageCounters = false;
        });
        return task;
    }

    private void cleanupPageTransactions(Map<Long, PageTransactionInfo> transactionSet, Map<SimpleString, PagingStore> currentStoreMap) {
        if (this.server == null) {
            logger.warn("Server attribute was not set, cannot proceed with page transaction cleanup");
        }
        AtomicBoolean proceed = new AtomicBoolean(true);
        currentStoreMap.forEach((a, b) -> {
            if (!b.getCursorProvider().isRebuildDone()) {
                logger.warn("cannot proceed on cleaning up page transactions as page cursor for {} is not done rebuilding it", (Object)b.getAddress());
                proceed.set(false);
            }
        });
        if (!proceed.get()) {
            return;
        }
        AtomicLong txRemoved = new AtomicLong(0L);
        transactionSet.forEach((a, b) -> {
            if (b.isOrphaned()) {
                b.onUpdate(b.getNumberOfMessages(), this.server.getStorageManager(), this);
                txRemoved.incrementAndGet();
                if (txRemoved.get() < 1000L) {
                    ActiveMQServerLogger.LOGGER.removeOrphanedPageTransaction((long)a);
                } else if (txRemoved.get() % 1000L == 0L) {
                    ActiveMQServerLogger.LOGGER.cleaningOrphanedTXCleanup(txRemoved.get());
                }
            }
        });
        if (txRemoved.get() > 0L) {
            ActiveMQServerLogger.LOGGER.completeOrphanedTXCleanup(txRemoved.get());
        } else {
            logger.debug("Complete cleanupPageTransactions with no orphaned records found");
        }
    }

    private /* synthetic */ void lambda$rebuildCounters$6(Map transactionsSet, Map currentStoreMap) {
        this.cleanupPageTransactions(transactionsSet, currentStoreMap);
    }

    private /* synthetic */ void lambda$rebuildCounters$5(Map transactionsSet, Set storedLargeMessages, AtomicLong minLargeMessageID, SimpleString address, PagingStore pgStore) {
        PageCounterRebuildManager rebuildManager = new PageCounterRebuildManager(this, pgStore, transactionsSet, storedLargeMessages, minLargeMessageID);
        logger.debug("Setting destination {} to rebuild counters", (Object)address);
        this.managerExecutor.execute(rebuildManager);
    }

    private static /* synthetic */ void lambda$rebuildCounters$3(Map transactionsSet, Long a, PageTransactionInfo b) {
        transactionsSet.put(a, b);
        b.setOrphaned(true);
    }

    class LocalMonitor
    implements FileStoreMonitor.Callback {
        private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

        LocalMonitor() {
        }

        @Override
        public void tick(long usableSpace, long totalSpace, boolean withinLimit, FileStoreMonitor.FileStoreMonitorType type) {
            PagingManagerImpl.this.diskUsableSpace = usableSpace;
            PagingManagerImpl.this.diskTotalSpace = totalSpace;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Tick:: usable space at {}, total space at {}", (Object)ByteUtil.getHumanReadableByteCount((long)usableSpace), (Object)ByteUtil.getHumanReadableByteCount((long)totalSpace));
            }
            if (withinLimit) {
                boolean diskFull = PagingManagerImpl.this.diskFull;
                if (diskFull || !PagingManagerImpl.this.blockedStored.isEmpty() || !PagingManagerImpl.this.memoryCallback.isEmpty()) {
                    if (diskFull) {
                        if (type == FileStoreMonitor.FileStoreMonitorType.MaxDiskUsage) {
                            ActiveMQServerLogger.LOGGER.maxDiskUsageRestored(ByteUtil.getHumanReadableByteCount((long)usableSpace), ByteUtil.getHumanReadableByteCount((long)totalSpace), String.format("%.1f%%", FileStoreMonitor.calculateUsage(usableSpace, totalSpace) * 100.0));
                        } else {
                            ActiveMQServerLogger.LOGGER.minDiskFreeRestored(ByteUtil.getHumanReadableByteCount((long)usableSpace));
                        }
                        PagingManagerImpl.this.diskFull = false;
                    }
                    PagingManagerImpl.this.checkMemoryRelease();
                }
            } else if (!PagingManagerImpl.this.diskFull) {
                if (type == FileStoreMonitor.FileStoreMonitorType.MaxDiskUsage) {
                    ActiveMQServerLogger.LOGGER.maxDiskUsageReached(ByteUtil.getHumanReadableByteCount((long)usableSpace), ByteUtil.getHumanReadableByteCount((long)totalSpace), String.format("%.1f%%", FileStoreMonitor.calculateUsage(usableSpace, totalSpace) * 100.0));
                } else {
                    ActiveMQServerLogger.LOGGER.minDiskFreeReached(ByteUtil.getHumanReadableByteCount((long)usableSpace));
                }
                PagingManagerImpl.this.diskFull = true;
            }
        }
    }
}

