/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.GroupMgrFactory;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.ReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.impl.SdP;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheMgr;
import org.apache.directory.fortress.core.util.cache.DsdCacheEntry;

final class SDUtil {
    private Cache m_dsdCache;
    private static final String FORTRESS_DSDS = "fortress.dsd";
    private Cache m_ssdCache;
    private static final String FORTRESS_SSDS = "fortress.ssd";
    private SdP sp;
    private static final String IS_DSD_CACHE_ENABLED_PARM = "enable.dsd.cache";
    private static final String DSD_NAME = "name";
    private static final String EMPTY_ELEMENT = "empty";
    private static final String CONTEXT_ID = "contextId";
    private static volatile SDUtil sINSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SDUtil getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<SDUtil> clazz = SDUtil.class;
        synchronized (SDUtil.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new SDUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private void init() {
        this.sp = new SdP();
        CacheMgr cacheMgr = CacheMgr.getInstance();
        this.m_dsdCache = cacheMgr.getCache(FORTRESS_DSDS);
        this.m_ssdCache = cacheMgr.getCache(FORTRESS_SSDS);
    }

    private SDUtil() {
        this.init();
    }

    void validateSSD(UserRole uRole) throws SecurityException {
        this.validateSSD(new User(uRole.getUserId()), new Role(uRole.getName()));
    }

    void validateSSD(User user, Role role) throws SecurityException {
        String contextId = user.getContextId();
        ReviewMgr rMgr = ReviewMgrFactory.createInstance(contextId);
        Set<String> rls = rMgr.authorizedRoles(user);
        this.checkSSD(role, rls, contextId);
    }

    void validateSSD(Group group, Role role) throws SecurityException {
        String contextId = group.getContextId();
        GroupMgr groupMgr = GroupMgrFactory.createInstance(contextId);
        List<UserRole> roles = groupMgr.groupRoles(group);
        Set<String> rls = RoleUtil.getInstance().getInheritedRoles(roles, contextId);
        this.checkSSD(role, rls, contextId);
    }

    private void checkSSD(Role role, Set<String> authorizedRls, String contextId) throws SecurityException {
        if (CollectionUtils.isEmpty(authorizedRls)) {
            return;
        }
        List<SDSet> ssdSets = this.getSsdCache(role.getName(), contextId);
        for (SDSet ssd : ssdSets) {
            int matchCount = 0;
            Set<String> map = ssd.getMembers();
            for (String authRole : authorizedRls) {
                if (!map.contains(authRole) || ++matchCount < ssd.getCardinality() - 1) continue;
                String error = "validateSSD new role [" + role.getName() + "] validates SSD Set Name:" + ssd.getName() + " Cardinality:" + ssd.getCardinality();
                throw new SecurityException(5088, error);
            }
        }
    }

    void validateDSD(Session session, Constraint role) throws SecurityException {
        List<UserRole> rls = session.getRoles();
        if (CollectionUtils.isEmpty(rls)) {
            return;
        }
        Set<SDSet> dsdSets = this.getDsdCache(role.getName(), session.getContextId());
        for (SDSet dsd : dsdSets) {
            int matchCount = 0;
            Set<String> map = dsd.getMembers();
            block1: for (UserRole actRole : rls) {
                if (map.contains(actRole.getName())) {
                    if (++matchCount < dsd.getCardinality() - 1) continue;
                    String error = "validateDSD failed for role [" + role.getName() + "] DSD Set Name:" + dsd.getName() + " Cardinality:" + dsd.getCardinality();
                    throw new SecurityException(5097, error);
                }
                Set<String> parentSet = RoleUtil.getInstance().getAscendants(actRole.getName(), session.getContextId());
                for (String parentRole : parentSet) {
                    if (!map.contains(parentRole)) continue;
                    if (++matchCount < dsd.getCardinality() - 1) continue block1;
                    String error = "validateDSD failed for role [" + role.getName() + "] parent role [" + parentRole + "] DSD Set Name:" + dsd.getName() + " Cardinality:" + dsd.getCardinality();
                    throw new SecurityException(5097, error);
                }
            }
        }
    }

    void clearDsdCacheEntry(String name, String contextId) {
        Attribute context = this.m_dsdCache.getSearchAttribute(CONTEXT_ID);
        Attribute dsdName = this.m_dsdCache.getSearchAttribute(DSD_NAME);
        Query query = this.m_dsdCache.createQuery();
        query.includeKeys();
        query.includeValues();
        query.addCriteria(dsdName.eq((Object)name).and(context.eq((Object)contextId)));
        Results results = query.execute();
        for (Result result : results.all()) {
            this.m_dsdCache.clear(result.getKey());
        }
    }

    private Set<SDSet> getDsdCache(String name, String contextId) throws SecurityException {
        contextId = SDUtil.getContextId(contextId);
        Set<SDSet> finalSet = new HashSet<SDSet>();
        Attribute context = this.m_dsdCache.getSearchAttribute(CONTEXT_ID);
        Attribute member = this.m_dsdCache.getSearchAttribute("member");
        Query query = this.m_dsdCache.createQuery();
        query.includeKeys();
        query.includeValues();
        query.addCriteria(member.eq((Object)name).and(context.eq((Object)contextId)));
        Results results = query.execute();
        boolean empty = false;
        for (Result result : results.all()) {
            DsdCacheEntry entry = (DsdCacheEntry)result.getValue();
            if (!entry.isEmpty()) {
                finalSet.add(entry.getSdSet());
                finalSet = this.putDsdCache(name, contextId);
            } else {
                empty = true;
            }
            finalSet.add(entry.getSdSet());
        }
        if (finalSet.size() == 0 && !empty) {
            finalSet = this.putDsdCache(name, contextId);
        }
        return finalSet;
    }

    Set<SDSet> getDsdCache(Set<String> authorizedRoleSet, String contextId) throws SecurityException {
        contextId = SDUtil.getContextId(contextId);
        Set<SDSet> dsdRetSets = new HashSet<SDSet>();
        if (!CollectionUtils.isNotEmpty(authorizedRoleSet)) {
            return dsdRetSets;
        }
        boolean isCacheEnabled = Config.getInstance().getBoolean(IS_DSD_CACHE_ENABLED_PARM, true);
        if (!isCacheEnabled) {
            SDSet sdSet = new SDSet();
            sdSet.setType(SDSet.SDType.DYNAMIC);
            sdSet.setContextId(contextId);
            dsdRetSets = this.sp.search(authorizedRoleSet, sdSet);
        } else {
            Attribute member = this.m_dsdCache.getSearchAttribute("member");
            Attribute context = this.m_dsdCache.getSearchAttribute(CONTEXT_ID);
            Query query = this.m_dsdCache.createQuery();
            query.includeKeys();
            query.includeValues();
            HashSet<String> roles = new HashSet<String>(authorizedRoleSet);
            query.addCriteria(member.in(roles).and(context.eq((Object)contextId)));
            Results results = query.execute();
            for (Result result : results.all()) {
                DsdCacheEntry entry = (DsdCacheEntry)result.getValue();
                if (entry.isEmpty()) continue;
                dsdRetSets.add(entry.getSdSet());
            }
            if (authorizedRoleSet.size() > 0) {
                dsdRetSets = this.putDsdCache(authorizedRoleSet, contextId);
            }
        }
        return dsdRetSets;
    }

    private Set<SDSet> putDsdCache(Set<String> authorizedRoleSet, String contextId) throws SecurityException {
        contextId = SDUtil.getContextId(contextId);
        HashSet<SDSet> dsdSets = new HashSet<SDSet>();
        for (String roleName : authorizedRoleSet) {
            Role role = new Role(roleName);
            role.setContextId(contextId);
            List<SDSet> dsdList = this.sp.search(role, SDSet.SDType.DYNAMIC);
            if (CollectionUtils.isNotEmpty(dsdList)) {
                for (SDSet dsd : dsdList) {
                    dsd.setContextId(contextId);
                    Set<String> members = dsd.getMembers();
                    if (members == null) continue;
                    for (String member : members) {
                        String key = SDUtil.buildKey(dsd.getName(), member);
                        DsdCacheEntry entry = new DsdCacheEntry(member, dsd, false);
                        entry.setName(dsd.getName());
                        this.m_dsdCache.put(SDUtil.getKey(key, contextId), entry);
                    }
                }
                dsdSets.addAll(dsdList);
                continue;
            }
            String key = SDUtil.buildKey(EMPTY_ELEMENT, roleName);
            SDSet sdSet = new SDSet();
            sdSet.setType(SDSet.SDType.DYNAMIC);
            sdSet.setName(key);
            sdSet.setMember(roleName);
            sdSet.setContextId(contextId);
            DsdCacheEntry entry = new DsdCacheEntry(roleName, sdSet, true);
            entry.setName(key);
            this.m_dsdCache.put(SDUtil.getKey(sdSet.getName(), contextId), entry);
        }
        return dsdSets;
    }

    private Set<SDSet> putDsdCache(String roleName, String contextId) throws SecurityException {
        contextId = SDUtil.getContextId(contextId);
        Role role = new Role(roleName);
        role.setContextId(contextId);
        List<SDSet> dsdList = this.sp.search(role, SDSet.SDType.DYNAMIC);
        HashSet<SDSet> finalSet = new HashSet<SDSet>(dsdList);
        if (CollectionUtils.isNotEmpty(dsdList)) {
            for (SDSet dsd : dsdList) {
                dsd.setContextId(contextId);
                Set<String> members = dsd.getMembers();
                if (members == null) continue;
                for (String member : members) {
                    String key = SDUtil.buildKey(dsd.getName(), member);
                    DsdCacheEntry entry = new DsdCacheEntry(member, dsd, false);
                    entry.setName(dsd.getName());
                    this.m_dsdCache.put(SDUtil.getKey(key, contextId), entry);
                }
            }
        } else {
            String key = SDUtil.buildKey(EMPTY_ELEMENT, roleName);
            SDSet sdSet = new SDSet();
            sdSet.setType(SDSet.SDType.DYNAMIC);
            sdSet.setName(key);
            sdSet.setMember(roleName);
            sdSet.setContextId(contextId);
            DsdCacheEntry entry = new DsdCacheEntry(roleName, sdSet, true);
            entry.setName(key);
            this.m_dsdCache.put(SDUtil.getKey(sdSet.getName(), contextId), entry);
        }
        return finalSet;
    }

    void clearSsdCacheEntry(String name, String contextId) {
        contextId = SDUtil.getContextId(contextId);
        this.m_ssdCache.clear(SDUtil.getKey(name, contextId));
    }

    private List<SDSet> putSsdCache(String name, String contextId) throws SecurityException {
        Role role = new Role(name);
        role.setContextId(contextId);
        List<SDSet> ssdSets = this.sp.search(role, SDSet.SDType.STATIC);
        this.m_ssdCache.put(SDUtil.getKey(name, contextId), ssdSets);
        return ssdSets;
    }

    private List<SDSet> getSsdCache(String name, String contextId) throws SecurityException {
        List<SDSet> ssdSets = (List<SDSet>)this.m_ssdCache.get(SDUtil.getKey(name, contextId));
        if (ssdSets == null) {
            ssdSets = this.putSsdCache(name, contextId);
        }
        return ssdSets;
    }

    private static String buildKey(String parm1, String parm2) {
        return parm1 + ":" + parm2;
    }

    private static String getKey(String name, String contextId) {
        contextId = SDUtil.getContextId(contextId);
        name = (String)name + ":" + contextId;
        return name;
    }

    private static String getContextId(String contextId) {
        String szContextId = "HOME";
        if (StringUtils.isNotEmpty((CharSequence)contextId) && !contextId.equals("null")) {
            szContextId = contextId;
        }
        return szContextId;
    }
}

