/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.CfgException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.model.Warning;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.ConstraintValidator;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.fortress.core.util.RegExUtil;
import org.apache.directory.fortress.core.util.time.TUtil;
import org.apache.directory.fortress.core.util.time.Time;
import org.apache.directory.fortress.core.util.time.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VUtil
implements ConstraintValidator {
    private static final String CLS_NM = VUtil.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static int maximumFieldLen;
    private static final String VALIDATE_LENGTH = "field.length";
    private static final int MAXIMUM_FIELD_LEN;
    private static final int maxFieldLength;
    private static final int TIME_LEN = 4;
    private static final int DATE_LEN = 8;
    private static final int DAYMASK_LEN = 7;
    private static final String TIME_FORMAT = "HHmm";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final char SUNDAY = '1';
    private static final char SATURDAY = '7';
    private static final SimpleDateFormat TIME_FORMATER;
    private static final SimpleDateFormat DATE_FORMATER;
    private static volatile VUtil sINSTANCE;
    private List<Validator> validators;
    private String DSDVALIDATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VUtil getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<VUtil> clazz = VUtil.class;
        synchronized (VUtil.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new VUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private void init() {
        try {
            this.validators = this.getValidators();
        }
        catch (SecurityException ex) {
            LOG.error("static initialzier caught SecurityException=" + ex.getMessage(), (Throwable)ex);
        }
        this.DSDVALIDATOR = Config.getInstance().getProperty("temporal.validator.dsd");
        String lengthProp = Config.getInstance().getProperty(VALIDATE_LENGTH);
        if (lengthProp != null) {
            maximumFieldLen = Integer.parseInt(lengthProp);
        }
    }

    private VUtil() {
        this.init();
    }

    public static ConstraintValidator getConstraintValidator() {
        return new VUtil();
    }

    public static void orgUnit(String orgUnitId) throws ValidationException {
        if (StringUtils.isEmpty((CharSequence)orgUnitId)) {
            String error = "orgUnit is null";
            throw new ValidationException(8001, error);
        }
        int length = orgUnitId.length();
        if (length > maxFieldLength) {
            String error = "orgUnit value [" + orgUnitId + "] invalid length [" + length + "]";
            throw new ValidationException(8071, error);
        }
    }

    public static void password(char[] password) throws ValidationException {
        int length = password.length;
        if (length > 50) {
            String error = "password invalid length [" + length + "]";
            throw new ValidationException(1010, error);
        }
    }

    public static void description(String value) throws ValidationException {
        int length = value.length();
        if (length > 180) {
            String error = "description value [" + value + "] invalid length [" + length + "]";
            throw new ValidationException(10014, error);
        }
        RegExUtil.getInstance().safeText(value);
    }

    public static void safeText(String value, int validLen) throws ValidationException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            String error = "safeText null value";
            throw new ValidationException(10015, error);
        }
        int length = value.length();
        if (length > validLen) {
            String error = "safeText value [" + value + "] invalid length [" + length + "]";
            throw new ValidationException(10002, error);
        }
        RegExUtil.getInstance().safeText(value);
    }

    public static void userId(String userId) throws ValidationException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            String error = "userId validation failed, null or empty value";
            throw new ValidationException(1006, error);
        }
        int length = userId.length();
        if (length > 40) {
            String error = "safeText value [" + userId + "] invalid length [" + length + "]";
            throw new ValidationException(10002, error);
        }
    }

    public static void properties(Properties props) throws ValidationException {
        if (PropUtil.isNotEmpty(props)) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                VUtil.safeText(key, 100);
                VUtil.safeText(val, 100);
            }
        }
    }

    @Override
    public void timeout(Integer timeout) throws ValidationException {
        if (timeout < 0 || timeout >= Integer.MAX_VALUE) {
            String error = "timeout - invalid timeout value [" + timeout + "]";
            throw new ValidationException(10003, error);
        }
    }

    @Override
    public void beginTime(String beginTime) throws ValidationException {
        if (beginTime != null && beginTime.length() == 4) {
            if (VUtil.checkTime(beginTime)) {
                String error = "beginTime - invalid beginTime value [" + beginTime + "]";
                throw new ValidationException(10004, error);
            }
        } else {
            String error = "beginTime - null or invalid length (must be 4) for beginTime value";
            throw new ValidationException(10005, error);
        }
    }

    @Override
    public void endTime(String endTime) throws ValidationException {
        if (endTime != null && endTime.length() == 4) {
            if (VUtil.checkTime(endTime)) {
                String error = "endTime - invalid endTime value [" + endTime + "]";
                throw new ValidationException(10006, error);
            }
        } else {
            String error = "endTime - null or invalid length (must be 4) for endTime value";
            throw new ValidationException(10007, error);
        }
    }

    @Override
    public void beginDate(String beginDate) throws ValidationException {
        if (StringUtils.isNotEmpty((CharSequence)beginDate)) {
            if (beginDate.compareToIgnoreCase("none") != 0 && (beginDate.length() != 8 || VUtil.checkDate(beginDate))) {
                String error = "beginDate - invalid beginDate value [" + beginDate + "]";
                throw new ValidationException(10008, error);
            }
        } else {
            String error = "beginDate - null or empty beginDate value";
            throw new ValidationException(10009, error);
        }
    }

    @Override
    public void endDate(String endDate) throws ValidationException {
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            if (endDate.compareToIgnoreCase("none") != 0 && (endDate.length() != 8 || VUtil.checkDate(endDate))) {
                String error = "endDate - invalid endDate value [" + endDate + "]";
                throw new ValidationException(10010, error);
            }
        } else {
            String error = "endDate - null or empty endDate value";
            throw new ValidationException(10011, error);
        }
    }

    @Override
    public void dayMask(String dayMask) throws ValidationException {
        if (StringUtils.isNotEmpty((CharSequence)dayMask)) {
            if (dayMask.compareToIgnoreCase("all") != 0 && (dayMask.length() > 7 || VUtil.checkMask(dayMask))) {
                String error = "dayMask - invalid dayMask value [" + dayMask + "]";
                throw new ValidationException(10012, error);
            }
        } else {
            String error = "dayMask - null or empty dayMask value";
            throw new ValidationException(10013, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkTime(String time) {
        try {
            SimpleDateFormat simpleDateFormat = TIME_FORMATER;
            synchronized (simpleDateFormat) {
                TIME_FORMATER.parse(time);
                return false;
            }
        }
        catch (ParseException pe) {
            String error = "checkTime - time [" + time + "] failed validation with ParseException=" + pe;
            LOG.warn(error);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDate(String date) {
        try {
            SimpleDateFormat simpleDateFormat = DATE_FORMATER;
            synchronized (simpleDateFormat) {
                DATE_FORMATER.parse(date);
                return false;
            }
        }
        catch (ParseException pe) {
            String error = "checkDate - date [" + date + "] failed validation with ParseException=" + pe;
            LOG.warn(error);
            return true;
        }
    }

    private static boolean checkMask(String mask) {
        for (char c : mask.toCharArray()) {
            if (c >= '1' && c <= '7') continue;
            String error = "checkMask - mask [" + mask + "] failed validation";
            LOG.warn(error);
            return true;
        }
        return false;
    }

    public static void assertNotNull(Object obj, int errorCode, String method) throws ValidationException {
        if (obj == null) {
            String error = "assertContext detected null entity for method [" + method + "], error code [" + errorCode + "]";
            throw new ValidationException(errorCode, error);
        }
    }

    public static void assertNotNullOrEmpty(String value, int errorCode, String method) throws ValidationException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            String error = "assertContext detected null entity for method [" + method + "], error code [" + errorCode + "]";
            throw new ValidationException(errorCode, error);
        }
    }

    public static void assertNotNullOrEmpty(char[] value, int errorCode, String method) throws ValidationException {
        if (!ArrayUtils.isNotEmpty((char[])value)) {
            String error = "assertContext detected null entity for method [" + method + "], error code [" + errorCode + "]";
            throw new ValidationException(errorCode, error);
        }
    }

    public void validateConstraints(Session session, ConstraintType type, boolean checkDsd) throws SecurityException {
        String entityType;
        String location = "validateConstraints";
        String entityId = session.isGroupSession() ? session.getGroupName() : session.getUserId();
        String string = entityType = session.isGroupSession() ? "groupName" : "userId";
        if (this.validators == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} " + entityType + " [{}] has no constraints enabled", (Object)location, (Object)entityId);
            }
            return;
        }
        if (type == ConstraintType.ROLE && CollectionUtils.isEmpty(session.getRoles()) && CollectionUtils.isEmpty(session.getAdminRoles())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} " + entityType + " [{}]  has no roles assigned", (Object)location, (Object)entityId);
            }
            return;
        }
        for (Validator val : this.validators) {
            String msg;
            ArrayList<UserRole> rolesToRemove;
            int rc;
            Time currTime = TUtil.getCurrentTime();
            if (type == ConstraintType.USER && !session.isGroupSession()) {
                rc = val.validate(session, session.getUser(), currTime, type);
                if (rc <= 0) continue;
                String info = location + " user [" + entityId + "] was deactivated reason code [" + rc + "]";
                throw new ValidationException(rc, info);
            }
            if (CollectionUtils.isNotEmpty(session.getRoles())) {
                rolesToRemove = new ArrayList<UserRole>();
                for (UserRole userRole : session.getRoles()) {
                    rc = val.validate(session, userRole, currTime, type);
                    if (rc <= 0) continue;
                    rolesToRemove.add(userRole);
                    msg = location + " role [" + userRole.getName() + "] for " + entityType + "[" + entityId + "] was deactivated reason code [" + rc + "]";
                    LOG.info(msg);
                    session.setWarning(new ObjectFactory().createWarning(rc, msg, Warning.Type.ROLE, userRole.getName()));
                }
                session.getRoles().removeAll(rolesToRemove);
            }
            if (!CollectionUtils.isNotEmpty(session.getAdminRoles())) continue;
            rolesToRemove = new ArrayList();
            for (UserRole userRole : session.getAdminRoles()) {
                rc = val.validate(session, userRole, currTime, type);
                if (rc <= 0) continue;
                rolesToRemove.add(userRole);
                msg = location + " admin role [" + userRole.getName() + "] for " + entityType + "[" + entityId + "] was deactivated reason code [" + rc + "]";
                LOG.info(msg);
                session.setWarning(new ObjectFactory().createWarning(rc, msg, Warning.Type.ROLE, userRole.getName()));
            }
            session.getAdminRoles().removeAll(rolesToRemove);
        }
        if (checkDsd && this.DSDVALIDATOR != null && this.DSDVALIDATOR.length() > 0 && type == ConstraintType.ROLE && CollectionUtils.isNotEmpty(session.getRoles())) {
            Validator dsdVal = (Validator)ClassUtil.createInstance(this.DSDVALIDATOR);
            if (session.isGroupSession()) {
                dsdVal.validate(session, new ConstraintedGroup(session.getGroup()), null, null);
            } else {
                dsdVal.validate(session, session.getUser(), null, null);
            }
        }
        session.setLastAccess();
    }

    private List<Validator> getValidators() throws CfgException {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        int i = 0;
        while (true) {
            String prop = "temporal.validator." + i;
            String className = Config.getInstance().getProperty(prop);
            if (className == null) break;
            validators.add((Validator)ClassUtil.createInstance(className));
            ++i;
        }
        return validators;
    }

    private static SimpleDateFormat getLenientFormat(String format) {
        SimpleDateFormat tformatter = new SimpleDateFormat(format);
        tformatter.setLenient(false);
        return tformatter;
    }

    static {
        maxFieldLength = MAXIMUM_FIELD_LEN = (maximumFieldLen = 130);
        TIME_FORMATER = VUtil.getLenientFormat(TIME_FORMAT);
        DATE_FORMATER = VUtil.getLenientFormat(DATE_FORMAT);
        sINSTANCE = null;
    }

    public static enum ConstraintType {
        USER,
        ROLE;

    }

    private class ConstraintedGroup
    implements Constraint {
        private Group group;

        public ConstraintedGroup(Group group) {
            this.group = group;
        }

        public Group getGroup() {
            return this.group;
        }

        @Override
        public boolean isTemporalSet() {
            return false;
        }

        @Override
        public void setTimeout(Integer timeout) {
        }

        @Override
        public void setBeginTime(String beginTime) {
        }

        @Override
        public void setEndTime(String endTime) {
        }

        @Override
        public void setBeginDate(String beginDate) {
        }

        @Override
        public void setEndDate(String endDate) {
        }

        @Override
        public void setDayMask(String dayMask) {
        }

        @Override
        public void setBeginLockDate(String beginLockDate) {
        }

        @Override
        public void setEndLockDate(String endLockDate) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public String getRawData() {
            return null;
        }

        @Override
        public Integer getTimeout() {
            return null;
        }

        @Override
        public String getBeginTime() {
            return null;
        }

        @Override
        public String getEndTime() {
            return null;
        }

        @Override
        public String getBeginDate() {
            return null;
        }

        @Override
        public String getEndDate() {
            return null;
        }

        @Override
        public String getBeginLockDate() {
            return null;
        }

        @Override
        public String getEndLockDate() {
            return null;
        }

        @Override
        public String getDayMask() {
            return null;
        }

        @Override
        public String getName() {
            return this.group.getName();
        }

        @Override
        public List<RoleConstraint> getConstraints() {
            throw new UnsupportedOperationException();
        }
    }
}

