/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util.time;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;
import org.apache.directory.fortress.core.util.time.Time;
import org.apache.directory.fortress.core.util.time.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRoleConstraint
implements Validator {
    private static final String CLS_NM = UserRoleConstraint.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    @Override
    public int validate(Session session, Constraint role, Time time, VUtil.ConstraintType type) {
        int rc = 0;
        if (type != VUtil.ConstraintType.USER) {
            String constraintKey = Config.getInstance().getConstraintKey(role.getName(), session.getContextId());
            String constraintType = Config.getInstance().getProperty(constraintKey);
            if (StringUtils.isNotEmpty((CharSequence)constraintType)) {
                String constraintValue = session.getUser().getProperty(constraintType);
                if (StringUtils.isEmpty((CharSequence)constraintValue) || role.getConstraints().isEmpty()) {
                    rc = 2059;
                    LOG.warn("User: {}, property: {} not found matching role: {}, constraint: ", new Object[]{session.getUserId(), constraintType, role.getName()});
                } else {
                    boolean found = false;
                    for (RoleConstraint constraint : role.getConstraints()) {
                        if (constraint.getType() != RoleConstraint.RCType.USER || !constraint.getKey().equalsIgnoreCase(constraintType) || !constraint.getValue().equalsIgnoreCase(constraintValue)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        rc = 2058;
                    }
                }
            }
        }
        return rc;
    }
}

