/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.SqlConstraintValidator;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlReplaceTableAs
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator REPLACE_OPERATOR = new SqlSpecialOperator("REPLACE TABLE AS", SqlKind.OTHER_DDL);
    public static final SqlSpecialOperator CREATE_OR_REPLACE_OPERATOR = new SqlSpecialOperator("CREATE OR REPLACE TABLE AS", SqlKind.OTHER_DDL);
    private final SqlIdentifier tableName;
    private final SqlNodeList columnList;
    private final SqlNodeList propertyList;
    private final List<SqlTableConstraint> tableConstraints;
    private final SqlDistribution distribution;
    private final SqlNodeList partitionKeyList;
    private final SqlWatermark watermark;
    private final SqlCharStringLiteral comment;
    private final boolean isTemporary;
    private final boolean isCreateOrReplace;
    private final SqlNode asQuery;

    public SqlDistribution getDistribution() {
        return this.distribution;
    }

    public SqlReplaceTableAs(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, SqlDistribution distribution, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, SqlNode asQuery, boolean isTemporary, boolean ifNotExists, boolean isCreateOrReplace) {
        super(isCreateOrReplace ? CREATE_OR_REPLACE_OPERATOR : REPLACE_OPERATOR, pos, true, ifNotExists);
        this.tableName = Objects.requireNonNull(tableName, "tableName should not be null");
        this.columnList = Objects.requireNonNull(columnList, "columnList should not be null");
        this.tableConstraints = Objects.requireNonNull(tableConstraints, "table constraints should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.distribution = distribution;
        this.partitionKeyList = Objects.requireNonNull(partitionKeyList, "partitionKeyList should not be null");
        this.watermark = watermark;
        this.comment = comment;
        this.isTemporary = isTemporary;
        this.asQuery = asQuery;
        this.isCreateOrReplace = isCreateOrReplace;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableName, this.columnList, new SqlNodeList(this.tableConstraints, SqlParserPos.ZERO), this.propertyList, this.partitionKeyList, this.watermark, this.comment, this.asQuery, new SqlNode[0]);
    }

    @Override
    public void validate() throws SqlValidateException {
        String errorMsg;
        if (!this.isSchemaWithColumnsIdentifiersOnly()) {
            SqlConstraintValidator.validateAndChangeColumnNullability(this.tableConstraints, this.columnList);
        }
        String string = errorMsg = this.isCreateOrReplace ? "CREATE OR REPLACE TABLE AS SELECT" : "REPLACE TABLE AS SELECT";
        if (this.isIfNotExists()) {
            throw new SqlValidateException(this.getParserPosition(), errorMsg + " syntax does not support IF NOT EXISTS statements yet.");
        }
        if (this.isTemporary()) {
            throw new SqlValidateException(this.getParserPosition(), errorMsg + " syntax does not support temporary table yet.");
        }
    }

    public SqlNode getAsQuery() {
        return this.asQuery;
    }

    public boolean isCreateOrReplace() {
        return this.isCreateOrReplace;
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlNodeList getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public List<SqlTableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    public Optional<SqlWatermark> getWatermark() {
        return Optional.ofNullable(this.watermark);
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isSchemaWithColumnsIdentifiersOnly() {
        return !this.columnList.isEmpty() && this.columnList.get(0) instanceof SqlIdentifier;
    }

    public List<SqlTableConstraint> getFullConstraints() {
        return SqlConstraintValidator.getFullConstraints(this.tableConstraints, this.columnList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.isCreateOrReplace) {
            writer.keyword("CREATE OR");
        }
        writer.keyword("REPLACE TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.propertyList.size() > 0) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.asQuery.unparse(writer, leftPrec, rightPrec);
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }
}

