/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.writer;

import com.aliyun.oss.model.PartETag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverable;

@Internal
public class OSSRecoverableSerializer
implements SimpleVersionedSerializer<OSSRecoverable> {
    static final OSSRecoverableSerializer INSTANCE = new OSSRecoverableSerializer();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final int MAGIC_NUMBER = -1737092556;

    private OSSRecoverableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(OSSRecoverable ossRecoverable) throws IOException {
        byte[] objectBytes = ossRecoverable.getObjectName().getBytes(CHARSET);
        byte[] uploadIdBytes = ossRecoverable.getUploadId().getBytes(CHARSET);
        byte[][] etags = new byte[ossRecoverable.getPartETags().size()][];
        int partEtagBytes = 0;
        for (int i = 0; i < ossRecoverable.getPartETags().size(); ++i) {
            etags[i] = ossRecoverable.getPartETags().get(i).getETag().getBytes(CHARSET);
            partEtagBytes += etags[i].length + 8;
        }
        String lastObjectKey = ossRecoverable.getLastPartObject();
        byte[] lastPartBytes = lastObjectKey == null ? null : lastObjectKey.getBytes(CHARSET);
        byte[] resultBytes = new byte[8 + objectBytes.length + 4 + uploadIdBytes.length + 4 + partEtagBytes + 8 + 4 + (lastPartBytes == null ? 0 : lastPartBytes.length) + 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(-1737092556);
        byteBuffer.putInt(objectBytes.length);
        byteBuffer.put(objectBytes);
        byteBuffer.putInt(uploadIdBytes.length);
        byteBuffer.put(uploadIdBytes);
        byteBuffer.putInt(etags.length);
        for (int i = 0; i < ossRecoverable.getPartETags().size(); ++i) {
            PartETag pe = ossRecoverable.getPartETags().get(i);
            byteBuffer.putInt(pe.getPartNumber());
            byteBuffer.putInt(etags[i].length);
            byteBuffer.put(etags[i]);
        }
        byteBuffer.putLong(ossRecoverable.getNumBytesInParts());
        if (lastPartBytes == null) {
            byteBuffer.putInt(0);
        } else {
            byteBuffer.putInt(lastPartBytes.length);
            byteBuffer.put(lastPartBytes);
        }
        byteBuffer.putLong(ossRecoverable.getLastPartObjectLength());
        return resultBytes;
    }

    public OSSRecoverable deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return this.deserializeV1(serialized);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private OSSRecoverable deserializeV1(byte[] serialized) throws IOException {
        String lastPart;
        ByteBuffer byteBuffer = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
        if (byteBuffer.getInt() != -1737092556) {
            throw new IOException("Corrupt data: Unexpected magic number " + byteBuffer.getInt());
        }
        byte[] objectBytes = new byte[byteBuffer.getInt()];
        byteBuffer.get(objectBytes);
        byte[] uploadIdBytes = new byte[byteBuffer.getInt()];
        byteBuffer.get(uploadIdBytes);
        int numParts = byteBuffer.getInt();
        ArrayList<PartETag> parts = new ArrayList<PartETag>(numParts);
        for (int i = 0; i < numParts; ++i) {
            int partNum = byteBuffer.getInt();
            byte[] buffer = new byte[byteBuffer.getInt()];
            byteBuffer.get(buffer);
            parts.add(new PartETag(partNum, new String(buffer, CHARSET)));
        }
        long numBytes = byteBuffer.getLong();
        int lastObjectArraySize = byteBuffer.getInt();
        if (lastObjectArraySize == 0) {
            lastPart = null;
        } else {
            byte[] lastPartBytes = new byte[lastObjectArraySize];
            byteBuffer.get(lastPartBytes);
            lastPart = new String(lastPartBytes, CHARSET);
        }
        long lastPartLength = byteBuffer.getLong();
        return new OSSRecoverable(new String(uploadIdBytes, CHARSET), new String(objectBytes, CHARSET), parts, lastPart, numBytes, lastPartLength);
    }
}

