/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.util.Optional;

public class SystemProperty {
    private static final String GEODE_PREFIX = "geode.";
    public static final String GEMFIRE_PREFIX = "gemfire.";
    public static final String DEFAULT_PREFIX = "geode.";

    public static Optional<Boolean> getProductBooleanProperty(String name) {
        String property = SystemProperty.getProperty(name);
        return property != null ? Optional.of(Boolean.parseBoolean(property)) : Optional.empty();
    }

    public static Optional<Integer> getProductIntegerProperty(String name) {
        Integer propertyValue = Integer.getInteger("geode." + name);
        if (propertyValue == null) {
            propertyValue = Integer.getInteger(GEMFIRE_PREFIX + name);
        }
        if (propertyValue != null) {
            return Optional.of(propertyValue);
        }
        return Optional.empty();
    }

    public static Integer getProductIntegerProperty(String name, int defaultValue) {
        return SystemProperty.getProductIntegerProperty(name).orElse(defaultValue);
    }

    public static Optional<Long> getProductLongProperty(String name) {
        Long propertyValue = Long.getLong("geode." + name);
        if (propertyValue == null) {
            propertyValue = Long.getLong(GEMFIRE_PREFIX + name);
        }
        if (propertyValue != null) {
            return Optional.of(propertyValue);
        }
        return Optional.empty();
    }

    public static Long getProductLongProperty(String name, long defaultValue) {
        return SystemProperty.getProductLongProperty(name).orElse(defaultValue);
    }

    public static Optional<String> getProductStringProperty(String name) {
        String property = SystemProperty.getProperty(name);
        return property != null ? Optional.of(property) : Optional.empty();
    }

    public static String getProperty(String name) {
        String property = SystemProperty.getGeodeProperty(name);
        return property != null ? property : SystemProperty.getGemfireProperty(name);
    }

    private static String getGeodeProperty(String name) {
        return System.getProperty("geode." + name);
    }

    private static String getGemfireProperty(String name) {
        return System.getProperty(GEMFIRE_PREFIX + name);
    }

    private SystemProperty() {
    }
}

