/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.io;

import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsPluginManager;
import grails.plugins.PluginManagerAware;
import grails.util.CollectionUtils;
import grails.util.Environment;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.gsp.GroovyPageBinding;
import org.grails.gsp.io.GroovyPageCompiledScriptSource;
import org.grails.gsp.io.GroovyPageLocator;
import org.grails.gsp.io.GroovyPageResourceScriptSource;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.plugins.BinaryGrailsPlugin;
import org.grails.taglib.TemplateVariableBinding;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class DefaultGroovyPageLocator
implements GroovyPageLocator,
ResourceLoaderAware,
ApplicationContextAware,
PluginManagerAware {
    private static final Log LOG = LogFactory.getLog(DefaultGroovyPageLocator.class);
    public static final String PATH_TO_WEB_INF_VIEWS = "/WEB-INF/grails-app/views";
    private static final String SLASHED_VIEWS_DIR_PATH = "/grails-app/views/";
    private static final String PLUGINS_PATH = "/plugins/";
    private static final String BLANK = "";
    protected Collection<ResourceLoader> resourceLoaders = new ConcurrentLinkedQueue<ResourceLoader>();
    protected GrailsPluginManager pluginManager;
    private ConcurrentMap<String, String> precompiledGspMap;
    protected boolean warDeployed = Environment.isWarDeployed();
    protected boolean reloadEnabled = !this.warDeployed;
    private Set<String> reloadedPrecompiledGspClassNames = new CopyOnWriteArraySet<String>();

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.addResourceLoader(resourceLoader);
    }

    @Override
    public void addResourceLoader(ResourceLoader resourceLoader) {
        if (resourceLoader != null && !this.resourceLoaders.contains(resourceLoader)) {
            this.resourceLoaders.add(resourceLoader);
        }
    }

    public void setPrecompiledGspMap(Map<String, String> precompiledGspMap) {
        this.precompiledGspMap = precompiledGspMap == null ? null : new ConcurrentHashMap<String, String>(precompiledGspMap);
    }

    @Override
    public GroovyPageScriptSource findPage(String uri) {
        GroovyPageScriptSource scriptSource = this.findResourceScriptSource(uri);
        if (scriptSource == null) {
            scriptSource = this.findBinaryScriptSource(uri);
        }
        if (scriptSource == null) {
            scriptSource = this.findResourceScriptSourceInPlugins(uri);
        }
        return scriptSource;
    }

    protected Resource findReloadablePage(String uri) {
        Resource resource = this.findResource(uri);
        if (resource == null) {
            resource = this.findResourceInPlugins(uri);
        }
        return resource;
    }

    @Override
    public GroovyPageScriptSource findPageInBinding(String pluginName, String uri, TemplateVariableBinding binding) {
        GrailsPlugin grailsPlugin;
        GroovyPageScriptSource scriptSource = null;
        String contextPath = this.resolveContextPath(pluginName, uri, binding);
        String fullURI = GrailsResourceUtils.appendPiecesForUri(contextPath, uri);
        if (this.pluginManager != null && (grailsPlugin = this.pluginManager.getGrailsPlugin(pluginName)) instanceof BinaryGrailsPlugin) {
            BinaryGrailsPlugin binaryGrailsPlugin = (BinaryGrailsPlugin)grailsPlugin;
            File projectDirectory = binaryGrailsPlugin.getProjectDirectory();
            if (projectDirectory != null) {
                File f = new File(projectDirectory, "grails-app/views/" + uri);
                if (f.exists()) {
                    scriptSource = new GroovyPageResourceScriptSource(uri, new FileSystemResource(f));
                }
            } else {
                scriptSource = this.resolveViewInBinaryPlugin(binaryGrailsPlugin, uri);
            }
        }
        if (scriptSource == null) {
            scriptSource = this.findPageInBinding(fullURI, binding);
        }
        if (scriptSource == null) {
            scriptSource = this.findResourceScriptSource(uri);
        }
        if (scriptSource == null) {
            contextPath = this.resolveContextPath(pluginName, uri, binding, true);
            scriptSource = this.findPageInBinding(GrailsResourceUtils.appendPiecesForUri(contextPath, uri), binding);
        }
        return scriptSource;
    }

    protected String resolveContextPath(String pluginName, String uri, TemplateVariableBinding binding) {
        return this.resolveContextPath(pluginName, uri, binding, false);
    }

    protected String resolveContextPath(String pluginName, String uri, TemplateVariableBinding binding, boolean forceCamelCase) {
        String pluginContextPath;
        String contextPath = null;
        contextPath = uri.startsWith(PLUGINS_PATH) ? BLANK : (pluginName != null && this.pluginManager != null ? this.pluginManager.getPluginPath(pluginName) : (binding instanceof GroovyPageBinding ? ((pluginContextPath = ((GroovyPageBinding)binding).getPluginContextPath()) != null ? pluginContextPath : BLANK) : BLANK));
        return contextPath;
    }

    @Override
    public void removePrecompiledPage(GroovyPageCompiledScriptSource scriptSource) {
        this.reloadedPrecompiledGspClassNames.add(scriptSource.getCompiledClass().getName());
        if (scriptSource.getURI() != null && this.precompiledGspMap != null) {
            this.precompiledGspMap.remove(scriptSource.getURI());
        }
    }

    @Override
    public GroovyPageScriptSource findPageInBinding(String uri, TemplateVariableBinding binding) {
        GroovyPageScriptSource scriptSource = this.findResourceScriptSource(uri);
        if (scriptSource == null) {
            GrailsPlugin pagePlugin;
            GrailsPlugin grailsPlugin = pagePlugin = binding instanceof GroovyPageBinding ? ((GroovyPageBinding)binding).getPagePlugin() : null;
            if (pagePlugin instanceof BinaryGrailsPlugin) {
                BinaryGrailsPlugin binaryPlugin = (BinaryGrailsPlugin)pagePlugin;
                scriptSource = this.resolveViewInBinaryPlugin(binaryPlugin, uri);
            } else if (pagePlugin != null) {
                scriptSource = this.findResourceScriptSource(this.resolvePluginViewPath(uri, pagePlugin));
            }
        }
        if (scriptSource == null) {
            scriptSource = this.findBinaryScriptSource(uri);
        }
        return scriptSource;
    }

    protected GroovyPageScriptSource resolveViewInBinaryPlugin(BinaryGrailsPlugin binaryPlugin, String uri) {
        GroovyPageCompiledScriptSource scriptSource = null;
        uri = this.removeViewLocationPrefixes(uri);
        Class viewClass = binaryPlugin.resolveView(uri = GrailsResourceUtils.appendPiecesForUri(PATH_TO_WEB_INF_VIEWS, uri));
        if (viewClass != null && !this.reloadedPrecompiledGspClassNames.contains(viewClass.getName())) {
            scriptSource = this.createGroovyPageCompiledScriptSource(uri, uri, viewClass);
            scriptSource.setResourceCallable(null);
        }
        return scriptSource;
    }

    protected GroovyPageCompiledScriptSource createGroovyPageCompiledScriptSource(final String uri, String fullPath, Class<?> viewClass) {
        GroovyPageCompiledScriptSource scriptSource = new GroovyPageCompiledScriptSource(uri, fullPath, viewClass);
        if (this.reloadEnabled) {
            scriptSource.setResourceCallable(new PrivilegedAction<Resource>(){

                @Override
                public Resource run() {
                    return DefaultGroovyPageLocator.this.findReloadablePage(uri);
                }
            });
        }
        return scriptSource;
    }

    protected GroovyPageScriptSource findBinaryScriptSource(String uri) {
        if (this.pluginManager == null) {
            return null;
        }
        List<GrailsPlugin> allPlugins = Arrays.asList(this.pluginManager.getAllPlugins());
        Collections.reverse(allPlugins);
        for (GrailsPlugin plugin2 : allPlugins) {
            GroovyPageScriptSource scriptSource;
            if (!(plugin2 instanceof BinaryGrailsPlugin)) continue;
            BinaryGrailsPlugin binaryPlugin = (BinaryGrailsPlugin)plugin2;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Searching plugin [%s] for GSP view [%s]", plugin2.getName(), uri));
            }
            if ((scriptSource = this.resolveViewInBinaryPlugin(binaryPlugin, uri)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Found GSP view [%s] in plugin [%s]", uri, plugin2.getName()));
                }
                return scriptSource;
            }
            if (binaryPlugin.getProjectDirectory() == null || (scriptSource = this.resolveViewInPluginProjectDirectory(binaryPlugin, uri)) == null) continue;
            return scriptSource;
        }
        return null;
    }

    private GroovyPageScriptSource resolveViewInPluginProjectDirectory(BinaryGrailsPlugin binaryPlugin, String uri) {
        File projectDirectory = binaryPlugin.getProjectDirectory();
        File f = new File(projectDirectory, "grails-app/views" + uri);
        if (f.exists()) {
            return new GroovyPageResourceScriptSource(uri, new FileSystemResource(f));
        }
        return null;
    }

    protected GroovyPageScriptSource findResourceScriptSourceInPlugins(String uri) {
        if (this.pluginManager == null) {
            return null;
        }
        for (GrailsPlugin plugin2 : this.pluginManager.getAllPlugins()) {
            GroovyPageScriptSource scriptSource;
            if (plugin2 instanceof BinaryGrailsPlugin || (scriptSource = this.findResourceScriptSource(this.resolvePluginViewPath(uri, plugin2))) == null) continue;
            return scriptSource;
        }
        return null;
    }

    protected Resource findResourceInPlugins(String uri) {
        if (this.pluginManager == null) {
            return null;
        }
        for (GrailsPlugin plugin2 : this.pluginManager.getAllPlugins()) {
            Resource resource;
            if (plugin2 instanceof BinaryGrailsPlugin || (resource = this.findResource(this.resolvePluginViewPath(uri, plugin2))) == null) continue;
            return resource;
        }
        return null;
    }

    protected String resolvePluginViewPath(String uri, GrailsPlugin plugin2) {
        uri = this.removeViewLocationPrefixes(uri);
        return GrailsResourceUtils.appendPiecesForUri(plugin2.getPluginPath(), "grails-app/views/", uri);
    }

    protected String removeViewLocationPrefixes(String uri) {
        uri = this.removePrefix(uri, "/WEB-INF");
        uri = this.removePrefix(uri, SLASHED_VIEWS_DIR_PATH);
        uri = this.removePrefix(uri, "grails-app/views/");
        return uri;
    }

    protected String removePrefix(String uri, String prefix) {
        if (uri.startsWith(prefix)) {
            uri = uri.substring(prefix.length());
        }
        return uri;
    }

    protected GroovyPageScriptSource findResourceScriptSource(String uri) {
        List<String> searchPaths = this.resolveSearchPaths(uri);
        return this.findResourceScriptPathForSearchPaths(uri, searchPaths);
    }

    protected List<String> resolveSearchPaths(String uri) {
        List<String> searchPaths = null;
        uri = this.removeViewLocationPrefixes(uri);
        if (this.warDeployed) {
            if (uri.startsWith(PLUGINS_PATH)) {
                PluginViewPathInfo pathInfo = DefaultGroovyPageLocator.getPluginViewPathInfo(uri);
                searchPaths = CollectionUtils.newList(GrailsResourceUtils.appendPiecesForUri("/WEB-INF", PLUGINS_PATH, pathInfo.pluginName, "grails-app/views/", pathInfo.path), GrailsResourceUtils.appendPiecesForUri("/WEB-INF", uri), uri);
            } else {
                searchPaths = CollectionUtils.newList(GrailsResourceUtils.appendPiecesForUri(PATH_TO_WEB_INF_VIEWS, uri), uri);
            }
        } else {
            searchPaths = CollectionUtils.newList(GrailsResourceUtils.appendPiecesForUri(SLASHED_VIEWS_DIR_PATH, uri), GrailsResourceUtils.appendPiecesForUri(PATH_TO_WEB_INF_VIEWS, uri), uri);
        }
        return searchPaths;
    }

    protected GroovyPageScriptSource findResourceScriptPathForSearchPaths(String uri, List<String> searchPaths) {
        Resource foundResource;
        if (this.isPrecompiledAvailable()) {
            for (String searchPath : searchPaths) {
                String gspClassName = (String)this.precompiledGspMap.get(searchPath);
                if (gspClassName == null || this.reloadedPrecompiledGspClassNames.contains(gspClassName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Found pre-compiled GSP template [%s] for path [%s]", gspClassName, searchPath));
                }
                Class<?> gspClass = null;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Loading GSP template [%s]", gspClassName));
                    }
                    gspClass = Class.forName(gspClassName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Cannot load class " + gspClassName + ". Resuming on non-precompiled implementation.", e);
                }
                if (gspClass == null) continue;
                GroovyPageCompiledScriptSource groovyPageCompiledScriptSource = this.createGroovyPageCompiledScriptSource(uri, searchPath, gspClass);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Returning new GSP script source for class [%s]", gspClassName));
                }
                return groovyPageCompiledScriptSource;
            }
        }
        return (foundResource = this.findResource(searchPaths)) == null ? null : new GroovyPageResourceScriptSource(uri, foundResource);
    }

    protected Resource findResource(String uri) {
        return this.findResource(this.resolveSearchPaths(uri));
    }

    protected Resource findResource(List<String> searchPaths) {
        Resource foundResource = null;
        for (ResourceLoader loader : this.resourceLoaders) {
            for (String path : searchPaths) {
                Resource resource = loader.getResource(path);
                if (resource == null || !resource.exists()) continue;
                foundResource = resource;
                break;
            }
            if (foundResource == null) continue;
            break;
        }
        return foundResource;
    }

    private boolean isPrecompiledAvailable() {
        return this.precompiledGspMap != null && this.precompiledGspMap.size() > 0 && !Environment.isDevelopmentMode();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.addResourceLoader(applicationContext);
    }

    @Override
    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public static PluginViewPathInfo getPluginViewPathInfo(String uri) {
        return new PluginViewPathInfo(uri);
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public static class PluginViewPathInfo {
        public String basePath;
        public String pluginName;
        public String path;

        public PluginViewPathInfo(String uri) {
            this.basePath = uri.substring(DefaultGroovyPageLocator.PLUGINS_PATH.length(), uri.length());
            int i2 = this.basePath.indexOf("/");
            if (i2 > -1) {
                this.pluginName = this.basePath.substring(0, i2);
                this.path = this.basePath.substring(i2, this.basePath.length());
            }
        }
    }
}

