/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.time.Duration;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConsumerAwareRebalanceListener;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;

public class ConcurrentKafkaListenerContainerFactoryConfigurer {
    private KafkaProperties properties;
    private BatchMessageConverter batchMessageConverter;
    private RecordMessageConverter recordMessageConverter;
    private RecordFilterStrategy<Object, Object> recordFilterStrategy;
    private KafkaTemplate<Object, Object> replyTemplate;
    private KafkaAwareTransactionManager<Object, Object> transactionManager;
    private ConsumerAwareRebalanceListener rebalanceListener;
    private CommonErrorHandler commonErrorHandler;
    private AfterRollbackProcessor<Object, Object> afterRollbackProcessor;
    private RecordInterceptor<Object, Object> recordInterceptor;
    private BatchInterceptor<Object, Object> batchInterceptor;
    private Function<MessageListenerContainer, String> threadNameSupplier;
    private SimpleAsyncTaskExecutor listenerTaskExecutor;

    void setKafkaProperties(KafkaProperties properties) {
        this.properties = properties;
    }

    void setBatchMessageConverter(BatchMessageConverter batchMessageConverter) {
        this.batchMessageConverter = batchMessageConverter;
    }

    void setRecordMessageConverter(RecordMessageConverter recordMessageConverter) {
        this.recordMessageConverter = recordMessageConverter;
    }

    void setRecordFilterStrategy(RecordFilterStrategy<Object, Object> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    void setReplyTemplate(KafkaTemplate<Object, Object> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    void setTransactionManager(KafkaAwareTransactionManager<Object, Object> transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setRebalanceListener(ConsumerAwareRebalanceListener rebalanceListener) {
        this.rebalanceListener = rebalanceListener;
    }

    public void setCommonErrorHandler(CommonErrorHandler commonErrorHandler) {
        this.commonErrorHandler = commonErrorHandler;
    }

    void setAfterRollbackProcessor(AfterRollbackProcessor<Object, Object> afterRollbackProcessor) {
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    void setRecordInterceptor(RecordInterceptor<Object, Object> recordInterceptor) {
        this.recordInterceptor = recordInterceptor;
    }

    void setBatchInterceptor(BatchInterceptor<Object, Object> batchInterceptor) {
        this.batchInterceptor = batchInterceptor;
    }

    void setThreadNameSupplier(Function<MessageListenerContainer, String> threadNameSupplier) {
        this.threadNameSupplier = threadNameSupplier;
    }

    void setListenerTaskExecutor(SimpleAsyncTaskExecutor listenerTaskExecutor) {
        this.listenerTaskExecutor = listenerTaskExecutor;
    }

    public void configure(ConcurrentKafkaListenerContainerFactory<Object, Object> listenerFactory, ConsumerFactory<Object, Object> consumerFactory) {
        listenerFactory.setConsumerFactory(consumerFactory);
        this.configureListenerFactory(listenerFactory);
        this.configureContainer(listenerFactory.getContainerProperties());
    }

    private void configureListenerFactory(ConcurrentKafkaListenerContainerFactory<Object, Object> factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        KafkaProperties.Listener properties = this.properties.getListener();
        map.from(properties::getConcurrency).to(arg_0 -> factory.setConcurrency(arg_0));
        map.from(properties::isAutoStartup).to(arg_0 -> factory.setAutoStartup(arg_0));
        map.from(this.batchMessageConverter).to(arg_0 -> factory.setBatchMessageConverter(arg_0));
        map.from(this.recordMessageConverter).to(arg_0 -> factory.setRecordMessageConverter(arg_0));
        map.from(this.recordFilterStrategy).to(arg_0 -> factory.setRecordFilterStrategy(arg_0));
        map.from(this.replyTemplate).to(arg_0 -> factory.setReplyTemplate(arg_0));
        if (properties.getType().equals((Object)KafkaProperties.Listener.Type.BATCH)) {
            factory.setBatchListener(Boolean.valueOf(true));
        }
        map.from(this.commonErrorHandler).to(arg_0 -> factory.setCommonErrorHandler(arg_0));
        map.from(this.afterRollbackProcessor).to(arg_0 -> factory.setAfterRollbackProcessor(arg_0));
        map.from(this.recordInterceptor).to(arg_0 -> factory.setRecordInterceptor(arg_0));
        map.from(this.batchInterceptor).to(arg_0 -> factory.setBatchInterceptor(arg_0));
        map.from(this.threadNameSupplier).to(arg_0 -> factory.setThreadNameSupplier(arg_0));
        map.from(properties::getChangeConsumerThreadName).to(arg_0 -> factory.setChangeConsumerThreadName(arg_0));
    }

    private void configureContainer(ContainerProperties container) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        KafkaProperties.Listener properties = this.properties.getListener();
        map.from(properties::getAckMode).to(arg_0 -> ((ContainerProperties)container).setAckMode(arg_0));
        map.from(properties::getAsyncAcks).to(arg_0 -> ((ContainerProperties)container).setAsyncAcks(arg_0));
        map.from(properties::getClientId).to(arg_0 -> ((ContainerProperties)container).setClientId(arg_0));
        map.from(properties::getAckCount).to(arg_0 -> ((ContainerProperties)container).setAckCount(arg_0));
        map.from(properties::getAckTime).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setAckTime(arg_0));
        map.from(properties::getPollTimeout).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setPollTimeout(arg_0));
        map.from(properties::getNoPollThreshold).to(arg_0 -> ((ContainerProperties)container).setNoPollThreshold(arg_0));
        map.from(properties.getIdleBetweenPolls()).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setIdleBetweenPolls(arg_0));
        map.from(properties::getIdleEventInterval).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setIdleEventInterval(arg_0));
        map.from(properties::getIdlePartitionEventInterval).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setIdlePartitionEventInterval(arg_0));
        map.from(properties::getMonitorInterval).as(Duration::getSeconds).as(Number::intValue).to(arg_0 -> ((ContainerProperties)container).setMonitorInterval(arg_0));
        map.from(properties::getLogContainerConfig).to(arg_0 -> ((ContainerProperties)container).setLogContainerConfig(arg_0));
        map.from(properties::isMissingTopicsFatal).to(arg_0 -> ((ContainerProperties)container).setMissingTopicsFatal(arg_0));
        map.from(properties::isImmediateStop).to(arg_0 -> ((ContainerProperties)container).setStopImmediate(arg_0));
        map.from(properties::isObservationEnabled).to(arg_0 -> ((ContainerProperties)container).setObservationEnabled(arg_0));
        map.from(properties::getAuthExceptionRetryInterval).to(arg_0 -> ((ContainerProperties)container).setAuthExceptionRetryInterval(arg_0));
        map.from(this.transactionManager).to(arg_0 -> ((ContainerProperties)container).setKafkaAwareTransactionManager(arg_0));
        map.from(this.rebalanceListener).to(arg_0 -> ((ContainerProperties)container).setConsumerRebalanceListener(arg_0));
        map.from(this.listenerTaskExecutor).to(arg_0 -> ((ContainerProperties)container).setListenerTaskExecutor(arg_0));
    }
}

