/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerializableSupplier;

public class ValueEqualiserSupplier
implements SerializableSupplier<RecordEqualiser> {
    private static final long serialVersionUID = 1L;
    private final List<DataType> fieldTypes;
    private final int[] projection;

    public ValueEqualiserSupplier(RowType keyType) {
        this.fieldTypes = keyType.getFieldTypes();
        this.projection = null;
    }

    public ValueEqualiserSupplier(RowType keyType, int[] projection) {
        this.fieldTypes = keyType.getFieldTypes();
        this.projection = projection;
    }

    @Override
    public RecordEqualiser get() {
        return this.projection == null ? CodeGenUtils.newRecordEqualiser(this.fieldTypes) : CodeGenUtils.newRecordEqualiser(this.fieldTypes, this.projection);
    }

    public static ValueEqualiserSupplier fromIgnoreFields(RowType rowType, @Nullable List<String> ignoreFields) {
        int[] projection = null;
        if (ignoreFields != null) {
            List fieldNames = rowType.getFieldNames();
            projection = IntStream.range(0, rowType.getFieldCount()).filter(idx -> !ignoreFields.contains(fieldNames.get(idx))).toArray();
        }
        return new ValueEqualiserSupplier(rowType, projection);
    }
}

